/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.vec.BlockCoord;
import codechicken.wirelessredstone.core.ITileWireless;

public class FreqChunkPosition
implements Comparable {
    public int x;
    public int y;
    public int z;
    public int freq;

    public FreqChunkPosition(int x, int y, int z, int freq) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.freq = freq;
    }

    public FreqChunkPosition(ITileWireless itile) {
        any tile = (any)itile;
        this.x = tile.l;
        this.y = tile.m;
        this.z = tile.n;
        this.freq = itile.getFreq();
    }

    public FreqChunkPosition(BlockCoord node, int freq) {
        this.x = node.x;
        this.y = node.y;
        this.z = node.z;
        this.freq = freq;
    }

    public int compareTo(FreqChunkPosition node2) {
        if (this.freq == node2.freq) {
            if (this.x == node2.x) {
                if (this.z == node2.z) {
                    if (this.y == node2.y) {
                        return 0;
                    }
                    return this.y < node2.y ? -1 : 1;
                }
                return this.z < node2.z ? -1 : 1;
            }
            return this.x < node2.x ? -1 : 1;
        }
        return this.freq < node2.freq ? -1 : 1;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + " on " + this.freq + "]";
    }
}

