/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.vec.BlockCoord;
import codechicken.core.vec.Vector3;
import codechicken.wirelessredstone.core.IRedstoneEtherLoad;
import codechicken.wirelessredstone.core.ITileJammer;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RedstoneEtherFrequency;
import codechicken.wirelessredstone.core.SaveManager;
import codechicken.wirelessredstone.core.WRCoreServerPacketHandler;
import codechicken.wirelessredstone.core.WirelessReceivingDevice;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class RedstoneEtherServer
extends RedstoneEther {
    public RedstoneEtherServer(yc world) {
        super(world);
        SaveManager.resetWorld(world);
        SaveManager.loadFreqInfo();
        SaveManager.loadDimensionHash();
        this.publicfrequencyend = SaveManager.generalProp.getProperty("PublicFrequencies", 1000);
        this.sharedfrequencyend = SaveManager.generalProp.getProperty("SharedFrequencies", 5000);
        this.numprivatefreqs = SaveManager.generalProp.getProperty("PrivateFrequencies", 50);
    }

    @Override
    protected void addEther(yc world, int dimension) {
        if (this.ethers.get(dimension) != null) {
            return;
        }
        super.addEther(world, dimension);
        SaveManager.reloadSave(world, dimension);
        SaveManager.getInstance(dimension).loadEther();
    }

    @Override
    public void remEther(yc world, int dimension) {
        if (this.ethers.get(dimension) == null) {
            return;
        }
        super.remEther(world, dimension);
        SaveManager.unloadSave(dimension);
    }

    public void saveEther(yc world) {
        int dimension = CommonUtils.getDimension((yc)world);
        for (RedstoneEtherFrequency freq : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave) {
            freq.saveFreq(dimension);
        }
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave.clear();
        SaveManager.getInstance(dimension).removeTrailingSectors();
        SaveManager.saveDimensionHash();
    }

    public void verifyChunkTransmitters(yc world, int chunkx, int chunkz) {
        int dimension = CommonUtils.getDimension((yc)world);
        RedstoneEther.DimensionalEtherHash ether = (RedstoneEther.DimensionalEtherHash)this.ethers.get(dimension);
        int blockxmin = chunkx * 16;
        int blockxmax = blockxmin + 15;
        int blockzmin = chunkz * 16;
        int blockzmax = blockzmin + 15;
        ArrayList transmittingblocks = new ArrayList(ether.transmittingblocks.keySet());
        for (BlockCoord node : transmittingblocks) {
            if (node.x < blockxmin || node.x > blockxmax || node.z < blockzmin || node.z > blockzmax) continue;
            any tile = RedstoneEther.getTile(world, node);
            int freq = ((RedstoneEther.TXNodeInfo)ether.transmittingblocks.get((Object)node)).freq;
            if (tile != null && tile instanceof ITileWireless && ((ITileWireless)tile).getFreq() == freq) continue;
            this.remTransmitter(world, node.x, node.y, node.z, freq);
            System.out.println("Removed Badly Synced node at:" + node.x + "," + node.y + "," + node.z + " on " + freq + " in dim" + dimension);
        }
    }

    public void setTransmitter(yc world, int x, int y, int z, int freq, boolean on) {
        RedstoneEther.TXNodeInfo info;
        if (freq == 0) {
            return;
        }
        BlockCoord node = new BlockCoord(x, y, z);
        int dimension = CommonUtils.getDimension((yc)world);
        if (this.isNodeInAOEofJammer(node, dimension)) {
            this.jamNodeSometime(world, node, dimension, freq);
        }
        if ((info = (RedstoneEther.TXNodeInfo)((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.get(node)) == null) {
            ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.put(node, new RedstoneEther.TXNodeInfo(freq, on));
        } else {
            info.on = on;
        }
        this.freqarray[freq].setTransmitter(world, node, dimension, on);
    }

    public void remTransmitter(yc world, int x, int y, int z, int freq) {
        if (freq == 0) {
            return;
        }
        int dimension = CommonUtils.getDimension((yc)world);
        BlockCoord node = new BlockCoord(x, y, z);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.remove(node);
        this.freqarray[freq].remTransmitter(world, node, dimension);
    }

    public void addReceiver(yc world, int x, int y, int z, int freq) {
        if (freq == 0) {
            return;
        }
        BlockCoord node = new BlockCoord(x, y, z);
        int dimension = CommonUtils.getDimension((yc)world);
        if (this.isNodeInAOEofJammer(node, dimension)) {
            this.jamNodeSometime(world, node, dimension, freq);
        }
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).recievingblocks.put(node, freq);
        this.freqarray[freq].addReceiver(world, node, dimension);
    }

    public void remReceiver(yc world, int x, int y, int z, int freq) {
        if (freq == 0) {
            return;
        }
        int dimension = CommonUtils.getDimension((yc)world);
        BlockCoord node = new BlockCoord(x, y, z);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).recievingblocks.remove(node);
        this.freqarray[freq].remReceiver(world, node, dimension);
    }

    public void addJammer(yc world, int x, int y, int z) {
        int dimension = CommonUtils.getDimension((yc)world);
        BlockCoord jammer = new BlockCoord(x, y, z);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset.add(jammer);
        this.jamNodesInAOEOfJammer(world, jammer, dimension);
    }

    public void remJammer(yc world, int x, int y, int z) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)CommonUtils.getDimension((yc)world)))).jammerset.remove(new BlockCoord(x, y, z));
    }

    public static void addToLoadList(yc world, int x, int y, int z, IRedstoneEtherLoad tile) {
        RedstoneEtherServer.loadServerWorld(world);
        RedstoneEtherServer.server()._addToLoadList(world, x, y, z, tile);
    }

    private void _addToLoadList(yc world, int x, int y, int z, IRedstoneEtherLoad tile) {
        int dimension = CommonUtils.getDimension((yc)world);
        if (this.processingAddittions == dimension) {
            this.backupmap.put(new BlockCoord(x, y, z), tile.getLoadTicks());
        } else {
            ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).wirelessloadlist.put(new BlockCoord(x, y, z), tile.getLoadTicks());
        }
    }

    public boolean isNodeJammed(yc world, int x, int y, int z) {
        Integer timeout = (Integer)((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)CommonUtils.getDimension((yc)world)))).jammednodes.get(new BlockCoord(x, y, z));
        return timeout != null && timeout > 0;
    }

    public boolean isNodeInAOEofJammer(BlockCoord node, int dimension) {
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            if (RedstoneEtherServer.pythagorasPow2(jammer, node) >= jammerrangePow2) continue;
            return true;
        }
        return false;
    }

    public boolean isPointInAOEofJammer(Vector3 point, int dimension) {
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            if (!(RedstoneEtherServer.pythagorasPow2(jammer, point) < (double)jammerrangePow2)) continue;
            return true;
        }
        return false;
    }

    public BlockCoord getClosestJammer(BlockCoord node, int dimension) {
        BlockCoord closestjammer = null;
        double closestdist = jammerrangePow2;
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            double distance = RedstoneEtherServer.pythagorasPow2(jammer, node);
            if (!(distance < closestdist)) continue;
            closestjammer = jammer;
            closestdist = distance;
        }
        return closestjammer;
    }

    public BlockCoord getClosestJammer(Vector3 point, int dimension) {
        BlockCoord closestjammer = null;
        double closestdist = jammerrangePow2;
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            double distance = RedstoneEtherServer.pythagorasPow2(jammer, point);
            if (!(distance < closestdist)) continue;
            closestjammer = jammer;
            closestdist = distance;
        }
        return closestjammer;
    }

    public void jamNodeSometime(yc world, BlockCoord node, int dimension, int freq) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.put(node, -world.t.nextInt(jammerblockwait));
    }

    public void jamEntitySometime(md entity) {
        this.jammedentities.put(entity, -entity.p.t.nextInt(jammerentitywait));
    }

    public void jamNode(yc world, BlockCoord node, int dimension, int freq) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.put(node, RedstoneEtherServer.getRandomTimeout(world.t));
        this.freqarray[freq].remTransmitter(world, node, dimension);
        this.freqarray[freq].remReceiver(world, node, dimension);
    }

    public void jamNode(yc world, int x, int y, int z, int freq) {
        if (freq == 0) {
            return;
        }
        this.jamNode(world, new BlockCoord(x, y, z), CommonUtils.getDimension((yc)world), freq);
    }

    @Override
    public void jamEntity(md entity, boolean jam) {
        if (jam) {
            this.jammedentities.put(entity, RedstoneEtherServer.getRandomTimeout(entity.p.t));
        }
        if (entity instanceof qx) {
            WRCoreServerPacketHandler.sendJamPlayerPacketTo((qx)entity, jam);
        }
    }

    public void jamNodesInAOEOfJammer(yc world, BlockCoord jammer, int dimension) {
        int freq = 1;
        while (freq <= 5000) {
            TreeMap transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockCoord node : transmittermap.keySet()) {
                if (RedstoneEtherServer.pythagorasPow2(node, jammer) >= jammerrangePow2) continue;
                this.jamNodeSometime(world, node, dimension, freq);
            }
            TreeSet receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockCoord node : receiverset) {
                if (RedstoneEtherServer.pythagorasPow2(node, jammer) >= jammerrangePow2) continue;
                this.jamNodeSometime(world, node, dimension, freq);
            }
            ++freq;
        }
    }

    public void unjamTile(yc world, int x, int y, int z) {
        BlockCoord node = new BlockCoord(x, y, z);
        int dimension = CommonUtils.getDimension((yc)world);
        Integer timeout = (Integer)((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        if (timeout != null && timeout >= 0) {
            ITileWireless tile = (ITileWireless)RedstoneEtherServer.getTile(world, node);
            tile.unjamTile();
        }
    }

    public void saveJammedFrequencies(String username) {
        String jammedfreqs = this.getJammedFrequencies(username = username.toLowerCase());
        if (jammedfreqs.equals(this.sharedfrequencyend + 1 + "-" + 5000)) {
            SaveManager.generalProp.removeProperty(String.valueOf(username) + ".jammedFreqs");
        } else {
            SaveManager.generalProp.setProperty(String.valueOf(username) + ".jammedFreqs", jammedfreqs);
        }
    }

    public void loadJammedFrequencies(String jammedString, String username) {
        String[] freqranges = jammedString.split(",");
        int i = 0;
        while (i < freqranges.length) {
            block6: {
                int startfreq;
                int endfreq;
                String[] currentrange = freqranges[i].split("-");
                if (currentrange.length == 1) {
                    try {
                        startfreq = endfreq = Integer.parseInt(currentrange[0]);
                    }
                    catch (NumberFormatException numberformatexception) {
                        break block6;
                    }
                }
                try {
                    startfreq = Integer.parseInt(currentrange[0]);
                    endfreq = Integer.parseInt(currentrange[1]);
                }
                catch (NumberFormatException numberformatexception1) {
                    break block6;
                }
                this.setFrequencyRange(username, startfreq, endfreq, true);
            }
            ++i;
        }
    }

    @Override
    protected void loadJammedFrequencies(String username) {
        String openstring = SaveManager.generalProp.getProperty(String.valueOf(username) + ".jammedFreqs");
        if (openstring == null) {
            this.jamDefaultRange(username);
        } else {
            this.loadJammedFrequencies(openstring, username);
        }
    }

    public void setFrequencyRangeCommand(String username, int startfreq, int endfreq, boolean flag) {
        this.setFrequencyRange(username, startfreq, endfreq, flag);
        this.saveJammedFrequencies(username);
    }

    public void jamAllFrequencies(String username) {
        this.setFrequencyRange(username, 1, 5000, true);
    }

    public void jamDefaultRange(String username) {
        this.setFrequencyRange(username, 1, 5000, false);
        this.setFrequencyRange(username, this.sharedfrequencyend + 1, 5000, true);
    }

    public void setFreqClean(int freq, int dimension) {
        this.freqarray[freq].setClean(dimension);
    }

    public void resetPlayer(qx player) {
        WRCoreServerPacketHandler.sendPublicFrequencyTo(player, this.publicfrequencyend);
        WRCoreServerPacketHandler.sendSharedFrequencyTo(player, this.sharedfrequencyend);
        String openstring = SaveManager.generalProp.getProperty(String.valueOf(player.bR) + ".jammedFreqs");
        if (openstring == null) {
            this.jamDefaultRange(player.bR);
        } else {
            this.loadJammedFrequencies(openstring, player.bR);
        }
        this.sendFreqInfoTo(player);
        this.sendPrivateFreqsTo(player);
    }

    public void removePlayer(qx player) {
        this.playerJammedMap.remove(player.bR);
    }

    private void sendFreqInfoTo(qx player) {
        ArrayList<Integer> freqsWithInfo = new ArrayList<Integer>();
        int freq = 1;
        while (freq <= 5000) {
            if (!this.freqarray[freq].getName().equals("") || this.freqarray[freq].getColourId() != -1) {
                freqsWithInfo.add(freq);
            }
            ++freq;
        }
        WRCoreServerPacketHandler.sendFreqInfoTo(player, freqsWithInfo);
    }

    private void sendPrivateFreqsTo(qx player) {
        ArrayList<Integer> freqsWithOwners = new ArrayList<Integer>();
        int freq = 1;
        while (freq <= 5000) {
            if (this.isFreqPrivate(freq)) {
                freqsWithOwners.add(freq);
            }
            ++freq;
        }
        WRCoreServerPacketHandler.sendFreqOwnerTo(player, freqsWithOwners);
    }

    public TreeMap getLoadedFrequencies() {
        TreeMap<Integer, Integer> treemap = new TreeMap<Integer, Integer>();
        int freq = 1;
        while (freq <= 5000) {
            if (this.freqarray[freq].nodeCount() != 0) {
                treemap.put(freq, this.freqarray[freq].getActiveTransmitters());
            }
            ++freq;
        }
        return treemap;
    }

    public Map getTransmittersOnFreq(int freq, int dimension) {
        return Collections.unmodifiableMap(this.freqarray[freq].getTransmitters(dimension));
    }

    public Collection getReceiversOnFreq(int freq, int dimension) {
        return Collections.unmodifiableCollection(this.freqarray[freq].getReceivers(dimension));
    }

    public Map getTransmittersInDimension(int dimension) {
        return Collections.unmodifiableMap(((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks);
    }

    public Set getTransmittingDevicesInDimension(int dimension) {
        return Collections.unmodifiableSet(((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingdevices);
    }

    public ArrayList getActiveTransmittersOnFreq(int freq, int dimension) {
        ArrayList txnodes = new ArrayList();
        this.freqarray[freq].putActiveTransmittersInList(dimension, txnodes);
        return txnodes;
    }

    public TreeSet getJammers(int dimension) {
        return ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset;
    }

    public TreeMap getJammedNodes(int dimension) {
        return ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes;
    }

    public TreeSet getNodesInRangeofPoint(int dimension, Vector3 point, float range, boolean includejammed) {
        TreeSet<BlockCoord> nodes = new TreeSet<BlockCoord>();
        float rangePow2 = range * range;
        int freq = 1;
        while (freq <= 5000) {
            TreeMap transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockCoord node : transmittermap.keySet()) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
            TreeSet receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockCoord node : receiverset) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
            ++freq;
        }
        if (includejammed) {
            for (BlockCoord node : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.keySet()) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public TreeSet getNodesInRangeofNode(int dimension, BlockCoord block, float range, boolean includejammed) {
        TreeSet<BlockCoord> nodes = new TreeSet<BlockCoord>();
        float rangePow2 = range * range;
        int freq = 1;
        while (freq <= 5000) {
            TreeMap transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockCoord node : transmittermap.keySet()) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
            TreeSet receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockCoord node : receiverset) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
            ++freq;
        }
        if (includejammed) {
            for (BlockCoord node : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.keySet()) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public void updateReceivingDevices(int freq, boolean on) {
        Iterator iterator = this.receivingdevices.iterator();
        while (iterator.hasNext()) {
            ((WirelessReceivingDevice)iterator.next()).updateDevice(freq, on);
        }
    }

    public List getTransmittingDevicesOnFreq(int freq) {
        return Collections.unmodifiableList(this.freqarray[freq].getTransmittingDevices());
    }

    public void addTransmittingDevice(WirelessTransmittingDevice device) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)device.getDimension()))).transmittingdevices.add(device);
        this.freqarray[device.getFreq()].addTransmittingDevice(device);
    }

    public void removeTransmittingDevice(WirelessTransmittingDevice device) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)device.getDimension()))).transmittingdevices.remove(device);
        this.freqarray[device.getFreq()].removeTransmittingDevice(device);
    }

    public void addReceivingDevice(WirelessReceivingDevice device) {
        this.receivingdevices.add(device);
    }

    public void removeReceivingDevice(WirelessReceivingDevice device) {
        this.receivingdevices.remove(device);
    }

    public void setDimensionTransmitterCount(int freq, int dimension, int count) {
        this.freqarray[freq].setActiveTransmittersInDim(dimension, count);
    }

    public void addFreqToSave(RedstoneEtherFrequency freq, int dimension) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave.add(freq);
    }

    public void tick(yc world) {
        this.processEtherAdditions(world);
        this.updateJammedNodes(world);
        this.randomJamTest(world);
        this.updateJammedEntities(world);
        this.entityJamTest(world);
        this.unloadJammedMap();
    }

    private void unloadJammedMap() {
        Iterator iterator = this.playerJammedMap.keySet().iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            if (ServerUtils.getPlayer((String)username) != null) continue;
            this.saveJammedFrequencies(username);
            iterator.remove();
        }
    }

    private void processEtherAdditions(yc world) {
        int dimension;
        this.processingAddittions = dimension = CommonUtils.getDimension((yc)world);
        this.backupmap = new HashMap();
        Iterator iterator = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).wirelessloadlist.keySet().iterator();
        while (iterator.hasNext()) {
            BlockCoord node = (BlockCoord)iterator.next();
            Integer ticksremaining = (Integer)((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).wirelessloadlist.get(node);
            if (ticksremaining == 0) {
                iterator.remove();
                any tileentity = RedstoneEtherServer.getTile(world, node);
                if (!(tileentity instanceof IRedstoneEtherLoad)) continue;
                ((IRedstoneEtherLoad)tileentity).onEtherLoad();
                continue;
            }
            ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).wirelessloadlist.put(node, ticksremaining - 1);
        }
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).wirelessloadlist.putAll(this.backupmap);
        this.processingAddittions = Integer.MAX_VALUE;
    }

    private void updateJammedNodes(yc world) {
        int dimension = CommonUtils.getDimension((yc)world);
        Iterator iterator = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.keySet().iterator();
        while (iterator.hasNext()) {
            BlockCoord node = (BlockCoord)iterator.next();
            int inactivetime = (Integer)((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.get(node);
            if (--inactivetime == 0 || inactivetime < 0 && inactivetime % jammerrandom == 0) {
                ITileJammer jammertile;
                ITileWireless tile = (ITileWireless)RedstoneEtherServer.getTile(world, node);
                if (tile == null) {
                    iterator.remove();
                    continue;
                }
                BlockCoord jammer = this.getClosestJammer(node, dimension);
                ITileJammer iTileJammer = jammertile = jammer == null ? null : (ITileJammer)RedstoneEtherServer.getTile(world, jammer);
                if (jammertile == null) {
                    iterator.remove();
                    tile.unjamTile();
                    continue;
                }
                jammertile.jamTile(tile);
            }
            if (inactivetime == 0) {
                inactivetime = jammertimeout;
            }
            ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.put(node, inactivetime);
        }
    }

    private void randomJamTest(yc world) {
        if (world.G() % 600L != 0L) {
            return;
        }
        for (Map.Entry entry : this.ethers.entrySet()) {
            if (((RedstoneEther.DimensionalEtherHash)entry.getValue()).jammerset == null) continue;
            Iterator iterator = ((RedstoneEther.DimensionalEtherHash)entry.getValue()).jammerset.iterator();
            while (iterator.hasNext()) {
                this.jamNodesInAOEOfJammer(world, (BlockCoord)iterator.next(), (Integer)entry.getKey());
            }
        }
    }

    private void updateJammedEntities(yc world) {
        int dimension = CommonUtils.getDimension((yc)world);
        Iterator iterator = this.jammedentities.keySet().iterator();
        while (iterator.hasNext()) {
            md entity = (md)iterator.next();
            int inactivetime = (Integer)this.jammedentities.get(entity);
            --inactivetime;
            if (entity.L || entity == null) {
                iterator.remove();
                continue;
            }
            if (inactivetime == 0 || inactivetime < 0 && inactivetime % jammerentitywait == 0 || inactivetime > 0 && inactivetime % jammerentityretry == 0) {
                ITileJammer jammertile;
                BlockCoord jammer = this.getClosestJammer(Vector3.fromEntity((lq)entity), dimension);
                ITileJammer iTileJammer = jammertile = jammer == null ? null : (ITileJammer)RedstoneEtherServer.getTile(world, jammer);
                if (jammertile == null) {
                    if (inactivetime <= 0) {
                        iterator.remove();
                        this.jamEntity(entity, false);
                        continue;
                    }
                } else {
                    jammertile.jamEntity((lq)entity);
                }
            }
            if (inactivetime == 0) {
                inactivetime = jammertimeout;
            }
            this.jammedentities.put(entity, inactivetime);
        }
    }

    private void entityJamTest(yc world) {
        if (world.G() % 10L != 0L) {
            return;
        }
        int dimension = CommonUtils.getDimension((yc)world);
        for (BlockCoord jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            List entitiesinrange = world.b(null, aoe.a((double)((double)jammer.x - 9.5), (double)((double)jammer.y - 9.5), (double)((double)jammer.z - 9.5), (double)((double)jammer.x + 10.5), (double)((double)jammer.y + 10.5), (double)((double)jammer.z + 10.5)));
            for (lq entity : entitiesinrange) {
                if (!(entity instanceof md) || entity instanceof qx && this.isPlayerJammed((qx)entity)) continue;
                this.jamEntitySometime((md)entity);
            }
        }
    }

    public void unload() {
        SaveManager.unloadAll();
    }
}

