/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.CommonUtils;
import codechicken.core.config.ConfigFile;
import codechicken.core.config.SimpleProperties;
import codechicken.core.vec.BlockCoord;
import codechicken.wirelessredstone.core.RedstoneEther;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SaveManager {
    private RandomAccessFile freqMapFile;
    private RandomAccessFile smallSectorFile;
    private RandomAccessFile largeSectorFile;
    private RandomAccessFile rwfile;
    protected static SimpleProperties freqProp;
    protected static SimpleProperties generalProp;
    private static ConfigFile globalconfig;
    private static File activeMapFile;
    private ArrayList usedSmallSectors;
    private ArrayList usedLargeSectors;
    private int[] freqMapOffsets;
    private long lastcleanuptime;
    private int dimension;
    private static ArrayList[] freqDimensionHashes;
    private static boolean hashChanged;
    private static boolean loadinginfo;
    private static HashMap managers;
    private final int largesectorsize = 256;
    private final int largesectornodes = 21;
    private final int smallsectorsize = 64;
    private final int smallsectornodes = 5;
    private final int largesectoroffset = Short.MAX_VALUE;
    private final int maxsmallnodes = 5;
    private final int cleanuptimeneeded = 300000;

    static {
        freqDimensionHashes = new ArrayList[5001];
        hashChanged = false;
        managers = new HashMap();
        globalconfig = new ConfigFile(new File(CommonUtils.getMinecraftDir() + "/config", "WirelessRedstone.cfg")).setComment("Wireless Redstone Chicken Bones Edition Configuration File:Deleting any element will restore it to it's default value:Block ID's will be automatically generated the first time it's run");
    }

    public static SaveManager getInstance(int dimension) {
        return (SaveManager)managers.get(dimension);
    }

    public static void reloadSave(yc world, int dimension) {
        managers.put(dimension, new SaveManager(world, dimension));
    }

    public static void unloadSave(int dimension) {
        SaveManager m = (SaveManager)managers.remove(dimension);
        if (m != null) {
            m.unload();
        }
    }

    public static void resetWorld(yc world) {
        try {
            if (managers.size() == 0) {
                File etherdir = SaveManager.getEtherDir(world, 0);
                File file = new File(etherdir, "fprop.dat");
                if (!file.exists()) {
                    file.createNewFile();
                }
                freqProp = new SimpleProperties(file, true);
                file = new File(etherdir, "gprop.dat");
                if (!file.exists()) {
                    file.createNewFile();
                }
                generalProp = new SimpleProperties(file, true);
                generalProp.load();
                file = new File(etherdir, "dimMap.dat");
                if (!file.exists()) {
                    file.createNewFile();
                }
                activeMapFile = file;
            }
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    private SaveManager(yc world, int dimension) {
        try {
            this.dimension = dimension;
            File etherdir = SaveManager.getEtherDir(world, dimension);
            File file = new File(etherdir, "fmap.dat");
            boolean newlycreated = false;
            if (!file.exists()) {
                file.createNewFile();
                newlycreated = true;
            }
            this.freqMapFile = new RandomAccessFile(file, "rw");
            if (newlycreated) {
                int i = 0;
                while (i < 5000) {
                    this.freqMapFile.writeShort(-1);
                    ++i;
                }
            }
            if (!(file = new File(etherdir, "node1.dat")).exists()) {
                file.createNewFile();
            }
            this.smallSectorFile = new RandomAccessFile(file, "rw");
            file = new File(etherdir, "node2.dat");
            if (!file.exists()) {
                file.createNewFile();
            }
            this.largeSectorFile = new RandomAccessFile(file, "rw");
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    private static File getEtherDir(yc world, int dimension) {
        File dir = new File(CommonUtils.getWorldSaveLocation((yc)world, (int)dimension), "RedstoneEther");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private void setFreqSector(int freq, int sector) {
        try {
            this.freqMapOffsets[freq - 1] = sector;
            this.freqMapFile.seek((freq - 1) * 2);
            this.freqMapFile.writeShort(sector);
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    private void seekSector(int sector) {
        try {
            if (sector >= Short.MAX_VALUE) {
                this.rwfile = this.largeSectorFile;
                this.rwfile.seek((sector -= Short.MAX_VALUE) * 256);
            } else {
                this.rwfile = this.smallSectorFile;
                this.rwfile.seek(sector * 64);
            }
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    private void setSectorUsed(int sector, boolean used) {
        ArrayList usedsectors;
        ArrayList arrayList = usedsectors = sector >= Short.MAX_VALUE ? this.usedLargeSectors : this.usedSmallSectors;
        if (sector >= Short.MAX_VALUE) {
            sector -= Short.MAX_VALUE;
        }
        usedsectors.set(sector, used);
    }

    private int getNewSector(boolean large) {
        try {
            if (large) {
                RandomAccessFile file = this.largeSectorFile;
                long prevpos = file.getFilePointer();
                file.seek(file.length());
                file.writeShort(-1);
                file.write(new byte[254]);
                file.seek(prevpos);
                this.usedLargeSectors.add(false);
                return (int)file.length() / 256 - 1 + Short.MAX_VALUE;
            }
            RandomAccessFile file = this.smallSectorFile;
            long prevpos = file.getFilePointer();
            file.seek(file.length());
            file.writeShort(-1);
            file.write(new byte[62]);
            file.seek(prevpos);
            this.usedSmallSectors.add(false);
            return (int)file.length() / 64 - 1;
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
            return -1;
        }
    }

    private int getUnusedSector(int numnodes) {
        boolean largesector = numnodes > 5;
        ArrayList usedsectors = largesector ? this.usedLargeSectors : this.usedSmallSectors;
        int i = 0;
        while (i < usedsectors.size()) {
            if (!((Boolean)usedsectors.get(i)).booleanValue()) {
                return i + (largesector ? Short.MAX_VALUE : 0);
            }
            ++i;
        }
        return this.getNewSector(numnodes > 5);
    }

    private void setNextSector(int sector, int nextsector) {
        this.seekSector(sector);
        try {
            this.rwfile.writeShort((short)nextsector);
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    private void setSectorLength(int sector, int numnodes) {
        this.seekSector(sector);
        try {
            this.rwfile.skipBytes(2);
            this.rwfile.writeShort((short)numnodes);
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    private int getNextSector(int sector) {
        this.seekSector(sector);
        try {
            int nextsector = this.rwfile.readShort() & 0xFFFF;
            if (nextsector == 65535) {
                nextsector = -1;
            }
            return nextsector;
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
            return -1;
        }
    }

    private int getSectorLength(int sector) {
        this.seekSector(sector);
        try {
            this.rwfile.skipBytes(2);
            return this.rwfile.readShort() & 0xFFFF;
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
            return -1;
        }
    }

    private void markSectorStackUnused(int firstsector) {
        int nextsector = firstsector;
        while (nextsector != -1) {
            int sector = nextsector;
            this.setSectorUsed(sector, false);
            this.setNextSector(sector, -1);
            nextsector = this.getNextSector(nextsector);
        }
    }

    private void writeNodes(int freq, int numnodes, ArrayList nodes) {
        try {
            int nextsector = this.freqMapOffsets[freq - 1];
            if (nextsector == -1) {
                nextsector = this.getUnusedSector(numnodes);
                this.setSectorUsed(nextsector, true);
                this.setFreqSector(freq, nextsector);
            } else {
                this.markSectorStackUnused(nextsector);
                this.setSectorUsed(nextsector, true);
            }
            while (true) {
                this.seekSector(nextsector);
                this.rwfile.skipBytes(4);
                int thissector = nextsector;
                int writtennodes = 0;
                boolean largesector = nextsector >= Short.MAX_VALUE;
                int nodespersector = largesector ? 21 : 5;
                while (writtennodes != nodespersector && numnodes > 0) {
                    BlockCoord node = (BlockCoord)nodes.get(nodes.size() - numnodes);
                    this.rwfile.writeInt(node.x);
                    this.rwfile.writeInt(node.y);
                    this.rwfile.writeInt(node.z);
                    --numnodes;
                    ++writtennodes;
                }
                this.setSectorLength(thissector, writtennodes);
                if (numnodes == 0) {
                    this.setNextSector(thissector, -1);
                    break;
                }
                nextsector = this.getUnusedSector(numnodes);
                this.setSectorUsed(nextsector, true);
                this.setNextSector(thissector, nextsector);
            }
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    public void saveFreq(int freq, int activetransmitters, TreeMap transmittermap, Map dimensionHash) {
        try {
            SaveManager.freqDimensionHashes[freq] = new ArrayList(dimensionHash.entrySet());
            hashChanged = true;
            int numnodes = 0;
            ArrayList<BlockCoord> nodes = new ArrayList<BlockCoord>(activetransmitters);
            Iterator iterator = transmittermap.keySet().iterator();
            while (iterator.hasNext() && numnodes < activetransmitters) {
                BlockCoord node = (BlockCoord)iterator.next();
                if (!((Boolean)transmittermap.get(node)).booleanValue()) continue;
                nodes.add(node);
                ++numnodes;
            }
            if (numnodes == 0) {
                this.setFreqSector(freq, -1);
                return;
            }
            this.writeNodes(freq, numnodes, nodes);
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    private void loadFreqMap() {
        try {
            this.freqMapOffsets = new int[5000];
            this.freqMapFile.seek(0L);
            int freq = 1;
            while (freq <= 5000) {
                this.freqMapOffsets[freq - 1] = this.freqMapFile.readShort() & 0xFFFF;
                if (this.freqMapOffsets[freq - 1] == 65535) {
                    this.freqMapOffsets[freq - 1] = -1;
                }
                ++freq;
            }
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    private void initSectors() {
        int numlargesectors;
        int numsmallsectors;
        try {
            numsmallsectors = (int)(this.smallSectorFile.length() / 64L);
            numlargesectors = (int)(this.largeSectorFile.length() / 256L);
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
            return;
        }
        this.usedSmallSectors = new ArrayList(numsmallsectors);
        int i = 0;
        while (i < numsmallsectors) {
            this.usedSmallSectors.add(false);
            ++i;
        }
        this.usedLargeSectors = new ArrayList(numlargesectors);
        i = 0;
        while (i < numlargesectors) {
            this.usedLargeSectors.add(false);
            ++i;
        }
    }

    private void loadNodes() {
        int freq = 1;
        while (freq <= 5000) {
            RedstoneEther.server().setDimensionTransmitterCount(freq, this.dimension, 0);
            int nextsector = this.freqMapOffsets[freq - 1];
            if (nextsector != -1) {
                do {
                    this.seekSector(nextsector);
                    this.setSectorUsed(nextsector, true);
                    int numnodes = this.getSectorLength(nextsector);
                    int j = 0;
                    while (j < numnodes) {
                        try {
                            RedstoneEther.server().loadTransmitter(this.dimension, this.rwfile.readInt(), this.rwfile.readInt(), this.rwfile.readInt(), freq);
                        }
                        catch (Exception e) {
                            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
                        }
                        ++j;
                    }
                } while ((nextsector = this.getNextSector(nextsector)) != -1);
                RedstoneEther.server().setFreqClean(freq, this.dimension);
            }
            ++freq;
        }
    }

    public void removeTrailingSectors() {
        try {
            if (this.lastcleanuptime != 0L && System.currentTimeMillis() - this.lastcleanuptime < 300000L) {
                return;
            }
            int lastusedsector = -1;
            int i = 0;
            while (i < this.usedLargeSectors.size()) {
                if (((Boolean)this.usedLargeSectors.get(i)).booleanValue()) {
                    lastusedsector = i;
                }
                ++i;
            }
            i = this.usedLargeSectors.size() - 1;
            while (i > lastusedsector) {
                this.usedLargeSectors.remove(i);
                --i;
            }
            this.largeSectorFile.setLength((lastusedsector + 1) * 256);
            i = 0;
            while (i < this.usedSmallSectors.size()) {
                if (((Boolean)this.usedSmallSectors.get(i)).booleanValue()) {
                    lastusedsector = i;
                }
                ++i;
            }
            i = this.usedSmallSectors.size() - 1;
            while (i > lastusedsector) {
                this.usedSmallSectors.remove(i);
                --i;
            }
            this.smallSectorFile.setLength((lastusedsector + 1) * 64);
            this.lastcleanuptime = System.currentTimeMillis();
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    public void loadEther() {
        this.loadFreqMap();
        this.initSectors();
        this.loadNodes();
        this.lastcleanuptime = 0L;
        this.removeTrailingSectors();
    }

    /*
     * Unable to fully structure code
     */
    public static void loadFreqInfo() {
        SaveManager.freqProp.load();
        SaveManager.loadinginfo = true;
        iterator = SaveManager.freqProp.propertyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            block13: {
                block12: {
                    block11: {
                        entry = iterator.next();
                        success = false;
                        val = Integer.parseInt(((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(46)));
                        if (val != null) break block11;
                        if (success) continue;
                        iterator.remove();
                        continue;
                    }
                    freq = val;
                    if (!((String)entry.getKey()).endsWith(".colour") && !((String)entry.getKey()).endsWith(".c")) ** GOTO lbl29
                    val = Integer.parseInt((String)entry.getValue());
                    if (val != null) break block12;
                    if (success) continue;
                    iterator.remove();
                    continue;
                }
                try {
                    try {
                        colourindex = val;
                        RedstoneEther.server().setFreqColour(freq, colourindex);
                        success = true;
                        break block13;
lbl29:
                        // 1 sources

                        if (((String)entry.getKey()).endsWith(".name") || ((String)entry.getKey()).endsWith(".n")) {
                            RedstoneEther.server().setFreqName(freq, (String)entry.getValue());
                            success = true;
                        } else if (((String)entry.getKey()).endsWith(".owner")) {
                            RedstoneEther.server().setFreqOwner(freq, (String)entry.getValue());
                            success = true;
                        }
                    }
                    catch (Exception var3_4) {
                        if (success) continue;
                        iterator.remove();
                        continue;
                    }
                }
                catch (Throwable var6_8) {
                    if (!success) {
                        iterator.remove();
                    }
                    throw var6_8;
                }
            }
            if (success) continue;
            iterator.remove();
        }
        SaveManager.loadinginfo = false;
        SaveManager.freqProp.save();
    }

    public static void loadDimensionHash() {
        if (activeMapFile.length() == 0L) {
            return;
        }
        try {
            DataInputStream din = new DataInputStream(new FileInputStream(activeMapFile));
            try {
                try {
                    while (true) {
                        RedstoneEther.server().setDimensionTransmitterCount(din.readShort(), din.readInt(), din.readInt());
                    }
                }
                catch (EOFException eOFException) {
                    din.close();
                }
            }
            catch (Throwable throwable) {
                din.close();
                throw throwable;
            }
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    public static void saveDimensionHash() {
        if (!hashChanged) {
            return;
        }
        try {
            DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(activeMapFile)));
            int freq = 1;
            while (freq <= 5000) {
                ArrayList map = freqDimensionHashes[freq];
                if (map != null) {
                    for (Map.Entry entry : map) {
                        if ((Integer)entry.getValue() <= 0) continue;
                        dout.writeShort(freq);
                        dout.writeInt((Integer)entry.getKey());
                        dout.writeInt((Integer)entry.getValue());
                    }
                }
                ++freq;
            }
            dout.close();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }

    public static ConfigFile config() {
        return globalconfig;
    }

    public static boolean isLoading() {
        return loadinginfo;
    }

    public static void unloadAll() {
        for (SaveManager manager : managers.values()) {
            manager.unload();
        }
        managers.clear();
    }

    private void unload() {
        try {
            this.freqMapFile.close();
            this.smallSectorFile.close();
            this.largeSectorFile.close();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone Save Manager", true);
        }
    }
}

