/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.denLib.Config;

import denoflionsx.denLib.Config.ForgeConfigExtended;
import denoflionsx.denLib.denLib;
import java.io.File;
import java.util.ArrayList;

public class Config {
    public static String ConfigDir;
    protected String ConfigFile = "";
    public static boolean verbose;
    public static final boolean debug = false;
    public ForgeConfigExtended Options;
    public ForgeConfigExtended Defaults;

    public Config(String c) {
        this.ConfigFile = ConfigDir + c;
        this.Options = new ForgeConfigExtended(new File(this.ConfigFile));
        this.Defaults = new ForgeConfigExtended(new File(this.ConfigFile));
    }

    public String getConfigFile() {
        return this.ConfigFile;
    }

    public void setConfigDir(String dir) {
        ConfigDir = dir;
    }

    public void readFile() {
        try {
            this.Options.load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getOptionInt(String key) {
        String op = this.getOption(key);
        if (op.equals("")) {
            op = "0";
        }
        return Integer.valueOf(op);
    }

    public float getOptionFloat(String key) {
        String op = this.getOption(key);
        if (op.equals("")) {
            op = "0";
        }
        return Float.valueOf(op).floatValue();
    }

    public boolean getOptionBool(String key) {
        String value = this.getOption(key);
        return denLib.toLowerCaseNoSpaces(value).equals("true");
    }

    public void setOption(String key, String param) {
    }

    public String getOption(String key) {
        String op = "";
        if (this.Options.getOption(key) == null) {
            for (String s : this.Defaults.dumpAllKeys()) {
                if (!s.equals(key)) continue;
                this.Options.addDefault(key + "=" + this.Defaults.getOption(key));
            }
        }
        if (this.Options.getOption(key) != null) {
            op = this.Options.getOption(key).toString();
        }
        return op;
    }

    public String getOptionNoUpdate(String key) {
        if (this.Options.getOption(key) == null) {
            return null;
        }
        return this.Options.getOption(key).toString();
    }

    public void addDefault(String d) {
        this.Defaults.addDefault(d);
    }

    public boolean doesConfigExist() {
        return new File(this.ConfigFile).exists();
    }

    public void writeConfig() {
        try {
            if (!this.doesConfigExist()) {
                this.Defaults.save();
            } else {
                this.deleteConfig();
                this.Options.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteConfig() {
        if (new File(this.ConfigFile).exists()) {
            new File(this.ConfigFile).delete();
        }
    }

    public ArrayList dumpValues() {
        return this.Options.dumpAllValues();
    }

    public ArrayList dumpKeys() {
        return this.Options.dumpAllKeys();
    }

    static {
        verbose = false;
    }
}

