/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.denLib.Config;

import denoflionsx.denLib.Config.FileRead;
import denoflionsx.denLib.Config.FileWrite;
import denoflionsx.denLib.denLib;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class Config_OLD {
    public HashMap Options = new HashMap();
    protected ArrayList defaults = new ArrayList();
    protected ArrayList rawFile = new ArrayList();
    public static String ConfigDir;
    protected String ConfigFile = "";
    protected boolean isStream = false;
    protected InputStream is = null;
    public static boolean verbose;
    public static final boolean debug = false;

    public Config_OLD(String c) {
        this.ConfigFile = ConfigDir + c;
    }

    public Config_OLD(InputStream is) {
        this.is = is;
        this.isStream = true;
        this.readFile();
    }

    public String getConfigFile() {
        return this.ConfigFile;
    }

    public void setConfigDir(String dir) {
        ConfigDir = dir;
    }

    public void readFile() {
        if (!this.isStream) {
            ArrayList read = FileRead.Read(new String[]{this.ConfigFile});
            for (String next : read) {
                this.parseLine(next);
            }
        } else {
            String[] b;
            String str = Config_OLD.convertStreamToString(this.is);
            str = str.replace("\n", "").replace("\r", "");
            for (String line : b = str.split(";")) {
                this.parseLine(line);
            }
        }
    }

    public int getOptionInt(String key) {
        String op = this.getOption(key);
        if (op.equals("")) {
            op = "0";
        }
        return Integer.valueOf(op);
    }

    public float getOptionFloat(String key) {
        String op = this.getOption(key);
        if (op.equals("")) {
            op = "0";
        }
        return Float.valueOf(op).floatValue();
    }

    public boolean getOptionBool(String key) {
        String value = this.getOption(key);
        return denLib.toLowerCaseNoSpaces(value).equals("true");
    }

    public void setOption(String key, String param) {
        this.Options.put(key, param);
    }

    public String getOption(String key) {
        String op = (String)this.Options.get(key);
        if (op != null) {
            return op;
        }
        if (!this.isStream) {
            denLib.print("Attempting to update config file with " + key + "...");
            for (String s : this.defaults) {
                if (!s.contains(key)) continue;
                this.parseLine(s);
                op = (String)this.Options.get(key);
                new File(this.ConfigFile).delete();
                FileWrite.write(this.ConfigFile, this.rawFile);
                return op;
            }
        }
        return "";
    }

    public String getOptionNoUpdate(String key) {
        return (String)this.Options.get(key);
    }

    public void parseLine(String line) {
        String[] read;
        char s = "=".charAt(0);
        this.rawFile.add(line);
        if (!line.substring(0, 1).equals("#") && !line.substring(0, 1).equals("[") && (read = line.split("=")).length == 2) {
            this.setOption(read[0], read[1]);
        }
    }

    public void addDefault(String d) {
        if (this.isStream) {
            return;
        }
        this.defaults.add(d);
    }

    public void writeConfig() {
        if (this.isStream) {
            return;
        }
        if (!new File(this.ConfigFile).exists()) {
            new File(ConfigDir).mkdirs();
            FileWrite.write(this.ConfigFile, this.defaults);
            denLib.print("Wrote config file: " + this.ConfigFile);
        }
    }

    public void deleteConfig() {
        if (this.isStream) {
            return;
        }
        if (new File(this.ConfigFile).exists()) {
            new File(this.ConfigFile).delete();
        }
    }

    public ArrayList dumpValues() {
        Iterator i = this.Options.entrySet().iterator();
        ArrayList<String> values = new ArrayList<String>();
        while (i.hasNext()) {
            Map.Entry pairs = i.next();
            values.add(pairs.getValue().toString());
        }
        return values;
    }

    public ArrayList dumpKeys() {
        Iterator i = this.Options.entrySet().iterator();
        ArrayList<String> values = new ArrayList<String>();
        while (i.hasNext()) {
            Map.Entry pairs = i.next();
            values.add(pairs.getKey().toString());
        }
        return values;
    }

    public static String convertStreamToString(InputStream is) {
        try {
            return new Scanner(is).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    static {
        verbose = false;
    }
}

