/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.neifix;

import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Path;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class NEITransformer
implements IClassTransformer {
    public static String mcJarFile = null;

    public NEITransformer() {
        try {
            URL mcClass = this.getClass().getResource("/net/minecraft/client/Minecraft.class");
            if (mcClass == null) {
                return;
            }
            JarURLConnection jarConnection = (JarURLConnection)mcClass.openConnection();
            String filename = jarConnection.getJarFile().getName();
            File f = new File(filename);
            Path p = f.toPath();
            mcJarFile = p.getFileName().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] transform(String name, byte[] bytes) {
        if (name.equals("codechicken.nei.TMIUninstaller")) {
            System.out.println("Found codechicken.nei.TMIUninstaller");
            if (mcJarFile == null || mcJarFile.length() < 1) {
                System.out.println("  Error: Couldn't locate Minecraft jar filename!  Aborting NEI patch.");
                return bytes;
            }
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            MethodNode getJarFileMethod = null;
            for (MethodNode mn : cn.methods) {
                if (!mn.name.equals("getJarFile")) continue;
                getJarFileMethod = mn;
                System.out.println("  - Found getJarFile");
                break;
            }
            if (getJarFileMethod != null) {
                for (AbstractInsnNode node : getJarFileMethod.instructions) {
                    if (!(node instanceof LdcInsnNode)) continue;
                    LdcInsnNode ldc = (LdcInsnNode)node;
                    if (!(ldc.cst instanceof String) || !ldc.cst.equals("minecraft.jar")) continue;
                    System.out.println("  - Found Minecraft jar filename, patching with \"" + mcJarFile + "\"");
                    ldc.cst = mcJarFile;
                }
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return bytes;
    }
}

