/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateManager;
import powercrystals.powerconverters.common.BlockPowerConverterCommon;
import powercrystals.powerconverters.common.ItemBlockPowerConverterCommon;
import powercrystals.powerconverters.common.TileEntityCharger;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.gui.PCGUIHandler;
import powercrystals.powerconverters.net.ClientPacketHandler;
import powercrystals.powerconverters.net.ConnectionHandler;
import powercrystals.powerconverters.net.IPCProxy;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.buildcraft.BlockPowerConverterBuildCraft;
import powercrystals.powerconverters.power.buildcraft.ItemBlockPowerConverterBuildCraft;
import powercrystals.powerconverters.power.buildcraft.TileEntityBuildCraftConsumer;
import powercrystals.powerconverters.power.buildcraft.TileEntityBuildCraftProducer;
import powercrystals.powerconverters.power.factorization.BlockPowerConverterFactorization;
import powercrystals.powerconverters.power.factorization.ItemBlockPowerConverterFactorization;
import powercrystals.powerconverters.power.factorization.TileEntityPowerConverterFactorizationConsumer;
import powercrystals.powerconverters.power.factorization.TileEntityPowerConverterFactorizationProducer;
import powercrystals.powerconverters.power.ic2.BlockPowerConverterIndustrialCraft;
import powercrystals.powerconverters.power.ic2.ChargeHandlerIndustrialCraft;
import powercrystals.powerconverters.power.ic2.ItemBlockPowerConverterIndustrialCraft;
import powercrystals.powerconverters.power.ic2.TileEntityIndustrialCraftConsumer;
import powercrystals.powerconverters.power.ic2.TileEntityIndustrialCraftProducer;
import powercrystals.powerconverters.power.railcraft.BlockPowerConverterRailCraft;
import powercrystals.powerconverters.power.railcraft.ItemBlockPowerConverterRailCraft;
import powercrystals.powerconverters.power.railcraft.TileEntityRailCraftConsumer;
import powercrystals.powerconverters.power.railcraft.TileEntityRailCraftProducer;
import powercrystals.powerconverters.power.ue.BlockPowerConverterUniversalElectricity;
import powercrystals.powerconverters.power.ue.ChargeHandlerUniversalElectricity;
import powercrystals.powerconverters.power.ue.ItemBlockPowerConverterUniversalElectricty;
import powercrystals.powerconverters.power.ue.TileEntityUniversalElectricityConsumer;
import powercrystals.powerconverters.power.ue.TileEntityUniversalElectricityProducer;

@Mod(modid="PowerConverters", name="Power Converters", version="1.4.6R2.2.2", dependencies="required-after:PowerCrystalsCore;after:BasicComponents;after:BuildCraft|Energy;after:factorization;after:IC2;after:Railcraft;after:ThermalExpansion|Energy")
@NetworkMod(clientSideRequired=false, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"PowerConverters"}, packetHandler=ClientPacketHandler.class), connectionHandler=ConnectionHandler.class)
public class PowerConverterCore
implements IUpdateableMod {
    public static final String modId = "PowerConverters";
    public static final String modName = "Power Converters";
    public static final String version = "1.4.6R2.2.2";
    @SidedProxy(clientSide="powercrystals.powerconverters.net.ProxyClient", serverSide="powercrystals.powerconverters.net.ProxyServer")
    public static IPCProxy proxy;
    private static final String _texureFolder = "/powercrystals/powerconverters/textures/";
    public static final String terrainTexture = "/powercrystals/powerconverters/textures/terrain_0.png";
    public static final String itemTexture = "/powercrystals/powerconverters/textures/items_0.png";
    public static final String guiFolder = "/powercrystals/powerconverters/textures/gui/";
    public static amq converterBlockCommon;
    public static amq converterBlockBuildCraft;
    public static amq converterBlockIndustrialCraft;
    public static amq converterBlockSteam;
    public static amq converterBlockUniversalElectricity;
    public static amq converterBlockFactorization;
    public static PowerConverterCore instance;
    private static Property blockIdCommon;
    private static Property blockIdBuildCraft;
    private static Property blockIdIndustrialCraft;
    private static Property blockIdSteam;
    private static Property blockIdUniversalElectricty;
    private static Property blockIdFactorization;
    public static PowerSystem powerSystemBuildCraft;
    public static PowerSystem powerSystemIndustrialCraft;
    public static PowerSystem powerSystemSteam;
    public static PowerSystem powerSystemUniversalElectricity;
    public static PowerSystem powerSystemFactorization;
    public static int steamId;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        powerSystemBuildCraft = new PowerSystem("BuildCraft", "BC", 4375, 4375, null, null, "MJ/t");
        powerSystemIndustrialCraft = new PowerSystem("IndustrialCraft", "IC2", 1800, 1800, new String[]{"LV", "MV", "HV", "EV"}, new int[]{32, 128, 512, 2048}, "EU/t");
        powerSystemSteam = new PowerSystem("Steam", "STEAM", 875, 875, null, null, "mB/t");
        powerSystemUniversalElectricity = new PowerSystem("UniversalElectricity", "UE", 10, 10, new String[]{"LV", "MV", "HV", "EV"}, new int[]{60, 120, 240, 480}, "W");
        powerSystemFactorization = new PowerSystem("Factorization", "FZ", 1458, 1458, null, null, "CG/t");
        PowerSystem.registerPowerSystem(powerSystemBuildCraft);
        PowerSystem.registerPowerSystem(powerSystemIndustrialCraft);
        PowerSystem.registerPowerSystem(powerSystemSteam);
        PowerSystem.registerPowerSystem(powerSystemUniversalElectricity);
        PowerSystem.registerPowerSystem(powerSystemFactorization);
        Configuration c = new Configuration(evt.getSuggestedConfigurationFile());
        PowerConverterCore.loadConfig(c);
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) throws Exception {
        instance = this;
        converterBlockCommon = new BlockPowerConverterCommon(blockIdCommon.getInt());
        GameRegistry.registerBlock((amq)converterBlockCommon, ItemBlockPowerConverterCommon.class, (String)"blockPowerConverterCommon");
        GameRegistry.registerTileEntity(TileEntityEnergyBridge.class, (String)"powerConverterEnergyBridge");
        GameRegistry.registerTileEntity(TileEntityCharger.class, (String)"powerConverterUniversalCharger");
        LanguageRegistry.addName((Object)new ur(converterBlockCommon, 1, 0), (String)"Energy Bridge");
        LanguageRegistry.addName((Object)new ur(converterBlockCommon, 1, 2), (String)"Universal Charger");
        GameRegistry.addRecipe((ur)new ur(converterBlockCommon, 1, 0), (Object[])new Object[]{"GRG", "LDL", "GRG", Character.valueOf('G'), up.p, Character.valueOf('R'), up.aC, Character.valueOf('L'), amq.P, Character.valueOf('D'), up.n});
        GameRegistry.addRecipe((ur)new ur(converterBlockCommon, 1, 2), (Object[])new Object[]{"GRG", "ICI", "GRG", Character.valueOf('G'), up.p, Character.valueOf('R'), up.aC, Character.valueOf('I'), up.o, Character.valueOf('C'), amq.ax});
        if (Loader.isModLoaded((String)"BuildCraft|Energy") || Loader.isModLoaded((String)"ThermalExpansion|Energy")) {
            converterBlockBuildCraft = new BlockPowerConverterBuildCraft(blockIdBuildCraft.getInt());
            GameRegistry.registerBlock((amq)converterBlockBuildCraft, ItemBlockPowerConverterBuildCraft.class, (String)"blockPowerConverterBuildCraft");
            GameRegistry.registerTileEntity(TileEntityBuildCraftConsumer.class, (String)"powerConverterBCConsumer");
            GameRegistry.registerTileEntity(TileEntityBuildCraftProducer.class, (String)"powerConverterBCProducer");
            LanguageRegistry.addName((Object)new ur(converterBlockBuildCraft, 1, 0), (String)"BC Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockBuildCraft, 1, 1), (String)"BC Producer");
            if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
                GameRegistry.addRecipe((ur)new ur(converterBlockBuildCraft, 1, 0), (Object[])new Object[]{"G G", " E ", "G G", Character.valueOf('G'), up.p, Character.valueOf('E'), new ur((amq)Class.forName("buildcraft.BuildCraftEnergy").getField("engineBlock").get(null), 1, 1)});
            }
            if (Loader.isModLoaded((String)"ThermalExpansion|Energy")) {
                GameRegistry.addRecipe((ur)new ur(converterBlockBuildCraft, 1, 0), (Object[])new Object[]{"G G", " E ", "G G", Character.valueOf('G'), up.p, Character.valueOf('E'), (ur)Class.forName("thermalexpansion.ThermalExpansionEnergy").getField("engineSteam").get(null)});
            }
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockBuildCraft, 1, 1), (Object[])new Object[]{new ur(converterBlockBuildCraft, 1, 0)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockBuildCraft, 1, 0), (Object[])new Object[]{new ur(converterBlockBuildCraft, 1, 1)});
        }
        if (Loader.isModLoaded((String)"IC2")) {
            converterBlockIndustrialCraft = new BlockPowerConverterIndustrialCraft(blockIdIndustrialCraft.getInt());
            GameRegistry.registerBlock((amq)converterBlockIndustrialCraft, ItemBlockPowerConverterIndustrialCraft.class, (String)"blockPowerConverterIndustrialCraft");
            GameRegistry.registerTileEntity(TileEntityIndustrialCraftConsumer.class, (String)"powerConverterIC2Consumer");
            GameRegistry.registerTileEntity(TileEntityIndustrialCraftProducer.class, (String)"powerConverterIC2Producer");
            LanguageRegistry.addName((Object)new ur(converterBlockIndustrialCraft, 1, 0), (String)"IC2 LV Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockIndustrialCraft, 1, 1), (String)"IC2 LV Producer");
            LanguageRegistry.addName((Object)new ur(converterBlockIndustrialCraft, 1, 2), (String)"IC2 MV Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockIndustrialCraft, 1, 3), (String)"IC2 MV Producer");
            LanguageRegistry.addName((Object)new ur(converterBlockIndustrialCraft, 1, 4), (String)"IC2 HV Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockIndustrialCraft, 1, 5), (String)"IC2 HV Producer");
            LanguageRegistry.addName((Object)new ur(converterBlockIndustrialCraft, 1, 6), (String)"IC2 EV Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockIndustrialCraft, 1, 7), (String)"IC2 EV Producer");
            GameRegistry.addRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 0), (Object[])new Object[]{"G G", " T ", "G G", Character.valueOf('G'), up.p, Character.valueOf('T'), (ur)Class.forName("ic2.core.Ic2Items").getField("lvTransformer").get(null)});
            GameRegistry.addRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 2), (Object[])new Object[]{"G G", " T ", "G G", Character.valueOf('G'), up.p, Character.valueOf('T'), (ur)Class.forName("ic2.core.Ic2Items").getField("mvTransformer").get(null)});
            GameRegistry.addRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 4), (Object[])new Object[]{"G G", " T ", "G G", Character.valueOf('G'), up.p, Character.valueOf('T'), (ur)Class.forName("ic2.core.Ic2Items").getField("hvTransformer").get(null)});
            GameRegistry.addRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 6), (Object[])new Object[]{"G G", " T ", "G G", Character.valueOf('G'), up.p, Character.valueOf('T'), (ur)Class.forName("ic2.core.Ic2Items").getField("mfsUnit").get(null)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 1), (Object[])new Object[]{new ur(converterBlockIndustrialCraft, 1, 0)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 0), (Object[])new Object[]{new ur(converterBlockIndustrialCraft, 1, 1)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 3), (Object[])new Object[]{new ur(converterBlockIndustrialCraft, 1, 2)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 2), (Object[])new Object[]{new ur(converterBlockIndustrialCraft, 1, 3)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 5), (Object[])new Object[]{new ur(converterBlockIndustrialCraft, 1, 4)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 4), (Object[])new Object[]{new ur(converterBlockIndustrialCraft, 1, 5)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 7), (Object[])new Object[]{new ur(converterBlockIndustrialCraft, 1, 6)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockIndustrialCraft, 1, 6), (Object[])new Object[]{new ur(converterBlockIndustrialCraft, 1, 7)});
            TileEntityCharger.registerChargeHandler(new ChargeHandlerIndustrialCraft());
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            converterBlockSteam = new BlockPowerConverterRailCraft(blockIdSteam.getInt());
            GameRegistry.registerBlock((amq)converterBlockSteam, ItemBlockPowerConverterRailCraft.class, (String)"blockPowerConverterSteam");
            GameRegistry.registerTileEntity(TileEntityRailCraftConsumer.class, (String)"powerConverterSteamConsumer");
            GameRegistry.registerTileEntity(TileEntityRailCraftProducer.class, (String)"powerConverterSteamProducer");
            LanguageRegistry.addName((Object)new ur(converterBlockSteam, 1, 0), (String)"Steam Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockSteam, 1, 1), (String)"Steam Producer");
            GameRegistry.addRecipe((ur)new ur(converterBlockSteam, 1, 0), (Object[])new Object[]{"G G", " E ", "G G", Character.valueOf('G'), up.p, Character.valueOf('E'), new ur((amq)Class.forName("railcraft.common.blocks.RailcraftBlocks").getMethod("getBlockMachineBeta", new Class[0]).invoke(null, new Object[0]), 1, 8)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockSteam, 1, 1), (Object[])new Object[]{new ur(converterBlockSteam, 1, 0)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockSteam, 1, 0), (Object[])new Object[]{new ur(converterBlockSteam, 1, 1)});
        }
        if (Loader.isModLoaded((String)"BasicComponents") || Loader.isModLoaded((String)"mmmPowerSuits")) {
            TileEntityCharger.registerChargeHandler(new ChargeHandlerUniversalElectricity());
        }
        if (Loader.isModLoaded((String)"BasicComponents")) {
            converterBlockUniversalElectricity = new BlockPowerConverterUniversalElectricity(blockIdUniversalElectricty.getInt());
            GameRegistry.registerBlock((amq)converterBlockUniversalElectricity, ItemBlockPowerConverterUniversalElectricty.class, (String)"blockPowerConverterUniversalElectricity");
            GameRegistry.registerTileEntity(TileEntityUniversalElectricityConsumer.class, (String)"powerConverterUEConsumer");
            GameRegistry.registerTileEntity(TileEntityUniversalElectricityProducer.class, (String)"powerConverterUEProducer");
            LanguageRegistry.addName((Object)new ur(converterBlockUniversalElectricity, 1, 0), (String)"UE 60V Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockUniversalElectricity, 1, 1), (String)"UE 60V Producer");
            LanguageRegistry.addName((Object)new ur(converterBlockUniversalElectricity, 1, 2), (String)"UE 120V Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockUniversalElectricity, 1, 3), (String)"UE 120V Producer");
            LanguageRegistry.addName((Object)new ur(converterBlockUniversalElectricity, 1, 4), (String)"UE 240V Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockUniversalElectricity, 1, 5), (String)"UE 240V Producer");
            LanguageRegistry.addName((Object)new ur(converterBlockUniversalElectricity, 1, 6), (String)"UE 480V Consumer");
            LanguageRegistry.addName((Object)new ur(converterBlockUniversalElectricity, 1, 7), (String)"UE 480V Producer");
            GameRegistry.addRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 0), (Object[])new Object[]{"I I", "   ", "IBI", Character.valueOf('I'), up.p, Character.valueOf('B'), new ur((amq)Class.forName("basiccomponents.common.BasicComponents").getField("blockMachine").get(null), 1, 4)});
            GameRegistry.addRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 2), (Object[])new Object[]{"I I", " B ", "I I", Character.valueOf('I'), up.p, Character.valueOf('B'), new ur((amq)Class.forName("basiccomponents.common.BasicComponents").getField("blockMachine").get(null), 1, 4)});
            GameRegistry.addRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 4), (Object[])new Object[]{"IBI", "   ", "I I", Character.valueOf('I'), up.p, Character.valueOf('B'), new ur((amq)Class.forName("basiccomponents.common.BasicComponents").getField("blockMachine").get(null), 1, 4)});
            GameRegistry.addRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 6), (Object[])new Object[]{"IBI", "I I", "I I", Character.valueOf('I'), up.p, Character.valueOf('B'), new ur((amq)Class.forName("basiccomponents.common.BasicComponents").getField("blockMachine").get(null), 1, 4)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 1), (Object[])new Object[]{new ur(converterBlockUniversalElectricity, 1, 0)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 0), (Object[])new Object[]{new ur(converterBlockUniversalElectricity, 1, 1)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 3), (Object[])new Object[]{new ur(converterBlockUniversalElectricity, 1, 2)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 2), (Object[])new Object[]{new ur(converterBlockUniversalElectricity, 1, 3)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 5), (Object[])new Object[]{new ur(converterBlockUniversalElectricity, 1, 4)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 4), (Object[])new Object[]{new ur(converterBlockUniversalElectricity, 1, 5)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 7), (Object[])new Object[]{new ur(converterBlockUniversalElectricity, 1, 6)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockUniversalElectricity, 1, 6), (Object[])new Object[]{new ur(converterBlockUniversalElectricity, 1, 7)});
        }
        if (Loader.isModLoaded((String)"factorization")) {
            converterBlockFactorization = new BlockPowerConverterFactorization(blockIdFactorization.getInt());
            GameRegistry.registerBlock((amq)converterBlockFactorization, ItemBlockPowerConverterFactorization.class, (String)"blockPowerConverterFZ");
            GameRegistry.registerTileEntity(TileEntityPowerConverterFactorizationConsumer.class, (String)"powerConverterFZConsumer");
            LanguageRegistry.addName((Object)new ur(converterBlockFactorization, 1, 0), (String)"Factorization Consumer");
            GameRegistry.registerTileEntity(TileEntityPowerConverterFactorizationProducer.class, (String)"powerConverterFZProducer");
            LanguageRegistry.addName((Object)new ur(converterBlockFactorization, 1, 1), (String)"Factorization Producer");
            Object fzRegistry = Class.forName("factorization.common.Core").getField("registry").get(null);
            GameRegistry.addRecipe((ur)new ur(converterBlockFactorization, 1, 0), (Object[])new Object[]{"I I", " B ", "I I", Character.valueOf('I'), up.p, Character.valueOf('B'), (ur)Class.forName("factorization.common.Registry").getField("solar_turbine_item").get(fzRegistry)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockFactorization, 1, 1), (Object[])new Object[]{new ur(converterBlockFactorization, 1, 0)});
            GameRegistry.addShapelessRecipe((ur)new ur(converterBlockFactorization, 1, 0), (Object[])new Object[]{new ur(converterBlockFactorization, 1, 1)});
        }
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new PCGUIHandler());
        if (LiquidDictionary.getLiquids().get("Steam") != null) {
            steamId = ((LiquidStack)LiquidDictionary.getLiquids().get((Object)"Steam")).itemID;
        }
        MinecraftForge.EVENT_BUS.register((Object)instance);
        proxy.load();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new UpdateManager((IUpdateableMod)this), (Side)Side.CLIENT);
    }

    @ForgeSubscribe
    public void forgeEvent(LiquidDictionary.LiquidRegisterEvent e) {
        if (e.Name.equals("Steam")) {
            steamId = e.Liquid.itemID;
        }
    }

    private static void loadConfig(Configuration c) {
        blockIdCommon = c.getBlock("ID.BlockCommon", 2850);
        blockIdBuildCraft = c.getBlock("ID.BlockBuildcraft", 2851);
        blockIdIndustrialCraft = c.getBlock("ID.BlockIndustrialCraft", 2852);
        blockIdSteam = c.getBlock("ID.BlockSteam", 2853);
        blockIdUniversalElectricty = c.getBlock("ID.BlockUniversalElectricty", 2854);
        blockIdFactorization = c.getBlock("ID.BlockFactorization", 2855);
        PowerSystem.loadConfig(c);
        c.save();
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModFolder() {
        return modId;
    }

    public String getModVersion() {
        return version;
    }

    static {
        steamId = -1;
    }
}

