/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.common.IChargeHandler;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;

public class TileEntityCharger
extends TileEntityEnergyProducer {
    private static List _chargeHandlers = new ArrayList();
    private qx _player;

    public static void registerChargeHandler(IChargeHandler handler) {
        _chargeHandlers.add(handler);
    }

    public TileEntityCharger() {
        super(PowerConverterCore.powerSystemIndustrialCraft, 0, la.class);
    }

    @Override
    public void g() {
        super.g();
        if (this._player != null && this._player.f((double)this.l, (double)this.m, (double)this.n) > 2.0) {
            this.setPlayer(null);
        }
    }

    @Override
    public int produceEnergy(int energy) {
        if (energy == 0) {
            return 0;
        }
        int energyRemaining = energy;
        if (this._player != null) {
            energyRemaining = this.chargeInventory((la)this._player.bJ, ForgeDirection.UNKNOWN, energyRemaining);
        }
        if (energyRemaining < energy) {
            return energyRemaining;
        }
        for (Map.Entry inv : this.getTiles().entrySet()) {
            energyRemaining = this.chargeInventory((la)inv.getValue(), (ForgeDirection)inv.getKey(), energyRemaining);
            if (energyRemaining >= energy) continue;
            return energyRemaining;
        }
        return energyRemaining;
    }

    private int chargeInventory(la inventory, ForgeDirection toSide, int energy) {
        int invStart = 0;
        int invEnd = inventory.k_();
        int energyRemaining = energy;
        if (toSide != ForgeDirection.UNKNOWN && inventory instanceof ISidedInventory) {
            invStart = ((ISidedInventory)inventory).getStartInventorySide(toSide.getOpposite());
            invEnd = invStart + ((ISidedInventory)inventory).getSizeInventorySide(toSide.getOpposite());
        }
        for (int i = invStart; i < invEnd; ++i) {
            for (IChargeHandler chargeHandler : _chargeHandlers) {
                ur s = inventory.a(i);
                if (s == null || !chargeHandler.canHandle(s) || (energyRemaining = chargeHandler.charge(s, energyRemaining)) >= energy) continue;
                this._powerSystem = chargeHandler.getPowerSystem();
                return energyRemaining;
            }
        }
        return energyRemaining;
    }

    public void setPlayer(qx player) {
        this._player = player;
        if (this.k.I) {
            this.k.o(this.l, this.m, this.n);
        }
    }

    @Override
    public boolean isConnected() {
        return super.isConnected() || this._player != null;
    }

    @Override
    public boolean isSideConnected(int side) {
        if (side == 1 && this._player != null) {
            return true;
        }
        return super.isSideConnected(side);
    }

    @Override
    public boolean isSideConnectedClient(int side) {
        if (side == 1 && this._player != null) {
            return true;
        }
        return super.isSideConnectedClient(side);
    }
}

