/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.buildcraft;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.power.PowerProviderAdvanced;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;

public class TileEntityBuildCraftProducer
extends TileEntityEnergyProducer
implements IPowerReceptor {
    private IPowerProvider _powerProvider = new PowerProviderAdvanced();

    public TileEntityBuildCraftProducer() {
        super(PowerConverterCore.powerSystemBuildCraft, 0, IPowerReceptor.class);
        this._powerProvider.configure(0, 0, 0, 0, 0);
    }

    @Override
    public int produceEnergy(int energy) {
        int mj = energy / PowerConverterCore.powerSystemBuildCraft.getInternalEnergyPerOutput();
        for (Map.Entry output : this.getTiles().entrySet()) {
            IPowerProvider pp = ((IPowerReceptor)output.getValue()).getPowerProvider();
            if (pp == null || !pp.preConditions((IPowerReceptor)output.getValue()) || pp.getMinEnergyReceived() > mj) continue;
            int energyUsed = Math.min(Math.min(pp.getMaxEnergyReceived(), mj), pp.getMaxEnergyStored() - (int)Math.floor(pp.getEnergyStored()));
            pp.receiveEnergy((float)energyUsed, (ForgeDirection)output.getKey());
            if ((energy -= energyUsed * PowerConverterCore.powerSystemBuildCraft.getInternalEnergyPerOutput()) > 0) continue;
            return 0;
        }
        return energy;
    }

    public void setPowerProvider(IPowerProvider provider) {
        this._powerProvider = provider;
    }

    public IPowerProvider getPowerProvider() {
        return this._powerProvider;
    }

    public void doWork() {
    }

    public int powerRequest() {
        return 0;
    }
}

