/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.ue;

import java.util.EnumSet;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;
import universalelectricity.core.electricity.Electricity;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IVoltage;

public class TileEntityUniversalElectricityProducer
extends TileEntityEnergyProducer
implements IVoltage {
    public TileEntityUniversalElectricityProducer() {
        this(0);
    }

    public TileEntityUniversalElectricityProducer(int voltageIndex) {
        super(PowerConverterCore.powerSystemUniversalElectricity, voltageIndex, IConductor.class);
        ElectricityConnections.registerConnector((any)this, EnumSet.range(ForgeDirection.DOWN, ForgeDirection.EAST));
    }

    @Override
    public int produceEnergy(int energy) {
        double watts = energy / PowerConverterCore.powerSystemUniversalElectricity.getInternalEnergyPerOutput();
        for (Map.Entry conductor : this.getTiles().entrySet()) {
            ElectricityNetwork network = ElectricityNetwork.getNetworkFromTileEntity((any)((any)conductor.getValue()), (ForgeDirection)((ForgeDirection)conductor.getKey()));
            if (network == null) continue;
            double request = Math.min(network.getRequest(new any[0]).getWatts(), watts);
            if (request > 0.0) {
                ((IConductor)conductor.getValue()).getNetwork().startProducing((any)this, request / this.getVoltage(new Object[0]), this.getVoltage(new Object[0]));
            } else {
                ((IConductor)conductor.getValue()).getNetwork().stopProducing((any)this);
            }
            watts -= request;
        }
        return ke.c((double)(watts * (double)PowerConverterCore.powerSystemUniversalElectricity.getInternalEnergyPerOutput()));
    }

    public double getVoltage(Object ... data) {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    public void w_() {
        Electricity.instance.unregister((any)this);
        super.w_();
    }
}

