/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.liquids;

import abo.pipes.ABOPipe;
import abo.pipes.liquids.Neighbor;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicStone;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidsBalance
extends ABOPipe {
    private final int blockTexture = 80;

    public PipeLiquidsBalance(int itemID) {
        super((PipeTransport)new PipeTransportLiquids(), (PipeLogic)new PipeLogicStone(), itemID);
        ((PipeTransportLiquids)this.transport).flowRate = (short)160;
        ((PipeTransportLiquids)this.transport).travelDelay = 1;
    }

    public int getTextureIndex(ForgeDirection direction) {
        return 80;
    }

    public int getTextureIndexForItem() {
        return 80;
    }

    public void updateEntity() {
        super.updateEntity();
        this.doWork();
    }

    public boolean isPipeConnected(any tile, ForgeDirection side) {
        if (tile == null || !(tile instanceof ITankContainer) || tile instanceof TileGenericPipe) {
            return false;
        }
        return super.isPipeConnected(tile, side);
    }

    public void doWork() {
        LinkedList<Neighbor> neighbors = new LinkedList<Neighbor>();
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            any tile = this.container.tileBuffer[o.ordinal()].getTile();
            if (tile == null || tile instanceof TileGenericPipe || !(tile instanceof ITankContainer)) continue;
            Neighbor neighbor = new Neighbor((ITankContainer)tile, o);
            neighbors.add(neighbor);
        }
        PipeTransportLiquids ltransport = (PipeTransportLiquids)this.transport;
        int liquidID = 0;
        int liquidAmount = 0;
        int liquidCapacity = 0;
        int liquidNeighbors = 0;
        for (ILiquidTank tank : ltransport.getTanks(ForgeDirection.UNKNOWN)) {
            LiquidStack liquid;
            if (tank == null || (liquid = tank.getLiquid()) == null) continue;
            liquidAmount += liquid.amount;
        }
        ILiquidTank tank = ltransport.getTanks(ForgeDirection.UNKNOWN)[ForgeDirection.UNKNOWN.ordinal()];
        LiquidStack liquid = null;
        if (tank != null) {
            liquid = tank.getLiquid();
        }
        if (liquid != null && liquid.amount > 0) {
            liquidID = liquid.itemID;
        }
        if (liquidID == 0) {
            Neighbor neighbor;
            Iterator i$ = neighbors.iterator();
            while (i$.hasNext() && ((neighbor = (Neighbor)i$.next()) == null || (liquidID = neighbor.getLiquidId()) == 0)) {
            }
        }
        for (Neighbor neighbor : neighbors) {
            if (neighbor == null || neighbor.getLiquidCapacity() <= 0 || liquidID != neighbor.getLiquidId() && neighbor.getLiquidId() != 0) continue;
            liquidAmount += neighbor.getLiquidAmount();
            liquidCapacity += neighbor.getLiquidCapacity();
            ++liquidNeighbors;
        }
        if (liquidCapacity == 0 || liquidNeighbors == 0) {
            return;
        }
        int liquidAverage = liquidAmount / liquidNeighbors;
        for (Neighbor neighbor : neighbors) {
            int filled;
            LiquidStack liquidExtracted;
            int liquidToExtract = neighbor.getLiquidAmount() - liquidAverage;
            if (liquidToExtract > 1) {
                liquidExtracted = neighbor.getTankEntity().drain(neighbor.getOrientation(), liquidToExtract > ltransport.flowRate ? (int)ltransport.flowRate : liquidToExtract, false);
                if (liquidExtracted == null || (filled = ltransport.fill(neighbor.getOrientation(), liquidExtracted, true)) == 0) continue;
                liquidExtracted = neighbor.getTankEntity().drain(neighbor.getOrientation(), filled, true);
                continue;
            }
            if (liquidToExtract >= 1 || (liquidExtracted = ltransport.drain(neighbor.getOrientation().getOpposite(), liquidToExtract > ltransport.flowRate ? (int)ltransport.flowRate : liquidToExtract, false)) == null || (filled = neighbor.getTankEntity().fill(neighbor.getOrientation().getOpposite(), liquidExtracted, true)) == 0) continue;
            liquidExtracted = ltransport.drain(neighbor.getOrientation().getOpposite(), filled, true);
        }
    }
}

