/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.liquids;

import abo.pipes.ABOPipe;
import buildcraft.core.network.IClientState;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicDiamond;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidsDiamond
extends ABOPipe
implements IClientState {
    public PipeLiquidsDiamond(int itemID) {
        super((PipeTransport)new PipeTransportLiquids(), (PipeLogic)new PipeLogicDiamond(), itemID);
        ((PipeTransportLiquids)this.transport).flowRate = (short)160;
        ((PipeTransportLiquids)this.transport).travelDelay = (short)2;
    }

    public int getTextureIndex(ForgeDirection direction) {
        int baseTexture = 208;
        if (direction == ForgeDirection.UNKNOWN) {
            return baseTexture;
        }
        return baseTexture + 1 + direction.ordinal();
    }

    public boolean outputOpen(ForgeDirection to) {
        if (!super.outputOpen(to)) {
            return false;
        }
        PipeTransportLiquids transportLiquids = (PipeTransportLiquids)this.transport;
        ILiquidTank[] tanks = transportLiquids.getTanks(ForgeDirection.UNKNOWN);
        if (tanks == null || tanks[ForgeDirection.UNKNOWN.ordinal()] == null || tanks[ForgeDirection.UNKNOWN.ordinal()].getLiquid() == null || tanks[ForgeDirection.UNKNOWN.ordinal()].getLiquid().amount == 0) {
            return true;
        }
        LiquidStack liquid = tanks[ForgeDirection.UNKNOWN.ordinal()].getLiquid();
        PipeLogicDiamond logicDiamond = (PipeLogicDiamond)this.logic;
        boolean[] validDirections = new boolean[ForgeDirection.values().length];
        boolean[] filteredDirections = new boolean[ForgeDirection.values().length];
        boolean filterForLiquid = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            validDirections[dir.ordinal()] = false;
            filteredDirections[dir.ordinal()] = false;
            if (!Utils.checkPipesConnections((any)this.container.getTile(dir), (any)this.container)) continue;
            for (int slot = 0; slot < 9; ++slot) {
                ur stack = logicDiamond.a(dir.ordinal() * 9 + slot);
                LiquidStack liquidStack = LiquidContainerRegistry.getLiquidForFilledItem((ur)stack);
                if (liquidStack == null) continue;
                filteredDirections[dir.ordinal()] = true;
                if (!liquid.isLiquidEqual(liquidStack)) continue;
                validDirections[dir.ordinal()] = true;
                filterForLiquid = true;
            }
        }
        if (filteredDirections[to.ordinal()] && validDirections[to.ordinal()]) {
            return true;
        }
        return !filterForLiquid && !filteredDirections[to.ordinal()];
    }

    public void writeData(DataOutputStream data) throws IOException {
        bq nbt = new bq();
        ((PipeLogicDiamond)this.logic).writeToNBT(nbt);
        cd.a((cd)nbt, (DataOutput)data);
    }

    public void readData(DataInputStream data) throws IOException {
        cd nbt = cd.b((DataInput)data);
        if (nbt instanceof bq) {
            this.logic.readFromNBT((bq)nbt);
        }
    }
}

