/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.liquids;

import abo.ABO;
import abo.actions.ABOEnergyPulser;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import buildcraft.api.core.Position;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLiquidsWood;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class PipeLiquidsValve
extends PipeLiquidsWood {
    private final ABOEnergyPulser pulser;
    private boolean powered;
    private boolean switched;
    private boolean toggled;
    private final int baseTexture = 0;
    private final int plainTexture = 2;

    public PipeLiquidsValve(int itemID) {
        super(itemID);
        ((PipeTransportLiquids)this.transport).flowRate = (short)160;
        ((PipeTransportLiquids)this.transport).travelDelay = (short)2;
        this.pulser = new ABOEnergyPulser((IPowerReceptor)this);
    }

    public int getTextureIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 0 + (this.isPowered() ? 1 : 0);
        }
        int metadata = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return 2 + (this.isPowered() ? 1 : 0);
        }
        return 0 + (this.isPowered() ? 1 : 0);
    }

    public int getTextureIndexForItem() {
        return 0;
    }

    public String getTextureFile() {
        return ABO.texturePipes;
    }

    public boolean isPowered() {
        return this.powered || this.switched || this.toggled;
    }

    public void updateRedstoneCurrent() {
        boolean lastPowered = this.powered;
        LinkedList<TileGenericPipe> neighbours = new LinkedList<TileGenericPipe>();
        neighbours.add(this.container);
        this.powered = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            pos.moveForwards(1.0);
            any tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isValid((Pipe)pipe.pipe)) continue;
            neighbours.add(pipe);
            if (!pipe.pipe.broadcastRedstone) continue;
            this.powered = true;
        }
        if (!this.powered) {
            this.powered = this.worldObj.B(this.xCoord, this.yCoord, this.zCoord);
        }
        if (lastPowered != this.powered) {
            for (TileGenericPipe pipe : neighbours) {
                pipe.scheduleNeighborChange();
                pipe.g();
            }
        }
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateRedstoneCurrent();
    }

    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("powered", this.powered);
        nbttagcompound.a("switched", this.switched);
        nbttagcompound.a("toggled", this.toggled);
        bq nbttagcompoundC = new bq();
        this.pulser.writeToNBT(nbttagcompoundC);
        nbttagcompound.a("Pulser", (cd)nbttagcompoundC);
    }

    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.n("powered");
        this.switched = nbttagcompound.n("switched");
        this.toggled = nbttagcompound.n("toggled");
        bq nbttagcompoundP = nbttagcompound.l("Pulser");
        this.pulser.readFromNBT(nbttagcompoundP);
    }

    public void updateEntity() {
        this.updateRedstoneCurrent();
        if (this.isPowered()) {
            this.pulser.enablePulse();
        } else {
            this.pulser.disablePulse();
            this.liquidToExtract = 0;
        }
        this.pulser.update();
        super.updateEntity();
    }

    public LinkedList getActions() {
        LinkedList actions = super.getActions();
        actions.add(ABO.actionSwitchOnPipe);
        actions.add(ABO.actionToggleOnPipe);
        actions.add(ABO.actionToggleOffPipe);
        return actions;
    }

    protected void actionsActivated(HashMap actions) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        super.actionsActivated(actions);
        this.switched = false;
        for (Integer i : actions.keySet()) {
            if (!((Boolean)actions.get(i)).booleanValue()) continue;
            if (ActionManager.actions[i] instanceof ActionSwitchOnPipe) {
                this.switched = true;
                continue;
            }
            if (ActionManager.actions[i] instanceof ActionToggleOnPipe) {
                this.toggled = true;
                continue;
            }
            if (!(ActionManager.actions[i] instanceof ActionToggleOffPipe)) continue;
            this.toggled = false;
        }
        if (lastSwitched != this.switched || lastToggled != this.toggled) {
            if (lastSwitched != this.switched && !this.switched) {
                this.toggled = false;
            }
            this.container.scheduleRenderUpdate();
            this.updateNeighbors(true);
        }
    }
}

