/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.asm;

import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import miscperipherals.asm.MiscPeripheralsPlugin;
import miscperipherals.safe.SafeModeManager;

public class MiscPeripheralsTransformer
implements IClassTransformer {
    private final List transformers;

    public MiscPeripheralsTransformer() {
        SafeModeManager.ASM_SUCCESS = true;
        String[] tnames = MiscPeripheralsPlugin.getTransformers();
        this.transformers = new ArrayList(tnames.length);
        for (String transformer : tnames) {
            try {
                this.transformers.add((IClassTransformer)Class.forName(transformer).newInstance());
            }
            catch (Throwable e) {
                MiscPeripheralsPlugin.log.log(Level.WARNING, "Could not instantiate transformer " + transformer);
                e.printStackTrace();
            }
        }
    }

    public byte[] transform(String name, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        for (IClassTransformer transformer : this.transformers) {
            try {
                if ((bytes = transformer.transform(name, bytes)) != null) continue;
                MiscPeripheralsPlugin.log.log(Level.SEVERE, "Transformer " + transformer + " corrupted class " + name);
            }
            catch (Throwable e) {
                MiscPeripheralsPlugin.log.log(Level.WARNING, "Could not transform class " + name + " using " + transformer);
                e.printStackTrace();
            }
        }
        return bytes;
    }
}

