/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import cpw.mods.fml.relauncher.Side;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import miscperipherals.api.IWrench;
import miscperipherals.api.MiscPeripheralsAPI;
import miscperipherals.block.BlockLanCable;
import miscperipherals.block.BlockMultiTile;
import miscperipherals.block.ItemBlockMultiTile;
import miscperipherals.core.APICallHandler;
import miscperipherals.core.ChunkLoadingCallback;
import miscperipherals.core.CreativeTabMiscPeripherals;
import miscperipherals.core.EventHandler;
import miscperipherals.core.LuaManager;
import miscperipherals.core.Module;
import miscperipherals.core.Proxy;
import miscperipherals.core.TickHandler;
import miscperipherals.item.ItemMulti;
import miscperipherals.module.ModuleASM;
import miscperipherals.network.GuiHandler;
import miscperipherals.network.TinyPacketHandler;
import miscperipherals.safe.ReflectionStore;
import miscperipherals.safe.SafeModeManager;
import miscperipherals.tile.TileAccelerator;
import miscperipherals.tile.TileChargeStation;
import miscperipherals.tile.TileChargeStationT2;
import miscperipherals.tile.TileChargeStationT3;
import miscperipherals.tile.TileChargeStationT4;
import miscperipherals.tile.TileChatBox;
import miscperipherals.tile.TileCrafter;
import miscperipherals.tile.TileFireworks;
import miscperipherals.tile.TileInteractiveSorter;
import miscperipherals.tile.TileNote;
import miscperipherals.tile.TilePlayerDetector;
import miscperipherals.tile.TileRailReader;
import miscperipherals.tile.TileResupplyStation;
import miscperipherals.tile.TileTeleporter;
import miscperipherals.tile.TileTeleporterT2;
import miscperipherals.upgrade.UpgradeAccelerator;
import miscperipherals.upgrade.UpgradeAnvil;
import miscperipherals.upgrade.UpgradeChatBox;
import miscperipherals.upgrade.UpgradeChunkLoader;
import miscperipherals.upgrade.UpgradeCompass;
import miscperipherals.upgrade.UpgradeFeeder;
import miscperipherals.upgrade.UpgradeInventory;
import miscperipherals.upgrade.UpgradeNote;
import miscperipherals.upgrade.UpgradeRTG;
import miscperipherals.upgrade.UpgradeResupply;
import miscperipherals.upgrade.UpgradeShears;
import miscperipherals.upgrade.UpgradeSignReader;
import miscperipherals.upgrade.UpgradeTank;
import miscperipherals.upgrade.UpgradeWrench;
import miscperipherals.upgrade.UpgradeXP;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="MiscPeripherals", name="MiscPeripherals", version="3.1", dependencies="required-after:ComputerCraft;required-after:CCTurtle;after:GregTech_Addon")
@NetworkMod(clientSideRequired=true, tinyPacketHandler=TinyPacketHandler.class)
public class MiscPeripherals {
    @Mod.Instance(value="MiscPeripherals")
    public static MiscPeripherals instance;
    @SidedProxy(clientSide="miscperipherals.core.ProxyClient", serverSide="miscperipherals.core.Proxy")
    public static Proxy proxy;
    @SidedProxy(clientSide="miscperipherals.network.GuiHandlerClient", serverSide="miscperipherals.network.GuiHandler")
    public static GuiHandler guiHandler;
    public static Logger log;
    public Configuration settings;
    public tj tabMiscPeripherals = new CreativeTabMiscPeripherals();
    public Map modules = new HashMap();
    public BlockMultiTile blockAlpha;
    public BlockMultiTile blockBeta;
    public BlockLanCable blockLanCable;
    public ItemMulti itemAlpha;
    public boolean enableChargeStation = true;
    public boolean enableChargeStationT2 = true;
    public boolean enableChargeStationT3 = true;
    public boolean enableChargeStationT4 = true;
    public boolean enableNote = true;
    public boolean enableChunkLoader = true;
    public boolean enableFeeder = true;
    public boolean enableResupply = true;
    public boolean enableShears = true;
    public boolean enableCompass = true;
    public boolean enableXP = true;
    public boolean enableInventory = true;
    public boolean enableInteractiveSorter = true;
    public boolean enableWrench = true;
    public boolean enableSignReader = true;
    public boolean enableRailReader = true;
    public boolean enableRTG = true;
    public boolean enableTank = true;
    public boolean enableTeleporter = true;
    public boolean enableTeleporterT2 = true;
    public boolean enablePlayerDetector = true;
    public boolean enableCrafter = true;
    public boolean enableAccelerator = true;
    public boolean enableFireworkLauncher = true;
    public boolean enableChatBox = true;
    public int fuelMJ = 20;
    public int fuelEU = 50;
    public int itemIDSeed = 0;
    public boolean sideSensitive = false;
    public int chunkLoaderRadius = 0;
    public double teleporterPenalty = 2.0;
    public boolean descriptive = false;
    public boolean chargeStationMultiCharge = true;
    public int chatSayRange = 64;
    public boolean chatSayUnlimitedVertical = true;
    public int chatSayRate = 1;
    public double chatReadRange = -1.0;
    public boolean chatColorCodes = false;
    public boolean chatLogCoords = true;
    public static final boolean DEBUG = false;

    public MiscPeripherals() {
        instance = this;
    }

    @Mod.PreInit
    public void onLoad(FMLPreInitializationEvent event) {
        log = event.getModLog();
        ModContainer cc = (ModContainer)Loader.instance().getIndexedModList().get("ComputerCraft");
        if (cc != null) {
            SafeModeManager.checkVersion(cc.getDisplayVersion());
        }
        if (!SafeModeManager.ASM_SUCCESS) {
            ((RelaunchClassLoader)this.getClass().getClassLoader()).registerTransformer("miscperipherals.asm.ImplementIfLoadedTransformer");
        }
        new EventHandler();
        MiscPeripheralsAPI.instance = new APICallHandler();
        LanguageRegistry lang = LanguageRegistry.instance();
        this.settings = new Configuration(new File(new File(proxy.getMinecraftFolder(), "config"), "MiscPeripherals.cfg"));
        int blockAlphaId = this.settings.getBlock("alpha", 2671, "ID for the first block").getInt();
        int blockBetaId = this.settings.getBlock("beta", blockAlphaId + 1, "ID for the second block").getInt();
        int itemAlphaId = this.settings.getItem("alpha", 26454, "ID for the first item").getInt();
        this.enableChargeStation = this.settings.get("features", "enableChargeStation", this.enableChargeStation, "Enable the Charge Station block").getBoolean(this.enableChargeStation);
        this.enableChargeStationT2 = this.settings.get("features", "enableChargeStationT2", this.enableChargeStationT2, "Enable the Advanced Charge Station").getBoolean(this.enableChargeStationT2);
        this.enableChargeStationT3 = this.settings.get("features", "enableChargeStationT3", this.enableChargeStationT3, "Enable the Lapotronic Charge Station").getBoolean(this.enableChargeStationT3);
        this.enableChargeStationT4 = this.settings.get("features", "enableChargeStationT4", this.enableChargeStationT4, "Enable the Ultimate Charge Station").getBoolean(this.enableChargeStationT4);
        this.enableNote = this.settings.get("features", "enableNote", this.enableNote, "Enable the Iron Note Block peripheral and turtle upgrade").getBoolean(this.enableNote);
        this.enableChunkLoader = this.settings.get("features", "enableChunkLoader", this.enableNote, "Enable the Chunk Loader turtle upgrade").getBoolean(this.enableChunkLoader);
        this.enableFeeder = this.settings.get("features", "enableFeeder", this.enableFeeder, "Enable the Feeder turtle upgrade").getBoolean(this.enableFeeder);
        this.enableResupply = this.settings.get("features", "enableResupply", this.enableResupply, "Enable the Resupply Station and Resupply turtle upgrade").getBoolean(this.enableResupply);
        this.enableShears = this.settings.get("features", "enableShears", this.enableShears, "Enable the Shears turtle upgrade").getBoolean(this.enableShears);
        this.enableCompass = this.settings.get("features", "enableCompass", this.enableCompass, "Enable the Compass turtle upgrade").getBoolean(this.enableCompass);
        this.enableXP = this.settings.get("features", "enableXP", this.enableXP, "Enable the XP and Anvil turtle upgrades").getBoolean(this.enableXP);
        this.enableInventory = this.settings.get("features", "enableInventory", this.enableInventory, "Enable the Inventory turtle upgrade").getBoolean(this.enableInventory);
        this.enableInteractiveSorter = this.settings.get("features", "enableInteractiveSorter", this.enableInteractiveSorter, "Enable the Interactive Sorter peripheral").getBoolean(this.enableInteractiveSorter);
        this.enableSignReader = this.settings.get("features", "enableSignReader", this.enableSignReader, "Enable the Sign Reader turtle upgrade").getBoolean(this.enableSignReader);
        this.enableRailReader = this.settings.get("features", "enableRailReader", this.enableRailReader, "Enable the Rail Reader peripheral").getBoolean(this.enableRailReader);
        this.enableTank = this.settings.get("features", "enableTank", this.enableTank, "Enable the Tank turtle upgrade").getBoolean(this.enableTank);
        this.enableTeleporter = this.settings.get("features", "enableTeleporter", this.enableTeleporter, "Enable the Turtle Teleporter").getBoolean(this.enableTeleporter);
        this.enableTeleporterT2 = this.settings.get("features", "enableTeleporterT2", this.enableTeleporterT2, "Enable the Advanced Turtle Teleporter").getBoolean(this.enableTeleporterT2);
        this.enablePlayerDetector = this.settings.get("features", "enablePlayerDetector", this.enablePlayerDetector, "Enable the Player Detector peripheral").getBoolean(this.enablePlayerDetector);
        this.enableCrafter = this.settings.get("features", "enableCrafter", this.enableCrafter, "Enable the Computer Controlled Crafter peripheral").getBoolean(this.enableCrafter);
        this.enableAccelerator = this.settings.get("features", "enableAccelerator", this.enableAccelerator, "Enable the Hardware Accelerator peripheral").getBoolean(this.enableAccelerator);
        this.enableFireworkLauncher = this.settings.get("features", "enableFireworkLauncher", this.enableFireworkLauncher, "Enable the Firework Launcher peripheral").getBoolean(this.enableFireworkLauncher);
        this.enableChatBox = this.settings.get("features", "enableChatBox", this.enableChatBox, "Enable the Chat Box peripheral and turtle upgrade").getBoolean(this.enableChatBox);
        this.fuelEU = this.settings.get("general", "fuelEU", this.fuelEU, "Amount of EU per turtle fuel value. Coal burned in a generator gives 50 EU per fuel value").getInt();
        this.fuelMJ = this.settings.get("general", "fuelMJ", this.fuelMJ, "Amount of MJ per turtle fuel value. Coal burned in a stirling engine gives 20 MJ per fuel value").getInt();
        String seed = this.settings.get((String)"general", (String)"itemIDSeed", (String)"", (String)"Seed used to encode item IDs given by peripherals, works similarly to a regular map seed. Item IDs are not encoded if empty").value.trim();
        if (seed.isEmpty()) {
            this.itemIDSeed = 0;
        } else {
            try {
                this.itemIDSeed = Integer.parseInt(seed);
            }
            catch (NumberFormatException e) {
                this.itemIDSeed = seed.hashCode();
            }
        }
        this.sideSensitive = this.settings.get("general", "sideSensitive", this.sideSensitive, "EXPERIMENTAL: If set to true, some turtle upgrades get more picky about the side they are placed on, for example, Solar Turtles needing the block the solar panel is facing to see the sun, instead of the turtle itself").getBoolean(this.sideSensitive);
        this.chunkLoaderRadius = this.settings.get("general", "chunkLoaderRadius", this.chunkLoaderRadius, "Radius of chunks the Chunk Loader peripheral will keep loaded. 0 for 1x1, 1 for 3x3, 2 for 5x5, etc. The maximum allowed by the default chunkloading settings is 5x5, edit config/forgeChunkLoading.cfg to change those.").getInt();
        this.teleporterPenalty = this.settings.get("general", "teleporterPenalty", this.teleporterPenalty, "Fuel penalty for using a Turtle Teleporter. For example, 1.0 is a 0% penalty, or 2.0 (default) is a 100% penalty").getDouble(this.teleporterPenalty);
        this.descriptive = this.settings.get("general", "descriptive", this.descriptive, "Make stuff a little bit more descriptive, prevents confusion").getBoolean(this.descriptive);
        this.chargeStationMultiCharge = this.settings.get("general", "chargeStationMultiCharge", this.chargeStationMultiCharge, "Allow advanced charge stations to charge multiple turtles").getBoolean(this.chargeStationMultiCharge);
        this.chatSayRange = this.settings.get("chatBox", "sayRange", this.chatSayRange, "Range for the Chat Box peripheral's say function. Negative values indicate infinite, always infinite on singleplayer").getInt();
        this.chatReadRange = this.settings.get("chatBox", "readRange", this.chatReadRange, "Range for the Chat Box peripheral's reading. Negative values indicate infinite, always infinite on singleplayer").getInt();
        this.chatColorCodes = this.settings.get("chatBox", "colorCodes", this.chatColorCodes, "Enable color codes on the Chat Box peripheral's say function").getBoolean(this.chatColorCodes);
        this.chatSayUnlimitedVertical = this.settings.get("chatBox", "sayUnlimitedVertical", this.chatSayUnlimitedVertical, "Allow the Chat Box peripheral to send messages with unlimited vertical distance, but only if so the program chooses").getBoolean(this.chatColorCodes);
        this.chatSayRate = this.settings.get("chatBox", "sayRate", this.chatSayRate, "Maximum number of messages per second a Chat Box peripheral can say").getInt();
        this.chatLogCoords = this.settings.get("chatBox", "logCoords", this.chatLogCoords, "Log the Chat Box peripheral's coordinates when it says a message").getBoolean(this.chatLogCoords);
        this.settings.save();
        this.blockAlpha = new BlockMultiTile(blockAlphaId);
        GameRegistry.registerBlock((amq)this.blockAlpha, ItemBlockMultiTile.class, (String)"miscperipherals.blockAlpha");
        this.blockBeta = new BlockMultiTile(blockBetaId);
        GameRegistry.registerBlock((amq)this.blockBeta, ItemBlockMultiTile.class, (String)"miscperipherals.blockBeta");
        this.itemAlpha = new ItemMulti(itemAlphaId);
        GameRegistry.registerItem((up)this.itemAlpha, (String)"miscperipherals.itemAlpha");
        this.loadModule("MiscPeripheralsASM", "ASM");
        this.loadModule("IC2@[1.112,)", "IC2");
        this.loadModule("IC2NuclearControl", "NuclearControl");
        this.loadModule("ModularForceFieldSystem", "MFFS");
        this.loadModule("GregTech_Addon", "GregTech");
        this.loadModule("AdvancedSolarPanel", "AdvancedSolarPanel");
        this.loadModule("CompactSolars", "CompactSolars");
        this.loadModule("Forestry", "Forestry");
        this.loadModule("AdditionalPipes", "AdditionalPipes");
        this.loadModule("APUnofficial", "APUnofficial");
        this.loadModule("Railcraft", "Railcraft");
        this.loadModule("StevesCarts", "StevesCarts");
        this.loadModule("ChickenChunks", "ChickenChunks");
        this.loadModule("BuildCraft|Core", "BuildCraftCore");
        this.loadModule("BuildCraft|Factory", "BuildCraftFactory");
        this.loadModule("BuildCraft|Transport", "BuildCraftTransport");
        this.loadModule("EnderStorage", "EnderStorage");
        this.loadModule("EE3", "EE3");
        this.loadModule("WR-CBE|Core", "WRCBE");
        this.loadModule("factorization", "Factorization");
        this.loadModule("Thaumcraft", "Thaumcraft");
        this.loadModule("ThermalExpansion", "ThermalExpansion");
        this.loadModule("PortalGun", "PortalGun");
        for (Module module : this.modules.values()) {
            module.onPreInit();
        }
    }

    @Mod.Init
    public void onLoading(FMLInitializationEvent event) {
        BlockMultiTile.TileData data;
        LanguageRegistry lang = LanguageRegistry.instance();
        if (this.enableChargeStation) {
            this.blockAlpha.registerTile(0).setClass(TileChargeStation.class).setSprites(0, 0, 0, 1, 0, 0).setName("chargeStation").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(MiscPeripherals.instance.descriptive ? "This block is used by turtles!" : null);
            GameRegistry.registerTileEntity(TileChargeStation.class, (String)"MiscPeripherals Charge Station");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.chargeStation.name", "Charge Station");
            APICallHandler.items.put("chargeStation", new ur((amq)this.blockAlpha, 1, 0));
        }
        if (this.enableChargeStationT2) {
            data = this.blockBeta.registerTile(1).setClass(TileChargeStationT2.class).setName("chargeStationT2").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(MiscPeripherals.instance.descriptive ? "This block is used by turtles!" : null);
            if (this.chargeStationMultiCharge) {
                data.setSprites(80, 80, 81, 81, 80, 80);
            } else {
                data.setSprites(80, 80, 80, 81, 80, 80);
            }
            GameRegistry.registerTileEntity(TileChargeStationT2.class, (String)"MiscPeripherals Charge Station T2");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.chargeStationT2.name", "Advanced Charge Station");
            APICallHandler.items.put("chargeStationT2", new ur((amq)this.blockBeta, 1, 1));
        }
        if (this.enableChargeStationT3) {
            data = this.blockBeta.registerTile(2).setClass(TileChargeStationT3.class).setName("chargeStationT3").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(MiscPeripherals.instance.descriptive ? "This block is used by turtles!" : null);
            if (this.chargeStationMultiCharge) {
                data.setSprites(82, 82, 83, 83, 83, 83);
            } else {
                data.setSprites(82, 82, 82, 83, 82, 82);
            }
            GameRegistry.registerTileEntity(TileChargeStationT3.class, (String)"MiscPeripherals Charge Station T3");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.chargeStationT3.name", "Lapotronic Charge Station");
            APICallHandler.items.put("chargeStationT3", new ur((amq)this.blockBeta, 1, 2));
        }
        if (this.enableChargeStationT4) {
            data = this.blockBeta.registerTile(3).setClass(TileChargeStationT4.class).setName("chargeStationT4").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(MiscPeripherals.instance.descriptive ? "This block is used by turtles!" : null);
            if (this.chargeStationMultiCharge) {
                data.setSprites(85, 85, 85, 85, 85, 85);
            } else {
                data.setSprites(84, 84, 84, 85, 84, 84);
            }
            GameRegistry.registerTileEntity(TileChargeStationT4.class, (String)"MiscPeripherals Charge Station T4");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.chargeStationT4.name", "Ultimate Charge Station");
            APICallHandler.items.put("chargeStationT4", new ur((amq)this.blockBeta, 1, 3));
        }
        if (this.enableNote) {
            this.blockAlpha.registerTile(1).setClass(TileNote.class).setSprites(3, 3, 3, 3, 3, 3).setName("ironNoteBlock").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileNote.class, (String)"MiscPeripherals Iron Note Block");
            lang.addStringLocalization("miscperipherals.ironNoteBlock.name", "Iron Note Block");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockAlpha, 1, 1), (Object[])new Object[]{"IGI", "RNR", "IGI", Character.valueOf('I'), up.o, Character.valueOf('G'), up.p, Character.valueOf('R'), up.aC, Character.valueOf('N'), amq.U});
            APICallHandler.items.put("ironNoteBlock", new ur((amq)this.blockAlpha, 1, 1));
        }
        if (this.enableChunkLoader) {
            this.itemAlpha.registerItem(4, 43, "chunkLoaderModule");
            lang.addStringLocalization("miscperipherals.chunkLoaderModule.name", "Chunk Loader Module");
        }
        if (this.enableFeeder) {
            this.itemAlpha.registerItem(0, 7, "feedingModule");
            lang.addStringLocalization("miscperipherals.feedingModule.name", "Feeding Module");
            GameRegistry.addRecipe((ur)new ur((up)this.itemAlpha, 1, 0), (Object[])new Object[]{"IWI", "WEW", "IWI", Character.valueOf('I'), up.o, Character.valueOf('W'), up.T, Character.valueOf('E'), up.bA});
            APICallHandler.items.put("feedingModule", new ur((up)this.itemAlpha, 1, 0));
        }
        if (this.enableResupply) {
            this.itemAlpha.registerItem(1, 45, "resupplyModule");
            lang.addStringLocalization("miscperipherals.resupplyModule.name", "Resupply Module");
            GameRegistry.addRecipe((wp)new ShapedOreRecipe(new ur((up)this.itemAlpha, 1, 1), new Object[]{"GRG", "RCR", "GRG", Character.valueOf('G'), up.p, Character.valueOf('R'), up.aC, Character.valueOf('C'), "MiscPeripherals$enderChest"}));
            APICallHandler.items.put("resupplyModule", new ur((up)this.itemAlpha, 1, 1));
            this.blockAlpha.registerTile(2).setClass(TileResupplyStation.class).setSprites(8, 8, 8, 8, 8, 8).setName("resupplyStation").setInfoText(this.descriptive ? "This block is used by turtles!" : null);
            GameRegistry.registerTileEntity(TileResupplyStation.class, (String)"MiscPeripherals Resupply Station");
            lang.addStringLocalization("miscperipherals.resupplyStation.name", "Resupply Station");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockAlpha, 1, 2), (Object[])new Object[]{"IRI", "CMC", "IRI", Character.valueOf('I'), up.o, Character.valueOf('R'), up.aC, Character.valueOf('C'), amq.ax, Character.valueOf('M'), new ur((up)this.itemAlpha, 1, 1)});
            APICallHandler.items.put("resupplyStation", new ur((amq)this.blockAlpha, 1, 2));
        }
        if (this.enableInteractiveSorter) {
            this.blockAlpha.registerTile(5).setClass(TileInteractiveSorter.class).setSprites(18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19).setName("interactiveSorter").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileInteractiveSorter.class, (String)"MiscPeripherals Interactive Sorter");
            lang.addStringLocalization("miscperipherals.interactiveSorter.name", "Interactive Sorter");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockAlpha, 1, 5), (Object[])new Object[]{"DPD", "PEP", "DPD", Character.valueOf('D'), up.n, Character.valueOf('P'), amq.ac, Character.valueOf('E'), up.bA});
            APICallHandler.items.put("interactiveSorter", new ur((amq)this.blockAlpha, 1, 5));
        }
        if (this.enableRailReader) {
            this.blockAlpha.registerTile(7).setClass(TileRailReader.class).setSprites(24, 24, 24, 24, 24, 24).setName("railReader").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileRailReader.class, (String)"MiscPeripherals Rail Reader");
            lang.addStringLocalization("miscperipherals.railReader.name", "Rail Reader");
            GameRegistry.addRecipe((wp)new ShapedOreRecipe(new ur((amq)this.blockAlpha, 1, 7), new Object[]{"GRG", "RER", "GRG", Character.valueOf('G'), up.p, Character.valueOf('R'), "MiscPeripherals$cartDetectorRail", Character.valueOf('E'), "MiscPeripherals$cartDetector"}));
            APICallHandler.items.put("railReader", new ur((amq)this.blockAlpha, 1, 7));
        }
        if (this.enableInventory) {
            this.itemAlpha.registerItem(3, 17, "inventoryModule");
            lang.addStringLocalization("miscperipherals.inventoryModule.name", "Inventory Module");
            GameRegistry.addRecipe((ur)new ur((up)this.itemAlpha, 1, 3), (Object[])new Object[]{"GEG", "E@E", "GEG", Character.valueOf('G'), up.p, Character.valueOf('E'), up.bA, Character.valueOf('@'), this.enableInteractiveSorter ? new ur((amq)this.blockAlpha, 1, 5) : up.bS});
            APICallHandler.items.put("inventoryModule", new ur((up)this.itemAlpha, 1, 3));
        }
        if (this.enableTeleporter) {
            this.blockAlpha.registerTile(10).setClass(TileTeleporter.class).setSprites(32, 32, 32, 33, 32, 32).setName("teleporter").setFacingMode(BlockMultiTile.TileData.FacingMode.All);
            GameRegistry.registerTileEntity(TileTeleporter.class, (String)"MiscPeripherals Teleporter");
            lang.addStringLocalization("miscperipherals.teleporter.name", "Turtle Teleporter");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockAlpha, 1, 10), (Object[])new Object[]{"PEP", "POP", "PEP", Character.valueOf('P'), up.bn, Character.valueOf('E'), up.bA, Character.valueOf('O'), amq.as});
            APICallHandler.items.put("teleporter", new ur((amq)this.blockAlpha, 1, 10));
        }
        if (this.enableTeleporterT2) {
            this.blockBeta.registerTile(0).setClass(TileTeleporterT2.class).setSprites(32, 32, 32, 46, 32, 32).setName("teleporterT2").setFacingMode(BlockMultiTile.TileData.FacingMode.All);
            GameRegistry.registerTileEntity(TileTeleporterT2.class, (String)"MiscPeripherals Teleporter T2");
            lang.addStringLocalization("miscperipherals.teleporterT2.name", "Advanced Turtle Teleporter");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockBeta, 1, 0), (Object[])new Object[]{"ERE", "M@M", "ERE", Character.valueOf('R'), up.aC, Character.valueOf('E'), up.bA, Character.valueOf('M'), up.bH, Character.valueOf('@'), this.enableTeleporter ? new ur((amq)this.blockAlpha, 1, 10) : amq.ak});
            APICallHandler.items.put("teleporterT2", new ur((amq)this.blockBeta, 1, 0));
        }
        if (this.enablePlayerDetector) {
            this.blockAlpha.registerTile(12).setClass(TilePlayerDetector.class).setSprites(36, 36, 36, 36, 36, 36).setName("playerDetector").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TilePlayerDetector.class, (String)"MiscPeripherals Player Detector");
            lang.addStringLocalization("miscperipherals.playerDetector.name", "Player Detector");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockAlpha, 1, 12), (Object[])new Object[]{"GRG", "EDE", "GRG", Character.valueOf('G'), up.p, Character.valueOf('E'), up.bA, Character.valueOf('D'), up.n, Character.valueOf('R'), up.aC});
            APICallHandler.items.put("playerDetector", new ur((amq)this.blockAlpha, 1, 12));
        }
        if (this.enableCrafter) {
            this.blockAlpha.registerTile(13).setClass(TileCrafter.class).setSprites(37, 37, 37, 37, 37, 37).setName("crafter");
            GameRegistry.registerTileEntity(TileCrafter.class, (String)"MiscPeripherals Crafter");
            lang.addStringLocalization("miscperipherals.crafter.name", "Computer Controlled Crafter");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockAlpha, 1, 13), (Object[])new Object[]{"RWR", "W@W", "RWR", Character.valueOf('W'), amq.aB, Character.valueOf('R'), up.aC, Character.valueOf('@'), this.enableInteractiveSorter ? new ur((amq)this.blockAlpha, 1, 5) : amq.aA});
            APICallHandler.items.put("crafter", new ur((amq)this.blockAlpha, 1, 13));
        }
        if (this.enableAccelerator) {
            this.blockAlpha.registerTile(15).setClass(TileAccelerator.class).setSprites(44, 44, 44, 44, 44, 44).setName("accelerator").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileAccelerator.class, (String)"MiscPeripherals Accelerator");
            lang.addStringLocalization("miscperipherals.accelerator.name", "Hardware Accelerator");
            APICallHandler.items.put("accelerator", new ur((amq)this.blockAlpha, 1, 15));
        }
        if (this.enableFireworkLauncher) {
            this.blockBeta.registerTile(4).setClass(TileFireworks.class).setSprites(47, 47, 47, 47, 47, 47).setName("fireworks").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileFireworks.class, (String)"MiscPeripherals Firework Launcher");
            lang.addStringLocalization("miscperipherals.fireworks.name", "Firework Launcher");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockBeta, 1, 4), (Object[])new Object[]{"IGI", "#@#", "IGI", Character.valueOf('I'), up.o, Character.valueOf('G'), up.M, Character.valueOf('#'), amq.ax, Character.valueOf('@'), amq.S});
            APICallHandler.items.put("fireworks", new ur((amq)this.blockBeta, 1, 4));
        }
        if (this.enableChatBox) {
            this.blockBeta.registerTile(5).setClass(TileChatBox.class).setSprites(86, 86, 86, 86, 86, 86).setName("chatBox").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileChatBox.class, (String)"MiscPeripherals Chat Box");
            lang.addStringLocalization("miscperipherals.chatBox.name", "Chat Box");
            GameRegistry.addRecipe((ur)new ur((amq)this.blockBeta, 1, 5), (Object[])new Object[]{"G@G", "@*@", "G@G", Character.valueOf('G'), up.p, Character.valueOf('*'), up.n, Character.valueOf('@'), amq.U});
            APICallHandler.items.put("chatBox", new ur((amq)this.blockBeta, 1, 5));
        }
        for (Module module : this.modules.values()) {
            module.onInit();
        }
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.SERVER);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
    }

    @Mod.PostInit
    public void onLoaded(FMLPostInitializationEvent event) {
        Property prop;
        ReflectionStore.initCore();
        LanguageRegistry lang = LanguageRegistry.instance();
        lang.addStringLocalization("itemGroup.miscperipherals", "MiscPeripherals");
        if (this.enableNote) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeNote());
        }
        if (this.enableChunkLoader) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeChunkLoader());
            GameRegistry.addRecipe((wp)new ShapelessOreRecipe(new ur((up)this.itemAlpha, 1, 4), new Object[]{ReflectionStore.peripheral == null ? amq.aT : new ur(ReflectionStore.peripheral, 1, 1), "MiscPeripherals$chunkLoader"}));
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadingCallback());
        }
        if (this.enableFeeder) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeFeeder());
        }
        if (this.enableResupply) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeResupply());
        }
        if (this.enableShears) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeShears());
        }
        if (this.enableCompass) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeCompass());
        }
        if (this.enableInventory) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeInventory());
        }
        if (!IWrench.handlers.isEmpty()) {
            prop = MiscPeripherals.instance.settings.get("features", "enableWrench", this.enableWrench);
            prop.comment = "Enable the Wrench turtle upgrade";
            this.enableWrench = prop.getBoolean(this.enableWrench);
            if (this.enableWrench) {
                TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeWrench());
            }
        }
        if (this.enableSignReader) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeSignReader());
        }
        if (this.enableXP) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeXP());
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeAnvil());
        }
        if (this.enableInventory) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeInventory());
        }
        if (this.enableTank) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeTank());
        }
        if (!OreDictionary.getOres((String)"dropUranium").isEmpty()) {
            prop = MiscPeripherals.instance.settings.get("features", "enableRTG", this.enableRTG);
            prop.comment = "Enable the RTG turtle upgrade";
            this.enableRTG = prop.getBoolean(this.enableRTG);
            if (this.enableRTG) {
                this.itemAlpha.registerItem(5, 31, "rtgModule");
                lang.addStringLocalization("miscperipherals.rtgModule.name", "RTG Module");
                Object copper = OreDictionary.getOres((String)"ingotCopper").isEmpty() ? up.p : "ingotCopper";
                GameRegistry.addRecipe((wp)new ShapedOreRecipe(new ur((up)this.itemAlpha, 1, 5), new Object[]{true, "CIC", "@G#", "CIC", Character.valueOf('C'), copper, Character.valueOf('I'), up.o, Character.valueOf('@'), "MiscPeripherals$rtgChamber", Character.valueOf('G'), "MiscPeripherals$rtgGenerator", Character.valueOf('#'), "MiscPeripherals$rtgCircuit"}));
                TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeRTG());
            }
        }
        if (this.enableAccelerator) {
            GameRegistry.addRecipe((ur)new ur((amq)this.blockAlpha, 1, 15), (Object[])new Object[]{"GRG", "R@R", "GRG", Character.valueOf('G'), up.p, Character.valueOf('R'), up.aC, Character.valueOf('@'), ReflectionStore.computer == null ? amq.al : ReflectionStore.computer});
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeAccelerator());
        }
        if (this.enableChatBox) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeChatBox());
        }
        for (Module module : this.modules.values()) {
            module.onPostInit();
        }
        this.settings.save();
        OreDictionary.registerOre((String)"MiscPeripherals$enderChest", (ur)new ur(amq.bV, 1, -1));
        if (ReflectionStore.diskExpanded == null) {
            OreDictionary.registerOre((String)"MiscPeripherals$disk", (ur)new ur(up.aC));
        } else {
            if (ReflectionStore.disk != null) {
                OreDictionary.registerOre((String)"MiscPeripherals$disk", (up)ReflectionStore.disk);
            }
            OreDictionary.registerOre((String)"MiscPeripherals$disk", (up)ReflectionStore.diskExpanded);
        }
        MiscPeripherals.addOreDictFallback("MiscPeripherals$cartDetector", new ur(up.bA));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$cartDetectorRail", new ur(amq.X));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$rtgChamber", new ur(up.bS));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$rtgGenerator", new ur(amq.aE));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$rtgCircuit", new ur(up.bb));
        if (this.blockLanCable != null) {
            BlockLanCable.registerType(0, "Wood", amq.A.cl, 8.0, true, false).addRecipe("plankWood");
            BlockLanCable.registerType(1, "Tin", amq.A.cl, 16.0, true, false).addRecipe("ingotTin").setOreDictTexture("blockTin", new ur(amq.ae, 1, 0));
            BlockLanCable.registerType(2, "Copper", amq.A.cl, 32.0, true, false).addRecipe("ingotCopper").setOreDictTexture("blockCopper", new ur(amq.ae, 1, 1));
            BlockLanCable.registerType(3, "Bronze", amq.A.cl, 64.0, true, false).addRecipe("ingotBronze").setOreDictTexture("blockBronze", new ur(amq.ae, 1, 12));
            BlockLanCable.registerType(4, "Iron", amq.al.cl, 128.0, true, false).addRecipe("ingotIron");
            BlockLanCable.registerType(5, "Gold", amq.ak.cl, 256.0, true, false).addRecipe("ingotGold");
            BlockLanCable.registerType(6, "Silver", amq.A.cl, 512.0, true, false).addRecipe("ingotSilver").setOreDictTexture("blockSilver", new ur(amq.ae, 1, 7));
            BlockLanCable.registerType(7, "Nickel", amq.A.cl, 1024.0, true, false).addRecipe("ingotNickel").setOreDictTexture("blockNickel", new ur(amq.ae, 1, 4));
            BlockLanCable.registerType(8, "Platinum", amq.A.cl, 2048.0, true, false).addRecipe("ingotPlatinum").setOreDictTexture("blockPlatinum", new ur(amq.ae, 1, 9));
            BlockLanCable.registerType(9, "Tungsten", amq.A.cl, 4096.0, true, false).addRecipe("ingotTungsten").setOreDictTexture("blockTungsten", new ur(amq.ae, 1, 15));
            BlockLanCable.registerType(10, "Iridium", amq.A.cl, 8192.0, true, false).addRecipe("ingotIridium").setOreDictTexture("blockIridium", new ur(amq.ae, 1, 8));
        }
        LuaManager.init();
    }

    @Mod.FingerprintWarning
    public void onFingerprintWarning(FMLFingerprintViolationEvent event) {
    }

    public static void debug(String message) {
    }

    public static boolean hasASM() {
        return !SafeModeManager.SAFE_MODE && SafeModeManager.ASM_SUCCESS;
    }

    public static boolean hasShields() {
        return MiscPeripherals.hasASM() && ModuleASM.enableShields;
    }

    public static boolean addOreDictFallback(String id, ur ore) {
        ArrayList ores = OreDictionary.getOres((String)id);
        if (ores.isEmpty()) {
            ores.add(ore);
            return true;
        }
        return false;
    }

    public boolean loadModule(String mod, String name) {
        ArtifactVersion ver = VersionParser.parseVersionReference((String)mod);
        if (Loader.isModLoaded((String)ver.getLabel()) && ver.containsVersion(((ModContainer)Loader.instance().getIndexedModList().get(ver.getLabel())).getProcessedVersion())) {
            try {
                Object module = Class.forName("miscperipherals.module.Module" + name).newInstance();
                if (!(module instanceof Module)) {
                    throw new IllegalArgumentException("Not a valid module");
                }
                this.modules.put(name, (Module)module);
            }
            catch (Throwable e) {
                log.warning("Could not load module " + name + " for mod " + mod);
                e.printStackTrace();
                return false;
            }
            log.info("Loaded module: " + name);
            return true;
        }
        return false;
    }
}

