/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import miscperipherals.core.APICallHandler;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.safe.ReflectionStore;
import miscperipherals.tile.TileBeeAnalyzer;
import miscperipherals.tile.TileTreeAnalyzer;
import miscperipherals.util.Util;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleForestry
extends Module {
    public static up backpack;
    public static up backpackT2;
    public static boolean enableBeeAnalyzer;
    public static boolean enableTreeAnalyzer;
    public static boolean enableBackpacks;
    private int backpackID;
    private int backpackT2ID;

    @Override
    public void onPreInit() {
        enableBeeAnalyzer = MiscPeripherals.instance.settings.get("features", "enableBeeAnalyzer", enableBeeAnalyzer, "Enable the Bee Analyzer peripheral").getBoolean(enableBeeAnalyzer);
        enableTreeAnalyzer = MiscPeripherals.instance.settings.get("features", "enableTreeAnalyzer", enableTreeAnalyzer, "Enable the Tree Analyzer peripheral").getBoolean(enableTreeAnalyzer);
        enableBackpacks = MiscPeripherals.instance.settings.get("features", "enableBackpacks", enableBackpacks, "Enable the Computer Engineer's Backpacks").getBoolean(enableBackpacks);
        this.backpackID = MiscPeripherals.instance.settings.getItem("backpack", 26455, "ID for the Computer Engineer's Backpack").getInt();
        this.backpackT2ID = MiscPeripherals.instance.settings.getItem("backpackT2", 26456, "ID for the Woven Computer Engineer's Backpack").getInt();
    }

    @Override
    public void onInit() {
        LanguageRegistry lang = LanguageRegistry.instance();
        if (enableBeeAnalyzer) {
            MiscPeripherals.instance.blockAlpha.registerTile(4).setClass(TileBeeAnalyzer.class).setSprites(16, 16, 16, 16, 16, 16).setName("beeAnalyzer").setInfoText(MiscPeripherals.instance.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileBeeAnalyzer.class, (String)"MiscPeripherals Bee Analyzer");
            lang.addStringLocalization("miscperipherals.beeAnalyzer.name", "Bee Analyzer");
            APICallHandler.items.put("beeAnalyzer", new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 4));
        }
        if (enableTreeAnalyzer) {
            MiscPeripherals.instance.blockAlpha.registerTile(11).setClass(TileTreeAnalyzer.class).setSprites(35, 35, 35, 35, 35, 35).setName("treeAnalyzer").setInfoText(MiscPeripherals.instance.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileTreeAnalyzer.class, (String)"MiscPeripherals Tree Analyzer");
            lang.addStringLocalization("miscperipherals.treeAnalyzer.name", "Tree Analyzer");
            APICallHandler.items.put("treeAnalyzer", new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 11));
        }
    }

    @Override
    public void onPostInit() {
        if (enableBeeAnalyzer) {
            GameRegistry.addRecipe((ur)new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 4), (Object[])new Object[]{"GRG", "RAR", "GRG", Character.valueOf('G'), up.p, Character.valueOf('R'), up.aC, Character.valueOf('A'), ItemInterface.getItem((String)"beealyzer")});
        }
        if (enableTreeAnalyzer) {
            GameRegistry.addRecipe((ur)new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 11), (Object[])new Object[]{"GRG", "RAR", "GRG", Character.valueOf('G'), up.p, Character.valueOf('R'), up.aC, Character.valueOf('A'), ItemInterface.getItem((String)"treealyzer")});
        }
        if (enableBackpacks) {
            ComputerBackpackDefinition def = new ComputerBackpackDefinition();
            backpack = BackpackManager.backpackInterface.addBackpack(this.backpackID, (IBackpackDefinition)def, EnumBackpackType.T1).a(MiscPeripherals.instance.tabMiscPeripherals);
            APICallHandler.items.put("backpack", new ur(backpack, 1, 0));
            GameRegistry.addRecipe((wp)new ShapedOreRecipe(new ur(backpack), new Object[]{"SWS", "D@D", "SWS", Character.valueOf('S'), up.K, Character.valueOf('W'), new ur(amq.ae, 1, -1), Character.valueOf('@'), amq.ax, Character.valueOf('D'), "MiscPeripherals$disk"}));
            backpackT2 = BackpackManager.backpackInterface.addBackpack(this.backpackT2ID, (IBackpackDefinition)def, EnumBackpackType.T2).a(MiscPeripherals.instance.tabMiscPeripherals);
            APICallHandler.items.put("backpackT2", new ur(backpackT2, 1, 0));
            ur wovenSilk = ItemInterface.getItem((String)"craftingMaterial");
            if (wovenSilk != null) {
                wovenSilk.b(3);
                RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(amq.E.cm, 1000), null, new ur(backpackT2), new Object[]{"SDS", "S@S", "SSS", Character.valueOf('D'), up.n, Character.valueOf('@'), backpack, Character.valueOf('S'), wovenSilk});
            }
        }
    }

    @Override
    public void handleNetworkMessage(eg source, boolean isClient, ByteArrayDataInput data) {
    }

    static {
        enableBeeAnalyzer = true;
        enableTreeAnalyzer = true;
        enableBackpacks = true;
    }

    public static class ComputerBackpackDefinition
    implements IBackpackDefinition {
        private List items;

        public ComputerBackpackDefinition() {
            this.items = Arrays.asList(ReflectionStore.computer == null ? null : new ur(ReflectionStore.computer, 1, -1), ReflectionStore.peripheral == null ? null : new ur(ReflectionStore.peripheral, 1, -1), ReflectionStore.turtle == null ? null : new ur(ReflectionStore.turtle, 1, -1), ReflectionStore.turtleExpanded == null ? null : new ur(ReflectionStore.turtleExpanded, 1, -1), ReflectionStore.printout == null ? null : new ur(ReflectionStore.printout, 1, -1), ReflectionStore.disk == null ? null : new ur(ReflectionStore.disk, 1, -1), ReflectionStore.diskExpanded == null ? null : new ur(ReflectionStore.diskExpanded, 1, -1), new ur((amq)MiscPeripherals.instance.blockAlpha, 1, -1), new ur((up)MiscPeripherals.instance.itemAlpha, 1, -1));
        }

        public String getKey() {
            return "computer";
        }

        public String getName() {
            return "Computer Engineer's Backpack";
        }

        public int getPrimaryColour() {
            return 0xC0C0C0;
        }

        public int getSecondaryColour() {
            return 0xFFFFFF;
        }

        public void addValidItem(ur validItem) {
            this.items.add(validItem);
        }

        public Collection getValidItems(qx player) {
            return this.items;
        }

        public boolean isValidItem(qx player, ur itemstack) {
            for (ur entry : this.items) {
                if (!Util.areStacksEqual(entry, itemstack)) continue;
                return true;
            }
            return false;
        }
    }
}

