/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleAPI;
import gregtechmod.api.GregTech_API;
import ic2.api.Ic2Recipes;
import ic2.api.Items;
import miscperipherals.api.IRTGFuel;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.peripheral.PeripheralRTG;
import miscperipherals.upgrade.UpgradeShield;

public class ModuleGregTech
extends Module {
    public static boolean enableIridiumShield = true;
    public static boolean enableTungstenSteelShield = true;
    public static boolean enableIridiumTungstenSteelShield = true;
    private ur thorium;
    private ur dualThorium;
    private ur quadThorium;
    private ur plutonium;
    private ur dualPlutonium;
    private ur quadPlutonium;

    @Override
    public void onPreInit() {
        if (MiscPeripherals.hasShields()) {
            enableIridiumShield = MiscPeripherals.instance.settings.get("features", "enableIridiumShield", enableIridiumShield, "Enable the Iridium Shield turtle upgrade").getBoolean(enableIridiumShield);
            enableTungstenSteelShield = MiscPeripherals.instance.settings.get("features", "enableTungstenSteelShield", enableTungstenSteelShield, "Enable the Tungsten Steel Shield turtle upgrade").getBoolean(enableTungstenSteelShield);
            enableIridiumTungstenSteelShield = MiscPeripherals.instance.settings.get("features", "enableIridiumTungstenSteelShield", enableIridiumTungstenSteelShield, "Enable the Iridium-Reinforced Tungsten Steel Shield turtle upgrade").getBoolean(enableIridiumTungstenSteelShield);
        }
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onPostInit() {
        if (MiscPeripherals.instance.enableChargeStationT4) {
            Ic2Recipes.addCraftingRecipe((ur)new ur((amq)MiscPeripherals.instance.blockBeta, 1, 3), (Object[])new Object[]{" # ", "C@C", " $ ", Character.valueOf('C'), Items.getItem((String)"trippleInsulatedIronCableItem"), Character.valueOf('#'), "circuitTier07", Character.valueOf('$'), "10kkEUStore", Character.valueOf('@'), MiscPeripherals.instance.enableChargeStationT3 ? new ur((amq)MiscPeripherals.instance.blockBeta, 1, 2) : (MiscPeripherals.instance.enableChargeStationT2 ? new ur((amq)MiscPeripherals.instance.blockBeta, 1, 1) : (MiscPeripherals.instance.enableChargeStation ? new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 0) : "rawMachineTier04"))});
        }
        if (MiscPeripherals.hasShields()) {
            ur block;
            if (enableIridiumShield) {
                block = GregTech_API.getGregTechBlock((int)0, (int)1, (int)2);
                TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeShield(207, amq.p[block.c], block.j()));
            }
            if (enableTungstenSteelShield) {
                block = GregTech_API.getGregTechBlock((int)4, (int)1, (int)8);
                TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeShield(208, amq.p[block.c], block.j()));
            }
            if (enableIridiumTungstenSteelShield) {
                block = GregTech_API.getGregTechBlock((int)4, (int)1, (int)9);
                TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeShield(209, amq.p[block.c], block.j()));
            }
        }
        this.thorium = GregTech_API.getGregTechItem((int)48, (int)1, (int)0);
        this.dualThorium = GregTech_API.getGregTechItem((int)49, (int)1, (int)0);
        this.quadThorium = GregTech_API.getGregTechItem((int)50, (int)1, (int)0);
        this.plutonium = GregTech_API.getGregTechItem((int)51, (int)1, (int)0);
        this.dualPlutonium = GregTech_API.getGregTechItem((int)52, (int)1, (int)0);
        this.quadPlutonium = GregTech_API.getGregTechItem((int)53, (int)1, (int)0);
        IRTGFuel.handlers.add(new IRTGFuel(){

            @Override
            public int get(ur stack) {
                if (stack.c == ((ModuleGregTech)ModuleGregTech.this).thorium.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * PeripheralRTG.THORIUM_MOD * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                if (stack.c == ((ModuleGregTech)ModuleGregTech.this).dualThorium.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * PeripheralRTG.THORIUM_MOD * 2.0f * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                if (stack.c == ((ModuleGregTech)ModuleGregTech.this).quadThorium.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * PeripheralRTG.THORIUM_MOD * 4.0f * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                if (stack.c == ((ModuleGregTech)ModuleGregTech.this).plutonium.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * PeripheralRTG.PLUTONIUM_MOD * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                if (stack.c == ((ModuleGregTech)ModuleGregTech.this).dualPlutonium.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * PeripheralRTG.PLUTONIUM_MOD * 2.0f * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                if (stack.c == ((ModuleGregTech)ModuleGregTech.this).quadPlutonium.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * PeripheralRTG.PLUTONIUM_MOD * 4.0f * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                return 0;
            }
        });
    }

    @Override
    public void handleNetworkMessage(eg source, boolean isClient, ByteArrayDataInput data) {
    }
}

