/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import dan200.computer.api.ComputerCraftAPI;
import dan200.computer.api.IHostedPeripheral;
import dan200.computer.api.IPeripheralHandler;
import dan200.turtle.api.ITurtleAccess;
import java.util.HashMap;
import java.util.Map;
import miscperipherals.api.IMinecartData;
import miscperipherals.api.IWrench;
import miscperipherals.core.APICallHandler;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.external.ExtTrack;
import miscperipherals.external.ExtTrackLauncher;
import miscperipherals.external.ExtTrackLimiter;
import miscperipherals.external.ExtTrackLocomotive;
import miscperipherals.external.ExtTrackPriming;
import miscperipherals.safe.Reflector;
import miscperipherals.tile.TileSignalController;
import miscperipherals.upgrade.UpgradeTank;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.Util;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.api.tracks.ITrackInstance;

public class ModuleRailcraft
extends Module {
    public static boolean enableSignalController = true;

    @Override
    public void onPreInit() {
        enableSignalController = MiscPeripherals.instance.settings.get("features", "enableSignalController", enableSignalController, "Enable the Electronic Signal Controller peripheral").getBoolean(enableSignalController);
    }

    @Override
    public void onInit() {
        if (enableSignalController) {
            ur receiver;
            MiscPeripherals.instance.blockAlpha.registerTile(14).setClass(TileSignalController.class).setSprites(40, 40, 40, 40, 40, 40).setName("signalController").setInfoText(MiscPeripherals.instance.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileSignalController.class, (String)"MiscPeripherals Signal Controller");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.signalController.name", "Electronic Signal Controller");
            ur controller = ItemRegistry.getItem((String)"signal.box.controller", (int)1);
            if (controller == null) {
                controller = ItemRegistry.getItem((String)"part.circuit.controller", (int)1);
            }
            if (controller == null) {
                controller = new ur(up.bb);
            }
            if ((receiver = ItemRegistry.getItem((String)"signal.box.receiver", (int)1)) == null) {
                receiver = ItemRegistry.getItem((String)"part.circuit.receiver", (int)1);
            }
            if (receiver == null) {
                receiver = new ur(up.bb);
            }
            GameRegistry.addRecipe((wp)new ShapedOreRecipe(new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 14), new Object[]{true, "GRG", "@D#", "GRG", Character.valueOf('G'), up.p, Character.valueOf('R'), up.aC, Character.valueOf('D'), up.n, Character.valueOf('@'), controller, Character.valueOf('#'), receiver}));
            APICallHandler.items.put("signalController", new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 14));
        }
    }

    @Override
    public void onPostInit() {
        ur ironTankGauge;
        ur worldAnchor = ItemRegistry.getItem((String)"machine.alpha.world.anchor", (int)1);
        if (worldAnchor != null) {
            OreDictionary.registerOre((String)"MiscPeripherals$chunkLoader", (ur)worldAnchor);
        }
        if ((ironTankGauge = ItemRegistry.getItem((String)"machine.beta.tank.iron.gauge", (int)1)) != null) {
            UpgradeTank.CRAFTING_ITEM[0] = ironTankGauge;
        }
        if (ItemRegistry.getItem((String)"tool.crowbar", (int)1) != null) {
            IWrench.handlers.add(new IWrench(){

                @Override
                public boolean wrench(ITurtleAccess turtle, yc world, int x, int y, int z, int side) {
                    FakePlayer player = FakePlayer.get(turtle);
                    player.alignToTurtle(turtle);
                    player.setHeldItem(ItemRegistry.getItem((String)"tool.crowbar", (int)1));
                    int id = world.a(x, y, z);
                    return amq.p[id] != null && amq.p[id].a(world, x, y, z, (qx)player, side, 0.0f, 0.0f, 0.0f);
                }

                @Override
                public boolean wrench(ITurtleAccess turtle, lq entity) {
                    FakePlayer player = FakePlayer.get(turtle);
                    player.alignToTurtle(turtle);
                    player.setHeldItem(ItemRegistry.getItem((String)"tool.crowbar", (int)1));
                    return entity.a((qx)player);
                }

                @Override
                public ur getItem() {
                    return ItemRegistry.getItem((String)"tool.crowbar", (int)1);
                }
            });
        }
        final HashMap<String, Class> tracks = new HashMap<String, Class>();
        tracks.put("railcraft.common.blocks.tracks.TrackLimiter", ExtTrackLimiter.class);
        tracks.put("railcraft.common.blocks.tracks.TrackLocomotive", ExtTrackLocomotive.class);
        tracks.put("railcraft.common.blocks.tracks.TrackLauncher", ExtTrackLauncher.class);
        tracks.put("railcraft.common.blocks.tracks.TrackPriming", ExtTrackPriming.class);
        ComputerCraftAPI.registerExternalPeripheral((Class)Reflector.getClass("railcraft.common.blocks.tracks.TileTrack"), (IPeripheralHandler)new IPeripheralHandler(){

            public IHostedPeripheral getPeripheral(any tile) {
                ITrackInstance track = (ITrackInstance)Reflector.getField(tile, "track", ITrackInstance.class);
                Class extClass = (Class)tracks.get(track.getClass().getName());
                if (extClass != null) {
                    try {
                        return (IHostedPeripheral)Reflector.construct(extClass, ExtTrack.class, track);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
        IMinecartData.handlers.add(new IMinecartData(){

            @Override
            public Map getMinecartData(py cart) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                String className = cart.getClass().getName();
                if (className.equals("railcraft.common.carts.EntityCartAnchor")) {
                    Long fuel;
                    ret.put("__CART_TYPE__", "anchor");
                    Integer refuel = (Integer)Reflector.invoke("railcraft.common.core.RailcraftConfig", "anchorRefuel", Integer.class, new Object[0]);
                    if (refuel != null && refuel > 0 && (fuel = (Long)Reflector.invoke(cart, "getAnchorFuel", Long.class, new Object[0])) != null) {
                        ret.put("fuel", (double)fuel.longValue() / (72000.0 * (double)refuel.intValue()));
                    }
                } else if (className.equals("railcraft.common.carts.EntityCartBasic")) {
                    ret.put("__CART_TYPE__", "basic");
                    ret.put("occupied", cart.n != null);
                    if (cart.n != null) {
                        ret.put("username", cart.n.an());
                    }
                } else if (className.equals("railcraft.common.carts.EntityCartChest")) {
                    ret.put("__CART_TYPE__", "storage");
                } else if (className.equals("railcraft.common.carts.EntityCartEnergy")) {
                    Integer transferLimit;
                    ret.put("__CART_TYPE__", "energy");
                    ret.put("type", Util.camelCase(cart.b().replace(" Cart", "")));
                    ret.put("energy", cart.v().c(20));
                    Integer capacity = (Integer)Reflector.invoke(cart, "getCapacity", Integer.class, new Object[0]);
                    if (capacity != null) {
                        ret.put("capacity", capacity);
                    }
                    if ((transferLimit = (Integer)Reflector.invoke(cart, "getTransferLimit", Integer.class, new Object[0])) != null) {
                        ret.put("transferRate", transferLimit);
                    }
                } else if (className.equals("railcraft.common.carts.EntityCartFurnace")) {
                    ret.put("__CART_TYPE__", "furnace");
                    bq workaround = new bq();
                    cart.d(workaround);
                    ret.put("fuel", workaround.e("Fuel"));
                } else if (className.equals("railcraft.common.carts.EntityCartPumpkin")) {
                    ret.put("__CART_TYPE__", "pumpkin");
                } else if (className.equals("railcraft.common.carts.EntityCartGift")) {
                    ret.put("__CART_TYPE__", "gift");
                } else if (className.equals("railcraft.common.carts.EntityCartTNT")) {
                    ret.put("__CART_TYPE__", "tnt");
                    ret.put("fuse", Integer.valueOf(cart.v().b(20)));
                } else if (className.equals("railcraft.common.carts.EntityCartTank")) {
                    ret.put("__CART_TYPE__", "tank");
                    mj dw = cart.v();
                    if (dw.c(20) != 0) {
                        ret.put("liquid", Util.getUUID(new ur(dw.c(20), dw.c(22), dw.c(21))));
                        ret.put("amount", dw.c(22));
                    }
                } else if (className.equals("railcraft.common.carts.EntityCartTrackRelayer")) {
                    ret.put("__CART_TYPE__", "trackRelayer");
                } else if (className.equals("railcraft.common.carts.EntityCartUndercutter")) {
                    ret.put("__CART_TYPE__", "undercutter");
                } else if (className.equals("railcraft.common.carts.EntityCartWork")) {
                    ret.put("__CART_TYPE__", "work");
                } else if (className.equals("railcraft.common.carts.EntityTunnelBore")) {
                    ret.put("__CART_TYPE__", "tunnelBore");
                    ur head = cart.a(0);
                    if (head != null) {
                        ret.put("boreHead", Util.getUUID(head));
                        ret.put("boreHeadHealth", 1.0 - (double)head.j() / (double)head.k());
                    }
                } else if (className.equals("railcraft.common.carts.EntityLocomotiveSteam")) {
                    ret.put("__CART_TYPE__", "locomotiveSteam");
                    mj dw = cart.v();
                    ret.put("mode", Util.camelCase(ExtTrackLocomotive.locoModes[dw.a(22)].toString()));
                    ret.put("speed", dw.a(23));
                } else {
                    return null;
                }
                return ret;
            }
        });
    }

    @Override
    public void handleNetworkMessage(eg source, boolean isClient, ByteArrayDataInput data) {
    }

    public static void updateTrack(ITrackInstance track) {
        Reflector.invoke(track, "sendUpdateToClient", Object.class, new Object[0]);
    }
}

