/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.network;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;

public class NetworkHelper {
    public static cz getTileInfoPacket(any tile) {
        if (!(tile instanceof IEntityAdditionalSpawnData)) {
            throw new IllegalArgumentException("Tile information packets require a TileEntity implementing IEntityAdditionalSpawnData");
        }
        IEntityAdditionalSpawnData data = (IEntityAdditionalSpawnData)tile;
        ByteArrayDataOutput os = ByteStreams.newDataOutput();
        os.writeInt(tile.l);
        os.writeInt(tile.m);
        os.writeInt(tile.n);
        data.writeSpawnData(os);
        return PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)3, (byte[])os.toByteArray());
    }

    public static cz getModulePacket(Module module, byte[] data) {
        ByteArrayDataOutput os = ByteStreams.newDataOutput();
        os.writeUTF(module.getClass().getSimpleName().substring(6));
        os.write(data);
        return PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)6, (byte[])data);
    }
}

