/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.ITinyPacketHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import dan200.turtle.api.ITurtleAccess;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.peripheral.PeripheralBarrel;
import miscperipherals.peripheral.PeripheralNote;
import miscperipherals.peripheral.PeripheralTank;
import miscperipherals.tile.TileTeleporter;
import miscperipherals.util.Util;
import net.minecraftforge.liquids.LiquidStack;

public class TinyPacketHandler
implements ITinyPacketHandler {
    public void handle(eg handler, cz mapData) {
        ByteArrayDataInput is = ByteStreams.newDataInput((byte[])mapData.c);
        MiscPeripherals.debug("Received packet " + mapData.b + " from " + handler + " (payload size " + mapData.c.length + ")");
        switch (mapData.b) {
            case 0: {
                if (handler instanceof iv) {
                    return;
                }
                double x = is.readDouble();
                double y = is.readDouble();
                double z = is.readDouble();
                int instrument = is.readUnsignedByte();
                int note = is.readUnsignedByte();
                PeripheralNote.playNote(MiscPeripherals.proxy.getClientWorld(), x, y, z, instrument, note);
                break;
            }
            case 1: {
                if (handler instanceof iv) {
                    return;
                }
                int entity = is.readInt();
                lq ent = MiscPeripherals.proxy.getClientEntityById(entity);
                if (ent == null) break;
                MiscPeripherals.proxy.spawnHeartParticles(ent);
                break;
            }
            case 2: {
                PeripheralTank tank;
                if (handler instanceof iv) {
                    return;
                }
                int x = is.readInt();
                int y = is.readInt();
                int z = is.readInt();
                short liquidId = is.readShort();
                short liquidMeta = is.readShort();
                int amount = is.readInt();
                any te = MiscPeripherals.proxy.getClientWorld().q(x, y, z);
                if (!(te instanceof ITurtleAccess) || (tank = (PeripheralTank)Util.getPeripheral((ITurtleAccess)te, PeripheralTank.class)) == null) break;
                tank.liquid = amount == Integer.MIN_VALUE ? null : new LiquidStack((int)liquidId, amount, (int)liquidMeta);
                break;
            }
            case 3: {
                if (handler instanceof iv) {
                    return;
                }
                int x = is.readInt();
                int y = is.readInt();
                int z = is.readInt();
                any te = MiscPeripherals.proxy.getClientWorld().q(x, y, z);
                if (!(te instanceof IEntityAdditionalSpawnData)) break;
                ((IEntityAdditionalSpawnData)te).readSpawnData(is);
                break;
            }
            case 4: {
                if (handler instanceof iv) {
                    return;
                }
                int x = is.readInt();
                int y = is.readInt();
                int z = is.readInt();
                byte flag = is.readByte();
                any te = MiscPeripherals.proxy.getClientWorld().q(x, y, z);
                if (!(te instanceof TileTeleporter)) break;
                ((TileTeleporter)te).onTeleport(flag);
                break;
            }
            case 5: {
                PeripheralBarrel barrel;
                if (handler instanceof iv) {
                    return;
                }
                int x = is.readInt();
                int y = is.readInt();
                int z = is.readInt();
                int amount = is.readInt();
                int maxSize = is.readInt();
                any te = MiscPeripherals.proxy.getClientWorld().q(x, y, z);
                if (!(te instanceof ITurtleAccess) || (barrel = (PeripheralBarrel)Util.getPeripheral((ITurtleAccess)te, PeripheralBarrel.class)) == null) break;
                barrel.clientAmount = amount;
                barrel.maxSize = maxSize;
                break;
            }
            case 6: {
                String module = is.readUTF();
                Module mod = (Module)MiscPeripherals.instance.modules.get(module);
                if (mod == null) {
                    MiscPeripherals.log.warning("Received packet for unknown module " + module);
                    break;
                }
                mod.handleNetworkMessage(handler, handler instanceof iv, is);
            }
        }
    }
}

