/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;

public class PeripheralAccelerator
implements IHostedPeripheral {
    private final Positionable positionable;
    private List alarms = new ArrayList();
    private List alarmsToRemove = new ArrayList();
    private Random rnd = new Random();

    public PeripheralAccelerator(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public PeripheralAccelerator(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public String getType() {
        return "hardwareAccelerator";
    }

    public String[] getMethodNames() {
        return new String[]{"tickAlarm", "bf"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int ticks = (int)Math.floor((Double)arguments[0]);
                if (ticks < 1) {
                    throw new Exception("bad tick time " + ticks + " (expected 1-)");
                }
                double id = this.rnd.nextLong();
                final TickAlarm alarm = new TickAlarm(computer, ticks, id);
                TickHandler.addTickCallback(this.positionable.getWorld(), new Callable(){

                    public Object call() throws Exception {
                        PeripheralAccelerator.this.alarms.add(alarm);
                        return null;
                    }
                }).get();
                return new Object[]{id};
            }
            case 1: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof String)) {
                    throw new Exception("bad argument #2 (expected string)");
                }
                double id = this.rnd.nextLong();
                BFExecutor exe = new BFExecutor(computer, id, (String)arguments[0], arguments.length > 1 ? (String)arguments[1] : null);
                Thread thread = new Thread((Runnable)exe, "MiscPeripherals BF executor [" + computer + "]");
                thread.start();
                return new Object[]{id};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        this.alarmsToRemove.clear();
        for (TickAlarm alarm : this.alarms) {
            if (alarm.tick()) continue;
            this.alarmsToRemove.add(alarm);
        }
        this.alarms.removeAll(this.alarmsToRemove);
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }

    private static class BFExecutor
    implements Runnable {
        private final IComputerAccess computer;
        private final double id;
        private final String code;
        private final String input;

        public BFExecutor(IComputerAccess computer, double id, String code, String input) {
            this.computer = computer;
            this.id = id;
            this.code = code;
            this.input = input;
        }

        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (Throwable e) {
                this.computer.queueEvent("bf_fail", new Object[]{this.id, e.getClass() == Exception.class ? e.getMessage() : e.toString()});
            }
        }

        private void execute() throws Exception {
            int head = 0;
            int[] tape = new int[256];
            int inputHead = -1;
            int depth = 0;
            int[] depthpos = new int[256];
            int open = 0;
            int close = 0;
            for (int i = 0; i < this.code.length(); ++i) {
                char c = this.code.charAt(i);
                if (c == '[') {
                    ++open;
                    continue;
                }
                if (c != ']') continue;
                ++close;
            }
            if (open != close) {
                throw new Exception("parse error: unmatched brackets: " + open + " != " + close);
            }
            String output = "";
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < this.code.length()) {
                char c = this.code.charAt(i);
                switch (c) {
                    case '>': {
                        if (++head > tape.length) {
                            throw new Exception("at " + i + ": seeking after tape length of " + tape.length);
                        }
                        ++i;
                        break;
                    }
                    case '<': {
                        if (--head < 0) {
                            throw new Exception("at " + i + ": seeking before tape start");
                        }
                        ++i;
                        break;
                    }
                    case '+': {
                        int n = head;
                        tape[n] = tape[n] + 1;
                        ++i;
                        break;
                    }
                    case '-': {
                        int n = head;
                        tape[n] = tape[n] - 1;
                        ++i;
                        break;
                    }
                    case '.': {
                        output = output + (char)tape[head];
                        ++i;
                        break;
                    }
                    case ',': {
                        if (this.input == null || ++inputHead >= this.input.length()) {
                            throw new Exception("at " + i + ": reading beyond input size");
                        }
                        tape[head] = this.input.charAt(inputHead);
                        ++i;
                        break;
                    }
                    case '[': {
                        depthpos[++depth] = i++;
                        if (tape[head] != 0) break;
                        int j = 0;
                        while (j < depth) {
                            if (this.code.charAt(++i) != ']') continue;
                            ++j;
                        }
                        ++i;
                        break;
                    }
                    case ']': {
                        i = tape[head] != 0 ? depthpos[depth] : ++i;
                        --depth;
                        break;
                    }
                    case '$': {
                        this.computer.queueEvent("bf_insta", new Object[]{this.id, tape[head]});
                        ++i;
                        break;
                    }
                    default: {
                        ++i;
                    }
                }
                if (System.currentTimeMillis() - start <= 10000L) continue;
                throw new Exception("executing for too long");
            }
            this.computer.queueEvent("bf_done", new Object[]{this.id, output});
        }
    }

    private static class TickAlarm {
        private final IComputerAccess computer;
        private int ticks;
        private final double id;

        public TickAlarm(IComputerAccess computer, int ticks, double id) {
            this.computer = computer;
            this.ticks = ticks;
            this.id = id;
        }

        public boolean tick() {
            if (--this.ticks <= 0) {
                this.computer.queueEvent("tickAlarm", new Object[]{this.id});
                return false;
            }
            return true;
        }
    }
}

