/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.util.Random;
import miscperipherals.api.IBlastResistantPeripheral;
import miscperipherals.peripheral.PeripheralXP;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.FakeWorld;
import miscperipherals.util.RandomStoredSeed;
import miscperipherals.util.Util;

public class PeripheralAnvil
implements IHostedPeripheral,
IBlastResistantPeripheral {
    public static final float DAMAGE_CHANCE = 0.12f;
    public static final int MAX_DAMAGE = 2;
    public static final int MAX_COST = 40;
    private final ITurtleAccess turtle;
    private final TurtleSide side;
    private final RandomStoredSeed random = new RandomStoredSeed();
    public int damage = 0;

    public PeripheralAnvil(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    public String getType() {
        return "anvil";
    }

    public String[] getMethodNames() {
        return new String[]{"getRepairCost", "repair", "suicide"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof String)) {
                    throw new Exception("bad argument #3 (expected string)");
                }
                int slotA = (int)Math.floor((Double)arguments[0]);
                int slotB = (int)Math.floor((Double)arguments[1]);
                if (slotA < 1 || slotA > this.turtle.getInventorySize()) {
                    throw new Exception("bad first slot " + slotA + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slotA;
                if (slotB < 1 || slotB > this.turtle.getInventorySize()) {
                    throw new Exception("bad second slot " + slotB + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slotB;
                if (this.damage > 2) {
                    return new Object[]{0};
                }
                AnvilData data = this.getAnvilData(this.turtle.getSlotContents(slotA), this.turtle.getSlotContents(slotB), arguments.length > 2 ? (String)arguments[2] : "");
                return new Object[]{data.cost < 1 || data.cost >= 40 ? 0 : data.cost};
            }
            case 1: {
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof String)) {
                    throw new Exception("bad argument #3 (expected string)");
                }
                int slotA = (int)Math.floor((Double)arguments[0]);
                int slotB = (int)Math.floor((Double)arguments[1]);
                if (slotA < 1 || slotA > this.turtle.getInventorySize()) {
                    throw new Exception("bad first slot " + slotA + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slotA;
                if (slotB < 1 || slotB > this.turtle.getInventorySize()) {
                    throw new Exception("bad second slot " + slotB + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slotB;
                if (this.damage > 2) {
                    return new Object[]{false};
                }
                PeripheralXP xp = (PeripheralXP)Util.getPeripheral(this.turtle, PeripheralXP.class);
                if (xp == null) {
                    return new Object[]{false};
                }
                AnvilData data = this.getAnvilData(this.turtle.getSlotContents(slotA), this.turtle.getSlotContents(slotB), arguments.length > 2 && arguments[2] != null ? (String)arguments[2] : "");
                if (data.cost < 1 || data.cost >= 40) {
                    return new Object[]{false};
                }
                xp.addLevels(-data.cost, true);
                this.turtle.setSlotContents(slotA, data.stack);
                this.turtle.setSlotContents(slotB, null);
                this.damage(false);
                return new Object[]{true};
            }
            case 2: {
                if (this.damage > 2) {
                    return new Object[]{false};
                }
                yc world = this.turtle.getWorld();
                int facing = this.turtle.getFacingDir();
                aoj pos = this.turtle.getPosition();
                int x = (int)Math.floor(pos.c);
                int y = (int)Math.floor(pos.d);
                int z = (int)Math.floor(pos.e);
                boolean success = false;
                int[] directions = new int[]{0, facing, Util.OPPOSITE[facing], 1};
                for (int i = 0; i < directions.length; ++i) {
                    if (!Util.isPassthroughBlock(world, x + r.b[directions[i]], y + r.c[directions[i]], z + r.d[directions[i]]) || !world.d(x + r.b[directions[i]], y + r.c[directions[i]], z + r.d[directions[i]], amq.ck.cm, this.damage << 2)) continue;
                    amq.ck.b(world, x + r.b[directions[i]], y + r.c[directions[i]], z + r.d[directions[i]], (Random)this.random);
                    success = true;
                    break;
                }
                if (success) {
                    this.damage(true);
                }
                return new Object[]{success};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(bq nbttagcompound) {
        this.damage = nbttagcompound.e("damage");
        this.random.setSeed(nbttagcompound.f("rndSeed"));
    }

    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("damage", this.damage);
        nbttagcompound.a("rndSeed", this.random.getSeed());
    }

    @Override
    public float getBlastResistance(lq exploder, yc world, double x, double y, double z) {
        return amq.ck.a(exploder);
    }

    private void damage(boolean forceBreak) {
        if (this.random.nextFloat() < 0.12f && ++this.damage > 2 || forceBreak) {
            this.damage = 3;
            Util.setTurtleUpgrade(this.turtle, this.side, null);
        }
    }

    private sm getFakeAnvil() {
        FakeWorld world = FakeWorld.instance;
        world.c(100, 64, 100, amq.ck.cm, 0);
        FakePlayer player = FakePlayer.get((Object)world);
        return new sm(player.bJ, (yc)world, 100, 64, 100, (qx)player);
    }

    private AnvilData getAnvilData(ur a, ur b, String name) {
        sm anvil = this.getFakeAnvil();
        la input = anvil.a((int)0).f;
        la output = anvil.a((int)2).f;
        input.a(0, a);
        input.a(1, b);
        anvil.a(name);
        return new AnvilData(anvil.a, output.a(0));
    }

    private static class AnvilData {
        public final int cost;
        public final ur stack;

        public AnvilData(int cost, ur stack) {
            this.cost = cost;
            this.stack = stack;
        }
    }
}

