/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.List;
import java.util.Random;
import miscperipherals.api.IBreakPeripheral;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.util.Util;

public class PeripheralBarrel
implements IHostedPeripheral,
IBreakPeripheral {
    public static final int TICK_RATE = 20;
    private final ITurtleAccess turtle;
    public ur item;
    public int maxSize = 4096;
    private int ticker = new Random().nextInt();
    private int prevAmount = 0;
    private int prevMaxSize = this.maxSize;
    public int clientAmount = 0;

    public PeripheralBarrel(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "barrel";
    }

    public String[] getMethodNames() {
        return new String[]{"get", "put", "getItem"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                int amount;
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int n = amount = arguments.length > 0 ? (int)Math.floor((Double)arguments[0]) : Integer.MAX_VALUE;
                if (this.item == null) {
                    return new Object[]{0};
                }
                ur slotstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (slotstack != null && this.item != null && !this.areItemStacksEqual(slotstack, this.item)) {
                    return new Object[]{0};
                }
                int space = slotstack == null ? this.item.d() : slotstack.d() - slotstack.a;
                int take = Math.min(space, Math.min(this.item.a, amount));
                if (slotstack == null) {
                    slotstack = this.item.l();
                    slotstack.a = take;
                } else {
                    slotstack.a += take;
                }
                this.item.a -= take;
                if (this.item.a <= 0) {
                    this.item = null;
                }
                this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slotstack);
                this.updateAmount();
                return new Object[]{take};
            }
            case 1: {
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int amount = arguments.length > 0 ? (int)Math.floor((Double)arguments[0]) : Integer.MAX_VALUE;
                ur slotstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (slotstack == null) {
                    return new Object[]{0};
                }
                if (this.item != null && !this.areItemStacksEqual(slotstack, this.item)) {
                    return new Object[]{0};
                }
                int put = Math.min(this.maxSize - (this.item == null ? 0 : this.item.a), Math.min(slotstack.a, amount));
                if (this.item == null) {
                    this.item = slotstack.l();
                } else {
                    this.item.a += put;
                }
                slotstack.a -= put;
                if (slotstack.a <= 0) {
                    slotstack = null;
                }
                this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slotstack);
                this.updateAmount();
                return new Object[]{put};
            }
            case 2: {
                if (this.item == null) {
                    return new Object[]{null, 0};
                }
                return new Object[]{Util.getUUID(this.item), this.item.a};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        if (this.item != null) {
            if (this.item.a > this.maxSize) {
                this.item.a = this.maxSize;
            } else if (this.item.a == 0) {
                this.item = null;
            }
        }
        if (this.turtle.getWorld() != null && !this.turtle.getWorld().I && ++this.ticker >= 20) {
            this.updateAmount();
        }
    }

    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("itemID") && nbttagcompound.b("itemSize") && nbttagcompound.b("itemMeta")) {
            this.item = new ur((int)nbttagcompound.d("itemID"), nbttagcompound.e("itemSize"), (int)nbttagcompound.d("itemMeta"));
            if (nbttagcompound.b("itemTag")) {
                this.item.d = nbttagcompound.l("itemTag");
            }
        } else {
            this.item = null;
        }
    }

    public void writeToNBT(bq nbttagcompound) {
        if (this.item != null) {
            nbttagcompound.a("itemID", (short)this.item.c);
            nbttagcompound.a("itemSize", this.item.a);
            nbttagcompound.a("itemMeta", (short)this.item.j());
            if (this.item.d != null) {
                nbttagcompound.a("itemTag", (cd)this.item.d);
            }
        }
    }

    @Override
    public void onBreak(ITurtleAccess turtle, int fortune, List drops) {
        if (this.item == null) {
            return;
        }
        int dropped = 0;
        do {
            ur drop = this.item.l();
            drop.a = Math.min(this.item.a, this.item.d());
            drops.add(drop);
            this.item.a -= drop.a;
        } while (++dropped < 64 && this.item.a > 0);
        this.item = null;
    }

    private boolean areItemStacksEqual(ur a, ur b) {
        if (a == null && a == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.c == b.c && a.j() == b.j() && ur.a((ur)a, (ur)b);
    }

    private void updateAmount() {
        int amount;
        int n = amount = this.item == null ? 0 : this.item.a;
        if (this.prevAmount != amount || this.prevMaxSize != this.maxSize) {
            yc world = this.turtle.getWorld();
            aoj pos = this.turtle.getPosition();
            int x = (int)Math.floor(pos.c);
            int y = (int)Math.floor(pos.d);
            int z = (int)Math.floor(pos.e);
            ByteArrayDataOutput os = ByteStreams.newDataOutput();
            os.writeInt(x);
            os.writeInt(y);
            os.writeInt(z);
            os.writeInt(amount);
            os.writeInt(this.maxSize);
            PacketDispatcher.sendPacketToAllAround((double)(pos.c + 0.5), (double)(pos.d + 0.5), (double)(pos.e + 0.5), (double)64.0, (int)world.u.h, (ef)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)5, (byte[])os.toByteArray()));
        }
    }
}

