/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import net.minecraftforge.common.ForgeChunkManager;

public class PeripheralChunkLoader
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private IComputerAccess computer;
    public boolean ticketCreated = false;
    private ForgeChunkManager.Ticket ticket;
    private int oldChunkX = Integer.MIN_VALUE;
    private int oldChunkZ = Integer.MIN_VALUE;
    private double oldXCoord = -2.147483648E9;
    private double oldYCoord = -2.147483648E9;
    private double oldZCoord = -2.147483648E9;

    public PeripheralChunkLoader(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "chunkLoader";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.computer = computer;
    }

    public void detach(IComputerAccess computer) {
        this.computer = computer;
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
    }

    public void update() {
        if (!MiscPeripherals.proxy.isServer()) {
            return;
        }
        aoj pos = this.turtle.getPosition();
        if (pos == null) {
            MiscPeripherals.log.warning("Turtle position is null! " + this.turtle);
            return;
        }
        if (!this.ticketCreated) {
            this.ticketCreated = true;
            this.ticket = ForgeChunkManager.requestTicket((Object)MiscPeripherals.instance, (yc)this.turtle.getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (this.ticket == null) {
                MiscPeripherals.log.warning("Chunk loading limit exceeded, not chunkloading turtle " + (this.computer == null ? "[unknown]" : Integer.valueOf(this.computer.getID())) + " at (" + (int)pos.c + "," + (int)pos.d + "," + (int)pos.e + ")");
                return;
            }
            int width = MiscPeripherals.instance.chunkLoaderRadius * 2 + 1;
            this.ticket.setChunkListDepth(width * width);
        }
        if (pos.c != this.oldXCoord || pos.d != this.oldYCoord || pos.e != this.oldZCoord) {
            this.updatePos((int)pos.c, (int)pos.d, (int)pos.e);
            this.oldXCoord = pos.c;
            this.oldYCoord = pos.d;
            this.oldZCoord = pos.e;
        }
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }

    private void updatePos(int x, int y, int z) {
        if (this.ticket != null) {
            bq modData = this.ticket.getModData();
            modData.a("turtleX", x);
            modData.a("turtleY", y);
            modData.a("turtleZ", z);
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (this.oldChunkX != chunkX || this.oldChunkZ != chunkZ) {
                int radius = MiscPeripherals.instance.chunkLoaderRadius;
                for (int cx = chunkX - radius; cx <= chunkX + radius; ++cx) {
                    for (int cz2 = chunkZ - radius; cz2 <= chunkZ + radius; ++cz2) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (xv)new xv(cx, cz2));
                    }
                }
                this.oldChunkX = chunkX;
                this.oldChunkZ = chunkZ;
            }
        }
    }
}

