/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.base.Throwables;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import miscperipherals.core.LuaManager;
import miscperipherals.util.Util;

public class PeripheralInventory
implements IHostedPeripheral {
    private static final Map whitelistCache = new WeakHashMap();
    private final ITurtleAccess turtle;

    public PeripheralInventory(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "inventory";
    }

    public String[] getMethodNames() {
        return new String[]{"suck", "suckUp", "suckDown", "suckSneaky", "suckSneakyUp", "suckSneakyDown", "drop", "dropUp", "dropDown", "dropSneaky", "dropSneakyUp", "dropSneakyDown", "getItem", "getItemUp", "getItemDown"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        try {
            switch (method) {
                case 0: 
                case 1: 
                case 2: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]);
                    if (slot < 0) {
                        throw new Exception("invalid slot " + slot + " (expected 0-)");
                    }
                    int amount = Integer.MIN_VALUE;
                    if (arguments.length > 1) {
                        if (!(arguments[0] instanceof Double)) {
                            throw new Exception("bad argument #2 (expected number)");
                        }
                        amount = (int)Math.floor((Double)arguments[1]);
                    }
                    if (amount < 0 && amount != Integer.MIN_VALUE) {
                        throw new Exception("invalid amount " + amount + " (expected 1-)");
                    }
                    return this.suck(method == 0 ? this.turtle.getFacingDir() : (method == 1 ? 1 : 0), slot, amount);
                }
                case 3: 
                case 4: 
                case 5: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]);
                    if (slot < 0 || slot > 5) {
                        throw new Exception("invalid side " + slot + " (expected 0-5)");
                    }
                    ++slot;
                    slot *= -1;
                    int amount = Integer.MIN_VALUE;
                    if (arguments.length > 1) {
                        if (!(arguments[0] instanceof Double)) {
                            throw new Exception("bad argument #2 (expected number)");
                        }
                        amount = (int)Math.floor((Double)arguments[1]);
                    }
                    if (amount < 0 && amount != Integer.MIN_VALUE) {
                        throw new Exception("invalid amount " + amount + " (expected 1-)");
                    }
                    return this.suck(method == 3 ? this.turtle.getFacingDir() : (method == 4 ? 1 : 0), slot, amount);
                }
                case 6: 
                case 7: 
                case 8: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]);
                    if (slot < 0) {
                        throw new Exception("invalid slot " + slot + " (expected 0-)");
                    }
                    int amount = Integer.MIN_VALUE;
                    if (arguments.length > 1) {
                        if (!(arguments[0] instanceof Double)) {
                            throw new Exception("bad argument #2 (expected number)");
                        }
                        amount = (int)Math.floor((Double)arguments[1]);
                    }
                    if (amount < 0 && amount != Integer.MIN_VALUE) {
                        throw new Exception("invalid amount " + amount + " (expected 1-)");
                    }
                    return this.drop(method == 6 ? this.turtle.getFacingDir() : (method == 7 ? 1 : 0), slot, amount);
                }
                case 9: 
                case 10: 
                case 11: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]);
                    if (slot < 0 || slot > 5) {
                        throw new Exception("invalid side " + slot + " (expected 0-5)");
                    }
                    ++slot;
                    slot *= -1;
                    int amount = Integer.MIN_VALUE;
                    if (arguments.length > 1) {
                        if (!(arguments[0] instanceof Double)) {
                            throw new Exception("bad argument #2 (expected number)");
                        }
                        amount = (int)Math.floor((Double)arguments[1]);
                    }
                    if (amount < 0 && amount != Integer.MIN_VALUE) {
                        throw new Exception("invalid amount " + amount + " (expected 1-)");
                    }
                    return this.drop(method == 9 ? this.turtle.getFacingDir() : (method == 10 ? 1 : 0), slot, amount);
                }
                case 12: 
                case 13: 
                case 14: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]);
                    if (slot < 0) {
                        throw new Exception("invalid slot " + slot + " (expected 0-)");
                    }
                    la inv = this.getInventory(method == 12 ? this.turtle.getFacingDir() : (method == 13 ? 1 : 0));
                    if (inv == null || slot >= inv.k_() || !this.getWhitelist(inv).contains(slot)) {
                        return new Object[]{null, null};
                    }
                    ur stack = inv.a(slot);
                    if (stack == null) {
                        return new Object[]{null, null};
                    }
                    return new Object[]{Util.getUUID(stack), stack.a};
                }
            }
        }
        catch (Throwable e) {
            if (e.getClass() == Exception.class) {
                Throwables.propagateIfPossible((Throwable)e);
            }
            e.printStackTrace();
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }

    private List getWhitelist(la inv) {
        if (whitelistCache.containsKey(inv)) {
            return (List)whitelistCache.get(inv);
        }
        List ret = Util.buildInventorySlotWhitelist(inv);
        whitelistCache.put(inv, ret);
        return ret;
    }

    private any getTile(int facing) {
        aoj pos = this.turtle.getPosition();
        return this.turtle.getWorld().q((int)pos.c + r.b[facing], (int)pos.d + r.c[facing], (int)pos.e + r.d[facing]);
    }

    private la getInventory(int facing) {
        any te = this.getTile(facing);
        if (te instanceof la) {
            return (la)te;
        }
        return null;
    }

    private Object[] suck(int facing, int slot, int amount) throws Exception {
        int fromSlot;
        ur stack;
        la inv;
        ur selstack;
        int selslot;
        block10: {
            int start;
            block9: {
                selslot = this.turtle.getSelectedSlot();
                selstack = this.turtle.getSlotContents(selslot);
                inv = this.getInventory(facing);
                if (inv == null) {
                    return new Object[]{false};
                }
                stack = null;
                fromSlot = -1;
                if (slot < 0) break block9;
                if (slot >= inv.k_()) {
                    return new Object[]{false};
                }
                ur slotstack = inv.a(slot);
                if (!this.getWhitelist(inv).contains(slot) || selstack != null && !Util.areStacksEqual(slotstack, selstack)) break block10;
                stack = slotstack;
                fromSlot = slot;
                break block10;
            }
            int side = slot * -1 - 1;
            for (int i = start = Util.getInventoryStart(inv, side); i < start + Util.getInventorySize(inv, side); ++i) {
                ur slotstack = inv.a(i);
                if (slotstack == null || selstack != null && !Util.areStacksEqual(slotstack, selstack)) continue;
                stack = slotstack;
                fromSlot = i;
                break;
            }
        }
        if (stack == null || fromSlot < 0 || fromSlot >= inv.k_()) {
            return new Object[]{false};
        }
        int toAdd = selstack == null ? stack.d() : stack.d() - selstack.a;
        if ((toAdd = Math.min(Math.min(toAdd, stack.a), amount)) < amount) {
            return new Object[]{false};
        }
        if (amount > 0) {
            toAdd = amount;
        }
        inv.a(fromSlot, toAdd);
        ur toInv = stack.l();
        toInv.a = toAdd;
        if (selstack != null) {
            toInv.a += selstack.a;
        }
        if (toInv.a > 0) {
            this.turtle.setSlotContents(selslot, toInv);
        } else {
            this.turtle.setSlotContents(selslot, null);
        }
        return new Object[]{true};
    }

    private Object[] drop(int facing, int slot, int amount) throws Exception {
        ur slotstack;
        int i;
        ArrayList<Integer> toSlots;
        la inv;
        ur selstack;
        block11: {
            int start;
            block10: {
                int selslot = this.turtle.getSelectedSlot();
                selstack = this.turtle.getSlotContents(selslot);
                if (selstack == null) {
                    return new Object[]{false};
                }
                if (amount == Integer.MIN_VALUE) {
                    amount = selstack.a;
                }
                amount = Math.min(amount, selstack.a);
                inv = this.getInventory(facing);
                if (inv == null) {
                    return new Object[]{false};
                }
                toSlots = new ArrayList<Integer>();
                if (slot < 0) break block10;
                if (slot >= inv.k_()) {
                    return new Object[]{false};
                }
                ur slotstack2 = inv.a(slot);
                if (!this.getWhitelist(inv).contains(slot) || slotstack2 != null && !Util.areStacksEqual(slotstack2, selstack)) break block11;
                toSlots.add(slot);
                break block11;
            }
            int side = slot * -1 - 1;
            for (i = start = Util.getInventoryStart(inv, side); i < start + Util.getInventorySize(inv, side); ++i) {
                slotstack = inv.a(i);
                if (slotstack != null && !Util.areStacksEqual(slotstack, selstack)) continue;
                toSlots.add(i);
                break;
            }
        }
        int total = 0;
        HashMap amounts = new HashMap(toSlots.size());
        for (i = 0; i < toSlots.size(); ++i) {
            slotstack = inv.a(((Integer)toSlots.get(i)).intValue());
            int amountToAdd = slotstack == null ? Math.min(selstack.d(), inv.c()) : Math.min(selstack.d(), inv.c()) - slotstack.a;
            amounts.put(toSlots.get(i), amountToAdd);
            total += amountToAdd;
        }
        if (total < amount) {
            return new Object[]{false};
        }
        total = amount;
        int added = 0;
        Set slots = amounts.keySet();
        for (int i2 = 0; i2 < slots.size(); ++i2) {
            int add = Math.min(total, (Integer)amounts.get(toSlots.get(i2)));
            total -= add;
            int slotToDrop = (Integer)toSlots.get(i2);
            ur stack = inv.a(slotToDrop);
            if (stack == null) {
                stack = selstack.l();
                stack.a = 0;
            }
            stack.a += add;
            added += add;
            inv.a(slotToDrop, stack);
            if (total <= 0) break;
        }
        selstack.a -= added;
        if (selstack.a <= 0) {
            selstack = null;
        }
        this.turtle.setSlotContents(this.turtle.getSelectedSlot(), selstack);
        return new Object[]{true};
    }
}

