/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import chb.mods.mffs.api.IForceEnergyItems;
import chb.mods.mffs.api.IForceEnergyStorageBlock;
import chb.mods.mffs.api.ISwitchabel;
import chb.mods.mffs.api.PointXYZ;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.TickHandler;
import miscperipherals.safe.ReflectionStore;
import miscperipherals.safe.Reflector;
import miscperipherals.util.InventoryReference;
import miscperipherals.util.Util;

public class PeripheralMFFS
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private int id = Integer.MIN_VALUE;
    private String error;

    public PeripheralMFFS(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "mffs";
    }

    public String[] getMethodNames() {
        return new String[]{"switch", "createCard", "teleport", "teleportUp", "teleportDown", "getStorage", "getStorageUp", "getStorageDown", "switchUp", "switchDown", "getError"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 8: 
            case 9: {
                final yc world = this.turtle.getWorld();
                final int direction = method == 0 ? this.turtle.getFacingDir() : (method == 8 ? 1 : 0);
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Boolean call() {
                        ISwitchabel switchable;
                        Boolean ag;
                        aoh mop = Util.rayTraceBlock(PeripheralMFFS.this.turtle, direction);
                        any te = world.q(mop.b, mop.c, mop.d);
                        if (te instanceof ISwitchabel && (ag = (Boolean)Reflector.invoke("chb.mods.mffs.common.SecurityHelper", "isAccessGranted", Boolean.class, te, PeripheralMFFS.this.getDummyPlayer(), world, ReflectionStore.eb, false)) != null && ag.booleanValue() && (switchable = (ISwitchabel)te).isSwitchabel() && PeripheralMFFS.this.consumeFP(1000)) {
                            switchable.toggelSwitchValue();
                            return true;
                        }
                        return false;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 1: {
                yc world = this.turtle.getWorld();
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Boolean call() {
                        if (ReflectionStore.MFFSitemcardempty == null || ReflectionStore.MFFSItemIDCard == null) {
                            return false;
                        }
                        ur slotstack = PeripheralMFFS.this.turtle.getSlotContents(PeripheralMFFS.this.turtle.getSelectedSlot());
                        if (slotstack != null && slotstack.c == ReflectionStore.MFFSitemcardempty.cj && PeripheralMFFS.this.consumeFP(1000)) {
                            ur card = new ur(ReflectionStore.MFFSItemIDCard);
                            Reflector.invoke("chb.mods.mffs.common.item.ItemCardPersonalID", "setOwner", Object.class, card, PeripheralMFFS.this.getTurtleUsername());
                            if (--slotstack.a <= 0) {
                                PeripheralMFFS.this.turtle.setSlotContents(PeripheralMFFS.this.turtle.getSelectedSlot(), card);
                            } else {
                                PeripheralMFFS.this.turtle.setSlotContents(PeripheralMFFS.this.turtle.getSelectedSlot(), slotstack);
                                Util.storeOrDrop(PeripheralMFFS.this.turtle, card);
                            }
                            return true;
                        }
                        return false;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 2: 
            case 3: 
            case 4: {
                final yc world = this.turtle.getWorld();
                final int direction = method == 2 ? this.turtle.getFacingDir() : (method == 3 ? 1 : 0);
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Boolean call() {
                        if (ReflectionStore.forcefieldtransportcost == null) {
                            return false;
                        }
                        aoh mop = Util.rayTraceBlock(PeripheralMFFS.this.turtle, direction);
                        Object ffw = Reflector.invoke("chb.mods.mffs.common.WorldMap", "getForceFieldWorld", Object.class, world);
                        if (ffw == null) {
                            PeripheralMFFS.this.error = "World forcefield map missing";
                            return false;
                        }
                        Object ffbs = Reflector.invoke(ffw, "getForceFieldStackMap", Object.class, new PointXYZ(mop.b, mop.c, mop.d, world));
                        if (ffbs != null) {
                            int ffb = -1;
                            Integer genid = (Integer)Reflector.invoke(ffbs, "getGenratorID", Integer.class, new Object[0]);
                            Integer projid = (Integer)Reflector.invoke(ffbs, "getProjectorID", Integer.class, new Object[0]);
                            if (genid == null || projid == null) {
                                PeripheralMFFS.this.error = "No capacitor or projector ID associated with this forcefield";
                                return false;
                            }
                            Object net = Reflector.invoke("chb.mods.mffs.common.Linkgrid", "getWorldMap", Object.class, world);
                            Map capacitorMap = (Map)Reflector.invoke(net, "getCapacitor", Map.class, new Object[0]);
                            Map projectorMap = (Map)Reflector.invoke(net, "getProjektor", Map.class, new Object[0]);
                            if (capacitorMap == null || projectorMap == null) {
                                PeripheralMFFS.this.error = "No capacitor or projector associated with this forcefield";
                                return false;
                            }
                            Object capacitor = capacitorMap.get(genid);
                            Object projector = projectorMap.get(projid);
                            Boolean active = (Boolean)Reflector.invoke(projector, "isActive", Boolean.class, new Object[0]);
                            if (active != null && active.booleanValue()) {
                                boolean pass = false;
                                Integer accessType = (Integer)Reflector.invoke(projector, "getaccesstyp", Integer.class, new Object[0]);
                                if (accessType == null) {
                                    return false;
                                }
                                switch (accessType) {
                                    case 1: {
                                        pass = true;
                                        break;
                                    }
                                    case 2: {
                                        Boolean lpass = (Boolean)Reflector.invoke("chb.mods.mffs.common.SecurityHelper", "isAccessGranted", Boolean.class, capacitor, PeripheralMFFS.this.getDummyPlayer(), world, ReflectionStore.ffb, false);
                                        pass = lpass != null && lpass != false;
                                        break;
                                    }
                                    case 3: {
                                        Boolean lpass = (Boolean)Reflector.invoke("chb.mods.mffs.common.SecurityHelper", "isAccessGranted", Boolean.class, projector, PeripheralMFFS.this.getDummyPlayer(), world, ReflectionStore.ffb, false);
                                        pass = lpass != null && lpass != false;
                                        break;
                                    }
                                }
                                if (pass) {
                                    int i = 0;
                                    while (ffb != 0) {
                                        Integer lffb = (Integer)Reflector.invoke(ffw, "isExistForceFieldStackMap", Integer.class, mop.b, mop.c, mop.d, i, direction);
                                        if (lffb == null) {
                                            return false;
                                        }
                                        ffb = lffb;
                                        if (ffb == 0) continue;
                                        ++i;
                                    }
                                    Integer lgenid = (Integer)Reflector.invoke(ffw, "isExistForceFieldStackMap", Integer.class, mop.b, mop.c, mop.d, i - 1, PeripheralMFFS.this.turtle.getFacingDir());
                                    if (lgenid != null && genid == lgenid && i >= 0 && i <= 5) {
                                        int toX = mop.b + r.b[direction] * i;
                                        int toY = mop.c + r.c[direction] * i;
                                        int toZ = mop.d + r.d[direction] * i;
                                        if (Util.isPassthroughBlock(world, toX, toY, toZ)) {
                                            if (PeripheralMFFS.this.consumeFP(ReflectionStore.forcefieldtransportcost) && Util.teleportTurtleTo(PeripheralMFFS.this.turtle, world, toX, toY, toZ)) {
                                                return true;
                                            }
                                            PeripheralMFFS.this.error = "Not enough force power or teleport failed";
                                        } else {
                                            PeripheralMFFS.this.error = "Destination obstructed or not enough force power";
                                        }
                                    } else {
                                        PeripheralMFFS.this.error = "Field too thick";
                                    }
                                } else {
                                    PeripheralMFFS.this.error = "Access denied";
                                }
                            } else {
                                PeripheralMFFS.this.error = "Projector not active";
                            }
                        } else {
                            PeripheralMFFS.this.error = "Not in front of a forcefield";
                        }
                        return false;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 5: 
            case 6: 
            case 7: {
                final yc world = this.turtle.getWorld();
                final int direction = method == 5 ? this.turtle.getFacingDir() : (method == 6 ? 1 : 0);
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Object call() {
                        try {
                            aoh mop = Util.rayTraceBlock(PeripheralMFFS.this.turtle, direction);
                            any te = world.q(mop.b, mop.c, mop.d);
                            if (te != null && te.getClass().getName().equals("chb.mods.mffs.common.tileentity.TileEntitySecStorage") && te instanceof la) {
                                Boolean access = (Boolean)Reflector.invoke("chb.mods.mffs.common.SecurityHelper", "isAccessGranted", Boolean.class, te, PeripheralMFFS.this.getDummyPlayer(), world, ReflectionStore.oss, false);
                                if (access != null && access.booleanValue()) {
                                    InventoryReference invr = new InventoryReference(PeripheralMFFS.this.turtle, (la)te);
                                    invr.start = 1;
                                    invr.size = 54;
                                    invr.dim = world.u.h;
                                    invr.coordinates = new s(mop.b, mop.c, mop.d);
                                    return invr;
                                }
                                PeripheralMFFS.this.error = "Access denied";
                            }
                        }
                        catch (Throwable e) {
                            PeripheralMFFS.this.error = "Internal error";
                        }
                        return null;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 10: {
                return new Object[]{this.error};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return false;
    }

    public void attach(IComputerAccess computer) {
        this.id = computer.getID();
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }

    private boolean consumeFP(int amount) {
        int i;
        int i2;
        int haveFP = 0;
        yc world = this.turtle.getWorld();
        for (i2 = 0; i2 < 6 && haveFP < amount; ++i2) {
            aoh mop = Util.rayTraceBlock(this.turtle, i2);
            any te = world.q(mop.b, mop.c, mop.d);
            if (!(te instanceof IForceEnergyStorageBlock)) continue;
            haveFP += ((IForceEnergyStorageBlock)te).getStorageAvailablePower();
        }
        for (i2 = 0; i2 < this.turtle.getInventorySize() && haveFP < amount; ++i2) {
            ur stack = this.turtle.getSlotContents(i2);
            if (stack == null || !(stack.b() instanceof IForceEnergyItems)) continue;
            haveFP += ((IForceEnergyItems)stack.b()).getAvailablePower(stack);
        }
        if (haveFP < amount) {
            return false;
        }
        int remain = amount;
        for (i = 0; i < 6 && remain > 0; ++i) {
            aoh mop = Util.rayTraceBlock(this.turtle, i);
            any te = world.q(mop.b, mop.c, mop.d);
            if (!(te instanceof IForceEnergyStorageBlock)) continue;
            IForceEnergyStorageBlock fesb = (IForceEnergyStorageBlock)te;
            int drain = Math.min(fesb.getStorageAvailablePower(), remain);
            fesb.consumePowerfromStorage(drain, false);
            remain -= drain;
        }
        for (i = 0; i < this.turtle.getInventorySize() && remain > 0; ++i) {
            ur stack = this.turtle.getSlotContents(i);
            if (stack == null || !(stack.b() instanceof IForceEnergyItems)) continue;
            IForceEnergyItems feitem = (IForceEnergyItems)stack.b();
            int drain = Math.min(feitem.getAvailablePower(stack), remain);
            feitem.consumePower(stack, drain, false);
            this.turtle.setSlotContents(i, stack);
            remain -= drain;
        }
        return true;
    }

    private qx getDummyPlayer() {
        qx player = new qx(this.turtle.getWorld()){

            public void a(String var1) {
            }

            public s b() {
                return new s(0, 0, 0);
            }

            public boolean a(int var1, String var2) {
                return false;
            }
        };
        player.bR = this.getTurtleUsername();
        return player;
    }

    private String getTurtleUsername() {
        return "Turtle " + (this.id == Integer.MIN_VALUE ? "???" : "#" + this.id);
    }
}

