/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.core.TickHandler;
import miscperipherals.network.NetworkHelper;
import miscperipherals.util.Util;
import net.minecraft.server.MinecraftServer;
import xcompwiz.mystcraft.api.MystObjects;
import xcompwiz.mystcraft.api.linking.ILinkInfo;

public class PeripheralMystcraft
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private int id = Integer.MIN_VALUE;

    public PeripheralMystcraft(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "mystcraft";
    }

    public String[] getMethodNames() {
        return new String[]{"useBook"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Boolean call() {
                        ur slotstack = PeripheralMystcraft.this.turtle.getSlotContents(PeripheralMystcraft.this.turtle.getSelectedSlot());
                        if (slotstack == null || !PeripheralMystcraft.this.isValidBook(slotstack) || slotstack.d == null) {
                            MiscPeripherals.debug("Link failed due to invalid item: " + slotstack + " " + (slotstack == null ? "N/A" : slotstack.b()) + " " + (slotstack == null ? "N/A" : slotstack.d));
                            return false;
                        }
                        LinkInfoStack lo = new LinkInfoStack(slotstack);
                        if (PeripheralMystcraft.this.isLinkPermitted(lo)) {
                            in world = MinecraftServer.D().a(lo.getDimensionUID());
                            if (world == null) {
                                MiscPeripherals.debug("Link failed due to null world: " + lo.getDimensionUID());
                                return false;
                            }
                            s dest = lo.getSpawn();
                            dest.b += 2;
                            if (Util.isPassthroughBlock((yc)world, dest.a, dest.b, dest.c)) {
                                int i;
                                if (!lo.getFlag("Following")) {
                                    for (i = 0; i < 6 && !PeripheralMystcraft.this.turtle.dropItemStack(slotstack, i); ++i) {
                                    }
                                    PeripheralMystcraft.this.turtle.setSlotContents(PeripheralMystcraft.this.turtle.getSelectedSlot(), null);
                                }
                                if (lo.getFlag("Disarm")) {
                                    for (i = 0; i < PeripheralMystcraft.this.turtle.getInventorySize(); ++i) {
                                        ur stack = PeripheralMystcraft.this.turtle.getSlotContents(i);
                                        for (int j = 0; j < 6 && !PeripheralMystcraft.this.turtle.dropItemStack(stack, i); ++j) {
                                        }
                                        PeripheralMystcraft.this.turtle.setSlotContents(i, null);
                                    }
                                }
                                aoj pos = PeripheralMystcraft.this.turtle.getPosition();
                                String sound = "myst.sound.link";
                                if (lo.getFlag("Disarm")) {
                                    sound = "myst.sound.link-disarm";
                                } else if (lo.getProperty("Sound") != null) {
                                    sound = lo.getProperty("Sound");
                                } else if (lo.getFlag("Following")) {
                                    sound = "myst.sound.link-following";
                                } else if (lo.getFlag("Intra Linking")) {
                                    sound = "myst.sound.link-intra";
                                }
                                ByteArrayDataOutput os = ByteStreams.newDataOutput();
                                os.writeInt((int)pos.c);
                                os.writeInt((int)pos.d);
                                os.writeInt((int)pos.e);
                                os.writeUTF(sound);
                                PacketDispatcher.sendPacketToAllAround((double)(pos.c + 0.5), (double)(pos.d + 0.5), (double)(pos.e + 0.5), (double)64.0, (int)((PeripheralMystcraft)PeripheralMystcraft.this).turtle.getWorld().u.h, (ef)NetworkHelper.getModulePacket((Module)MiscPeripherals.instance.modules.get("Mystcraft"), os.toByteArray()));
                                os = ByteStreams.newDataOutput();
                                os.writeInt(dest.a);
                                os.writeInt(dest.b);
                                os.writeInt(dest.c);
                                os.writeUTF(sound);
                                PacketDispatcher.sendPacketToAllAround((double)((double)dest.a + 0.5), (double)((double)dest.b + 0.5), (double)((double)dest.c + 0.5), (double)64.0, (int)world.u.h, (ef)NetworkHelper.getModulePacket((Module)MiscPeripherals.instance.modules.get("Mystcraft"), os.toByteArray()));
                                return Util.teleportTurtleTo(PeripheralMystcraft.this.turtle, (yc)world, dest.a, dest.b, dest.c);
                            }
                            MiscPeripherals.debug("Link failed due to bad target " + world.a(dest.a, dest.b, dest.c));
                            return false;
                        }
                        MiscPeripherals.debug("Link failed due to not permitted");
                        return false;
                    }
                });
                return new Object[]{callback.get()};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return false;
    }

    public void attach(IComputerAccess computer) {
        this.id = computer.getID();
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }

    private boolean isLinkPermitted(ILinkInfo lo) {
        return lo.getFlag("Intra Linking") || lo.getDimensionUID() == this.turtle.getWorld().u.h;
    }

    private boolean isValidBook(ur stack) {
        return stack.c == MystObjects.linkbook.cj || stack.c == MystObjects.descriptive_book.cj;
    }

    public class LinkInfoStack
    implements ILinkInfo {
        private final ur stack;

        public LinkInfoStack(ur stack) {
            this.stack = stack;
        }

        public String getDisplayName() {
            return this.stack.d != null && this.stack.d.b("agename") ? this.stack.d.i("agename") : "???";
        }

        public void setDisplayName(String displayname) {
            if (this.stack.d == null) {
                this.stack.d = new bq();
            }
            this.stack.d.a("agename", displayname);
        }

        public int getDimensionUID() {
            return this.stack.d != null ? (this.stack.d.b("AgeUID") ? this.stack.d.e("AgeUID") : (this.stack.d.b("Dimension") ? this.stack.d.e("Dimension") : 0)) : 0;
        }

        public void setDimensionUID(int uid) {
            if (this.stack.d == null) {
                this.stack.d = new bq();
            }
            this.stack.d.a("AgeUID", uid);
        }

        public s getSpawn() {
            if (this.stack.d != null && this.stack.d.b("SpawnX") && this.stack.d.b("SpawnY") && this.stack.d.b("SpawnZ")) {
                return new s(this.stack.d.e("SpawnX"), this.stack.d.e("SpawnY"), this.stack.d.e("SpawnZ"));
            }
            return null;
        }

        public void setSpawn(s spawn) {
            if (this.stack.d == null) {
                this.stack.d = new bq();
            }
            if (spawn != null) {
                this.stack.d.a("SpawnX", spawn.a);
                this.stack.d.a("SpawnY", spawn.b);
                this.stack.d.a("SpawnZ", spawn.c);
            }
        }

        public float getSpawnYaw() {
            return this.stack.d != null && this.stack.d.b("SpawnYaw") ? this.stack.d.g("SpawnYaw") : 0.0f;
        }

        public void setSpawnYaw(float spawnyaw) {
            if (this.stack.d == null) {
                this.stack.d = new bq();
            }
            this.stack.d.a("SpawnYaw", spawnyaw);
        }

        public boolean getFlag(String flag) {
            return this.stack.d != null && this.stack.d.b(flag) && this.stack.d.n(flag);
        }

        public void setFlag(String flag, boolean value) {
            if (this.stack.d == null) {
                this.stack.d = new bq();
            }
            this.stack.d.a(flag, value);
        }

        public String getProperty(String flag) {
            return this.stack.d != null && this.stack.d.b(flag) ? this.stack.d.i(flag) : null;
        }

        public void setProperty(String flag, String value) {
            if (this.stack.d == null) {
                this.stack.d = new bq();
            }
            this.stack.d.a(flag, value);
        }

        public bq getTagCompound() {
            return this.stack.d;
        }
    }
}

