/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import miscperipherals.api.IRTGFuel;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.util.Util;
import net.minecraftforge.oredict.OreDictionary;

public class PeripheralRTG
implements IHostedPeripheral {
    public static int OUTPUT = 1;
    public static int URANIUM_TOTAL = 1000000;
    public static float THORIUM_MOD = 1.0f;
    public static float PLUTONIUM_MOD = 4.0f;
    private final ITurtleAccess turtle;
    private float euBuffer = 0.0f;
    private int fuel = 0;

    public PeripheralRTG(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "rtg";
    }

    public String[] getMethodNames() {
        return new String[]{"refuel"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                ur selstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                int amount = Integer.MIN_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                if (selstack == null) {
                    return new Object[]{0};
                }
                int refuel = 0;
                for (IRTGFuel fuelhandler : IRTGFuel.handlers) {
                    int fuel = fuelhandler.get(selstack);
                    if (fuel <= 0) continue;
                    refuel = fuel;
                    break;
                }
                if (amount < 1 || amount > selstack.a) {
                    amount = selstack.a;
                }
                this.fuel += (refuel *= amount);
                selstack.a -= amount;
                if (selstack.a <= 0) {
                    selstack = null;
                }
                this.turtle.setSlotContents(this.turtle.getSelectedSlot(), selstack);
                return new Object[]{refuel};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        if (!MiscPeripherals.proxy.isServer()) {
            return;
        }
        if (this.fuel >= OUTPUT) {
            this.fuel -= OUTPUT;
        } else {
            return;
        }
        this.euBuffer += (float)OUTPUT;
        while (this.euBuffer >= (float)MiscPeripherals.instance.fuelEU) {
            this.euBuffer -= (float)(MiscPeripherals.instance.fuelEU * Util.addFuel(this.turtle, 1));
        }
    }

    public void readFromNBT(bq nbttagcompound) {
        this.fuel = nbttagcompound.e("rtgFuel");
    }

    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("rtgFuel", this.fuel);
    }

    static {
        IRTGFuel.handlers.add(new DefaultRTGFuel());
    }

    public static class DefaultRTGFuel
    implements IRTGFuel {
        @Override
        public int get(ur stack) {
            for (ur uranium : Util.merge(OreDictionary.getOres((String)"dropUranium"), OreDictionary.getOres((String)"ingotUranium"))) {
                if (!Util.areStacksEqual(stack, uranium)) continue;
                return URANIUM_TOTAL;
            }
            for (ur thorium : Util.merge(OreDictionary.getOres((String)"dustThorium"), OreDictionary.getOres((String)"ingotThorium"))) {
                if (!Util.areStacksEqual(stack, thorium)) continue;
                return (int)((float)URANIUM_TOTAL * THORIUM_MOD);
            }
            for (ur plutonium : Util.merge(OreDictionary.getOres((String)"dustPlutonium"), OreDictionary.getOres((String)"ingotPlutonium"))) {
                if (!Util.areStacksEqual(stack, plutonium)) continue;
                return (int)((float)URANIUM_TOTAL * PLUTONIUM_MOD);
            }
            return 0;
        }
    }
}

