/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import miscperipherals.core.LuaManager;
import miscperipherals.tile.TileResupplyStation;
import miscperipherals.util.Util;

public class PeripheralResupply
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private s link;
    private String error = "";

    public PeripheralResupply(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "resupply";
    }

    public String[] getMethodNames() {
        return new String[]{"resupply", "link", "getError"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length != 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int slot = ((Double)arguments[0]).intValue();
                if (slot < 1 || slot > this.turtle.getInventorySize()) {
                    throw new Exception("bad slot (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slot;
                this.error = "";
                if (this.link == null) {
                    this.error = "Not linked";
                    return new Object[]{false};
                }
                any te = this.turtle.getWorld().q(this.link.a, this.link.b, this.link.c);
                if (!(te instanceof TileResupplyStation)) {
                    this.link = null;
                    this.error = "Not linked";
                    return new Object[]{false};
                }
                TileResupplyStation rs = (TileResupplyStation)te;
                ur curItem = this.turtle.getSlotContents(slot);
                if (curItem == null) {
                    this.error = "Cannot identify item";
                    return new Object[]{false};
                }
                int resupplyAmount = curItem.d() - curItem.a;
                if (resupplyAmount < 1) {
                    return new Object[]{true};
                }
                int resupplied = rs.resupply(curItem, resupplyAmount);
                if (resupplied <= 0) {
                    this.error = "Not enough items";
                    return new Object[]{false};
                }
                curItem.a += resupplied;
                this.turtle.setSlotContents(slot, curItem);
                return new Object[]{true};
            }
            case 1: {
                aoj pos = this.turtle.getPosition();
                for (int i = 0; i < 6; ++i) {
                    any te = this.turtle.getWorld().q((int)pos.c + r.b[i], (int)pos.d + r.c[i], (int)pos.e + r.d[i]);
                    if (!(te instanceof TileResupplyStation)) continue;
                    this.link = new s(te.l, te.m, te.n);
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 2: {
                return new Object[]{this.error};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("link")) {
            this.link = Util.readChunkCoordinatesFromNBT(nbttagcompound);
        }
    }

    public void writeToNBT(bq nbttagcompound) {
        if (this.link != null) {
            bq link = new bq();
            Util.writeChunkCoordinatesToNBT(this.link, link);
            nbttagcompound.a("link", (cd)link);
        }
    }
}

