/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.api.IBlastResistantPeripheral;
import miscperipherals.api.IXPSource;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.util.RandomStoredSeed;
import miscperipherals.util.Util;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PeripheralXP
implements IHostedPeripheral,
IBlastResistantPeripheral {
    private static final int TICK_RATE = 20;
    private static final double COLLECT_RANGE = 2.0;
    private static final int MAX_LEVEL = 30;
    private final ITurtleAccess turtle;
    private final RandomStoredSeed random = new RandomStoredSeed();
    private int experience = 0;
    private int experienceRemainder = 0;
    private int experienceLevel = 0;
    private boolean autoCollect = false;
    private int ticker = this.random.nextInt(20);

    public PeripheralXP(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "xp";
    }

    public String[] getMethodNames() {
        return new String[]{"add", "get", "getLevels", "collect", "setAutoCollect", "enchant", "get", "getUp", "getDown", "fixBook"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                lq ent;
                ur slot = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                int amount = Integer.MAX_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                if (slot == null) {
                    return new Object[]{0};
                }
                amount = Math.min(amount, slot.a);
                int recharge = 0;
                if (slot.c == up.bD.cj) {
                    recharge = 3 + this.random.nextInt(5) + this.random.nextInt(5);
                } else if (slot.c == up.bC.cj && (ent = lv.a((int)slot.j(), (yc)this.turtle.getWorld())) instanceof md) {
                    recharge = ((md)ent).bd;
                }
                this.addExperience(recharge *= amount);
                if (recharge > 0) {
                    slot.a -= amount;
                    if (slot.a <= 0) {
                        slot = null;
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slot);
                }
                return new Object[]{recharge};
            }
            case 1: {
                return new Object[]{this.experience};
            }
            case 2: {
                return new Object[]{this.experienceLevel};
            }
            case 3: {
                int collected = this.collect();
                this.addExperience(collected);
                return new Object[]{collected};
            }
            case 4: {
                boolean ac;
                boolean bl = ac = !this.autoCollect;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Boolean)) {
                        throw new Exception("bad argument #1 (expected boolean)");
                    }
                    ac = (Boolean)arguments[0];
                }
                this.autoCollect = ac;
                return new Object[]{this.autoCollect};
            }
            case 5: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int levels = (int)Math.floor((Double)arguments[0]);
                if (levels < 1 || levels > 30) {
                    throw new Exception("invalid level count " + levels + " (expected 1-" + 30 + ")");
                }
                ur slot = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (!slot.v()) {
                    return new Object[]{false};
                }
                if (this.experienceLevel < levels) {
                    return new Object[]{false};
                }
                List enchants = xe.b((Random)this.random, (ur)slot, (int)levels);
                if (enchants == null || enchants.isEmpty()) {
                    return new Object[]{false};
                }
                ur enchanted = slot.l();
                if (PeripheralXP.isBook(enchanted)) {
                    enchanted = new ur((up)up.bW);
                    enchanted.d = new bq("tag");
                    by storedEnchantments = new by("StoredEnchantments");
                    bq enchantment = new bq();
                    xj data = (xj)enchants.get(0);
                    enchantment.a("id", (short)data.b.z);
                    enchantment.a("lvl", (short)data.c);
                    storedEnchantments.a((cd)enchantment);
                    enchanted.d.a("StoredEnchantments", (cd)storedEnchantments);
                } else {
                    for (xj data : enchants) {
                        enchanted.a(data.b, data.c);
                    }
                }
                this.addLevels(-levels, true);
                this.turtle.setSlotContents(this.turtle.getSelectedSlot(), enchanted);
                return new Object[]{true};
            }
            case 6: 
            case 7: 
            case 8: {
                final int m = method;
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Integer call() {
                        int toAdd = 0;
                        aoh mop = Util.rayTraceBlock(PeripheralXP.this.turtle, m == 6 ? PeripheralXP.this.turtle.getFacingDir() : (m == 7 ? 1 : 0));
                        for (IXPSource xpsource : IXPSource.handlers) {
                            try {
                                toAdd += xpsource.get(PeripheralXP.this.turtle, mop.b, mop.c, mop.d, mop.e);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        PeripheralXP.this.addExperience(toAdd);
                        return toAdd;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 9: {
                by list;
                ur stack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (stack != null && stack.c == up.bW.cj && stack.d != null && stack.d.b("StoredEnchantments") && (list = stack.d.m("StoredEnchantments")).c() > 1) {
                    for (int i = 0; i < list.c(); ++i) {
                        ur book = new ur((up)up.bW);
                        book.d = new bq("tag");
                        by storedEnchantments = new by("StoredEnchantments");
                        storedEnchantments.a(list.b(i).b());
                        book.d.a("StoredEnchantments", (cd)storedEnchantments);
                        Util.storeOrDrop(this.turtle, book);
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), null);
                }
                throw new Exception("This is a debug function used by me to fix glitched enchanted books. Those were only possible to obtain in a internal ForgeCraft testing version.");
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        if (this.autoCollect && ++this.ticker >= 20) {
            this.ticker = 0;
            this.addExperience(this.collect());
        }
    }

    private int collect() {
        int ret = 0;
        aoj pos = this.turtle.getPosition();
        for (lz orb : this.turtle.getWorld().a(lz.class, aoe.a().a(pos.c - 2.0, pos.d - 2.0, pos.e - 2.0, pos.c + 1.0 + 2.0, pos.d + 1.0 + 2.0, pos.e + 1.0 + 2.0))) {
            ret += orb.c();
            orb.x();
        }
        return ret;
    }

    public void readFromNBT(bq nbttagcompound) {
        this.experience = nbttagcompound.e("experience");
        this.experienceRemainder = nbttagcompound.e("experienceRemainder");
        this.experienceLevel = nbttagcompound.e("experienceLevel");
        this.random.setSeed(nbttagcompound.f("rndSeed"));
    }

    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("experience", this.experience);
        nbttagcompound.a("experienceRemainder", this.experienceRemainder);
        nbttagcompound.a("experienceLevel", this.experienceLevel);
        nbttagcompound.a("rndSeed", this.random.getSeed());
    }

    public void addExperience(int par1) {
        int var2 = Integer.MAX_VALUE - this.experience;
        if (par1 > var2) {
            par1 = var2;
        }
        this.experienceRemainder += par1;
        this.experience += par1;
        while (this.experienceRemainder < 0 || this.experienceRemainder >= this.thisLevelXP()) {
            this.addLevels(this.experienceRemainder < 0 ? -1 : 1, false);
            this.experienceRemainder -= this.thisLevelXP() * (this.experienceRemainder < 0 ? -1 : 1);
        }
    }

    public void addLevels(int par1, boolean updateXP) {
        this.experienceLevel += par1;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
        }
        if (updateXP) {
            this.experience = this.calculateLevelXP(this.experienceLevel) + this.experienceRemainder;
        }
    }

    public int thisLevelXP() {
        return this.levelXP(this.experienceLevel);
    }

    public int levelXP(int level) {
        return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
    }

    public int calculateLevelXP(int level) {
        int levelXP = 0;
        for (int currentLevel = 1; currentLevel <= level; ++currentLevel) {
            levelXP += this.levelXP(currentLevel);
        }
        return levelXP;
    }

    public static int calculateFurnaceXP(ur stack) {
        int stackSize = stack.a;
        float xp = wj.a().getExperience(stack);
        if (xp == 0.0f) {
            return 0;
        }
        if (xp < 1.0f) {
            int result = (int)Math.floor((float)stackSize * xp);
            if (result < (int)Math.ceil((float)stackSize * xp) && (float)Math.random() < (float)stackSize * xp - (float)result) {
                ++result;
            }
            stackSize = result;
        }
        return stackSize;
    }

    private static boolean isBook(ur stack) {
        return stack.c == up.aL.cj;
    }

    @Override
    public float getBlastResistance(lq exploder, yc world, double x, double y, double z) {
        return amq.bH.a(exploder);
    }

    static {
        IXPSource.handlers.add(new FurnaceXPSource());
        IXPSource.handlers.add(new TurtleXPSource());
        IXPSource.handlers.add(new LiquidXPSource());
    }

    public static class LiquidXPSource
    implements IXPSource {
        public static final Map liquids = new HashMap();

        @Override
        public int get(ITurtleAccess turtle, int x, int y, int z, int side) {
            any te = turtle.getWorld().q(x, y, z);
            if (!(te instanceof ITankContainer)) {
                return 0;
            }
            ITankContainer tc = (ITankContainer)te;
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            ArrayList<ILiquidTank> tanks = new ArrayList<ILiquidTank>();
            tanks.addAll(Arrays.asList(tc.getTanks(dir)));
            for (Map.Entry entry : liquids.entrySet()) {
                ILiquidTank tank = tc.getTank(dir, (LiquidStack)entry.getKey());
                if (tank == null) continue;
                tanks.add(tank);
            }
            int ret = 0;
            for (ILiquidTank tank : tanks) {
                for (Map.Entry entry : liquids.entrySet()) {
                    LiquidStack drained;
                    LiquidStack wanted = (LiquidStack)entry.getKey();
                    if (!wanted.isLiquidEqual(tank.getLiquid())) continue;
                    while ((drained = tank.drain(wanted.amount, true)) != null) {
                        ret += (int)Math.floor((float)((Integer)entry.getValue()).intValue() * ((float)drained.amount / (float)wanted.amount));
                    }
                }
            }
            return ret;
        }
    }

    public static class TurtleXPSource
    implements IXPSource {
        @Override
        public int get(ITurtleAccess turtle, int x, int y, int z, int side) {
            int levels;
            any te = turtle.getWorld().q(x, y, z);
            if (!(te instanceof ITurtleAccess)) {
                return 0;
            }
            PeripheralXP xp = (PeripheralXP)Util.getPeripheral(turtle, PeripheralXP.class);
            if (xp != null && (levels = xp.experienceLevel) > 0) {
                xp.addLevels(-levels, true);
                return xp.calculateLevelXP(levels);
            }
            return 0;
        }
    }

    public static class FurnaceXPSource
    implements IXPSource {
        public static final Map classes = new HashMap();

        @Override
        public int get(ITurtleAccess turtle, int x, int y, int z, int side) {
            any te = turtle.getWorld().q(x, y, z);
            if (te == null) {
                return 0;
            }
            int[] slots = null;
            for (Map.Entry entry : classes.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(te.getClass())) continue;
                slots = (int[])entry.getValue();
                break;
            }
            if (slots == null) {
                return 0;
            }
            int ret = 0;
            la inv = (la)te;
            for (int slot : slots) {
                ur stack = inv.a_(slot);
                if (stack == null) continue;
                Util.storeOrDrop(turtle, stack);
                ret += PeripheralXP.calculateFurnaceXP(stack);
            }
            return ret;
        }

        static {
            classes.put(anr.class, new int[]{2});
        }
    }
}

