/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.safe;

import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import miscperipherals.core.MiscPeripherals;

public class Reflector {
    private static Map classCache = new HashMap();
    private static Map fieldCache = new HashMap();
    private static Map methodCache = new HashMap();
    private static Map constructorCache = new HashMap();

    public static Class getClass(String name) {
        try {
            if (classCache.containsKey(name)) {
                return (Class)classCache.get(name);
            }
            Class<?> clazz = Class.forName(name);
            classCache.put(name, clazz);
            return clazz;
        }
        catch (Throwable e) {
            MiscPeripherals.log.warning("Reflector: Unable to get class " + name);
            return null;
        }
    }

    public static void setField(Object obj, String fieldName, Object value) {
        try {
            Class clazz = Reflector.getClass(obj);
            if (clazz == null) {
                return;
            }
            ClassPair cp = new ClassPair(clazz, fieldName);
            Field field = (Field)fieldCache.get(cp);
            if (field == null) {
                field = Reflector.getDeclaredFieldRecursive(clazz, fieldName);
                if (field == null) {
                    throw new NoSuchFieldException();
                }
                field.setAccessible(true);
                fieldCache.put(cp, field);
            }
            field.set(Reflector.getInstance(obj), value);
        }
        catch (Throwable e) {
            MiscPeripherals.log.warning("Reflector: Unable to set field [" + obj + "]." + fieldName);
        }
    }

    public static Object getField(Object obj, String fieldName, Class type) {
        try {
            Class clazz = Reflector.getClass(obj);
            if (clazz == null) {
                return null;
            }
            ClassPair cp = new ClassPair(clazz, fieldName);
            Field field = (Field)fieldCache.get(cp);
            if (field == null) {
                field = Reflector.getDeclaredFieldRecursive(clazz, fieldName);
                if (field == null) {
                    throw new NoSuchFieldException();
                }
                field.setAccessible(true);
                fieldCache.put(cp, field);
            }
            return type.cast(field.get(Reflector.getInstance(obj)));
        }
        catch (Throwable e) {
            MiscPeripherals.log.warning("Reflector: Unable to get field [" + obj + "]." + fieldName);
            return null;
        }
    }

    public static Object invoke(Object obj, String methodName, Class type, Object ... params) {
        try {
            Class clazz = Reflector.getClass(obj);
            if (clazz == null) {
                return null;
            }
            Class[] types = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i] == null ? Object.class : params[i].getClass();
            }
            ClassPair cp = new ClassPair(clazz, methodName, types);
            Method method = (Method)methodCache.get(cp);
            if (method == null) {
                for (Method lmethod : Reflector.getRecursiveMethods(clazz)) {
                    Class<?>[] methodtypes = lmethod.getParameterTypes();
                    if (!methodName.equals(lmethod.getName()) || methodtypes.length != params.length) continue;
                    boolean success = true;
                    for (int i = 0; i < methodtypes.length; ++i) {
                        if (Reflector.checkTypeWithPrimitives(types[i], methodtypes[i])) continue;
                        success = false;
                        break;
                    }
                    if (!success) continue;
                    method = lmethod;
                    break;
                }
                if (method == null) {
                    throw new NoSuchMethodException();
                }
                method.setAccessible(true);
                methodCache.put(cp, method);
            }
            return type.cast(method.invoke(Reflector.getInstance(obj), params));
        }
        catch (Throwable e) {
            MiscPeripherals.log.warning("Reflector: Unable to invoke method [" + obj + "]." + methodName);
            return null;
        }
    }

    public static Object construct(Object target, Class type, Object ... params) {
        try {
            Class[] types = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].getClass();
            }
            Class clazz = Reflector.getClass(target);
            ClassPair cp = new ClassPair(clazz, null, types);
            Constructor<?> ctor = (Constructor<?>)constructorCache.get(cp);
            if (ctor == null) {
                for (Constructor<?> lctor : clazz.getDeclaredConstructors()) {
                    Class<?>[] ctortypes = lctor.getParameterTypes();
                    if (ctortypes.length != params.length) continue;
                    boolean success = true;
                    for (int i = 0; i < ctortypes.length; ++i) {
                        if (Reflector.checkTypeWithPrimitives(types[i], ctortypes[i])) continue;
                        success = false;
                        break;
                    }
                    if (!success) continue;
                    ctor = lctor;
                }
                if (ctor == null) {
                    throw new NoSuchMethodException();
                }
                ctor.setAccessible(true);
                constructorCache.put(cp, ctor);
            }
            return type.cast(ctor.newInstance(params));
        }
        catch (Throwable e) {
            MiscPeripherals.log.warning("Reflector: Unable to construct [" + target + "]");
            return null;
        }
    }

    public static Class getClass(Object instance) {
        return instance == null ? null : (instance.getClass() == String.class ? Reflector.getClass((String)instance) : instance.getClass());
    }

    public static Object getInstance(Object instance) {
        return instance == null ? null : (instance.getClass() == String.class ? null : instance);
    }

    public static boolean checkTypeWithPrimitives(Class a, Class b) {
        if (a == Integer.class && b == Integer.TYPE) {
            return true;
        }
        if (a == Double.class && b == Double.TYPE) {
            return true;
        }
        if (a == Boolean.class && b == Boolean.TYPE) {
            return true;
        }
        if (a == Long.class && b == Long.TYPE) {
            return true;
        }
        if (a == Float.class && b == Float.TYPE) {
            return true;
        }
        if (a == Byte.class && b == Byte.TYPE) {
            return true;
        }
        if (a == Short.class && b == Short.TYPE) {
            return true;
        }
        return a.isAssignableFrom(b) || b.isAssignableFrom(a);
    }

    public static Iterable getRecursiveMethods(Class clazz) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Class spr = clazz;
        do {
            methods.addAll(Arrays.asList(spr.getDeclaredMethods()));
        } while ((spr = spr.getSuperclass()) != null);
        return methods;
    }

    public static Field getDeclaredFieldRecursive(Class clazz, String name) throws NoSuchFieldException {
        Field f = null;
        Class spr = clazz;
        do {
            try {
                f = spr.getDeclaredField(name);
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (f == null) continue;
            return f;
        } while ((spr = spr.getSuperclass()) != null);
        return null;
    }

    private static final class ClassPair {
        public final Class clazz;
        public final Object pair;
        public Class[] array;

        public ClassPair(Class clazz, Object pair) {
            this.clazz = clazz;
            this.pair = pair;
            this.array = null;
        }

        public ClassPair(Class clazz, Object pair, Class[] array) {
            this(clazz, pair);
            this.array = array;
        }

        public boolean equals(Object other) {
            if (other.getClass() != ClassPair.class) {
                return false;
            }
            ClassPair ocp = (ClassPair)other;
            return ocp.clazz.equals(this.clazz) && ocp.pair != null && ocp.pair.equals(this.pair) && ClassPair.arraysEqual(ocp.array, this.array);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.clazz, this.pair, Arrays.hashCode(this.array)});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("clazz", (Object)this.clazz).add("pair", this.pair).add("array", (Object)this.array).toString();
        }

        private static boolean arraysEqual(Object[] a, Object[] b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (Objects.equal((Object)a[i], (Object)b[i])) continue;
                return false;
            }
            return true;
        }
    }
}

