/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import cpw.mods.fml.common.FMLCommonHandler;
import dan200.turtle.api.ITurtleAccess;
import ic2.api.Direction;
import ic2.api.IWrenchable;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.List;
import miscperipherals.asm.ImplementIfLoaded;
import miscperipherals.asm.OwnerInterface;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.inventory.ISlotController;
import miscperipherals.inventory.SlotControlled;
import miscperipherals.tile.TileInventory;

@ImplementIfLoaded(value={"IC2", "ic2.", "BuildCraft|Core", "buildcraft."})
public class TileChargeStation
extends TileInventory
implements ISlotController,
IEnergySink,
IWrenchable,
IPowerReceptor {
    public static final List PLUGINS = new ArrayList(3);
    public double energy = 0.0;
    public int[] sides = this.getSides();
    public final int tier;
    public boolean addedToEnergyNet = false;
    public boolean addedToUE = false;
    public int disabled = 0;
    public Object bcProvider;

    public TileChargeStation() {
        this(1);
    }

    public TileChargeStation(int tier) {
        super(1);
        this.tier = tier;
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.initialize(this);
        }
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void g() {
        super.g();
        if (this.disabled > 0) {
            --this.disabled;
        }
        if (this.disabled < 1) {
            for (ChargeStationPlugin plugin : PLUGINS) {
                plugin.update(this);
            }
            if (this.energy < 1.0) {
                return;
            }
            ArrayList<ITurtleAccess> turtles = new ArrayList<ITurtleAccess>(this.sides.length);
            int turtleCount = 0;
            for (int i = 0; i < this.sides.length; ++i) {
                any te = this.k.q(this.l + r.b[this.sides[i]], this.m + r.c[this.sides[i]], this.n + r.d[this.sides[i]]);
                if (!(te instanceof ITurtleAccess)) continue;
                turtles.add((ITurtleAccess)te);
                ++turtleCount;
            }
            int rate = (int)Math.floor((float)this.sides.length / (float)turtleCount);
            for (ITurtleAccess turtle : turtles) {
                int nrate;
                for (nrate = rate; !turtle.consumeFuel(-nrate) && nrate > 0; --nrate) {
                }
                this.energy -= (double)nrate;
            }
        }
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        try {
            this.energy = tag.h("energy");
        }
        catch (Throwable e) {
            this.energy = tag.e("energy");
        }
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.readFromNBT(this, tag);
        }
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        tag.a("energy", this.energy);
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.writeToNBT(this, tag);
        }
    }

    @Override
    public String b() {
        return "Charge Station";
    }

    @Override
    public int getGuiId() {
        return 0;
    }

    @Override
    public void setFacing(int facing) {
        super.setFacing(facing);
        this.sides = this.getSides();
    }

    public int getMaxCharge() {
        return 50 * (int)Math.pow(10.0, this.tier);
    }

    public int[] getSides() {
        return new int[]{this.getFacing()};
    }

    @Override
    public boolean isItemValid(SlotControlled slot, ur item) {
        return false;
    }

    @Override
    public void onUnloaded() {
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.unload(this);
        }
        super.onUnloaded();
    }

    @Override
    public boolean onBlockActivated(qx player, int side, float hitX, float hitY, float hitZ) {
        for (ChargeStationPlugin plugin : PLUGINS) {
            if (!plugin.onBlockActivated(this, player, side, hitX, hitY, hitZ)) continue;
            return true;
        }
        return super.onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public int demandsEnergy() {
        return (int)Math.floor(((double)this.getMaxCharge() - this.energy) * (double)MiscPeripherals.instance.fuelEU);
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.getMaxSafeInput()) {
            for (ChargeStationPlugin plugin : PLUGINS) {
                plugin.unload(this);
            }
            this.k.d(this.l, this.m, this.n, 0, 0);
            this.k.a(null, (double)((float)this.l + 0.5f), (double)((float)this.m + 0.5f), (double)((float)this.n + 0.5f), 2.0f, false);
            return amount;
        }
        double toAdd = Math.min((double)amount / (double)MiscPeripherals.instance.fuelEU, (double)this.getMaxCharge() - this.energy);
        this.energy += toAdd;
        return (int)Math.floor((double)amount - toAdd * (double)MiscPeripherals.instance.fuelEU);
    }

    @OwnerInterface(value="ic2.api.IWrenchable")
    public boolean wrenchCanSetFacing(qx entityPlayer, int side) {
        for (int lside : this.getSides()) {
            if (lside != side) continue;
            return false;
        }
        return true;
    }

    @OwnerInterface(value="ic2.api.IWrenchable")
    public void setFacing(short facing) {
        this.setFacing((int)facing);
    }

    @OwnerInterface(value="ic2.api.IWrenchable")
    public boolean wrenchCanRemove(qx entityPlayer) {
        return true;
    }

    @OwnerInterface(value="ic2.api.IWrenchable")
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @OwnerInterface(value="ic2.api.IWrenchable")
    public ur getWrenchDrop(qx entityPlayer) {
        return new ur(this.k.a(this.l, this.m, this.n), 1, this.k.h(this.l, this.m, this.n));
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public int getMaxSafeInput() {
        return this.tier == 1 ? 32 : (this.tier == 2 ? 128 : (this.tier == 3 ? 512 : (this.tier == 4 ? 2048 : Integer.MAX_VALUE)));
    }

    @OwnerInterface(value="buildcraft.api.power.IPowerReceptor")
    public void setPowerProvider(IPowerProvider provider) {
        this.bcProvider = provider;
    }

    @OwnerInterface(value="buildcraft.api.power.IPowerReceptor")
    public IPowerProvider getPowerProvider() {
        return (IPowerProvider)this.bcProvider;
    }

    @OwnerInterface(value="buildcraft.api.power.IPowerReceptor")
    public void doWork() {
        float sink = ((IPowerProvider)this.bcProvider).useEnergy(0.0f, (float)(((double)this.getMaxCharge() - this.energy) * (double)MiscPeripherals.instance.fuelMJ), true);
        this.energy += (double)sink / (double)MiscPeripherals.instance.fuelMJ;
    }

    @OwnerInterface(value="buildcraft.api.power.IPowerReceptor")
    public int powerRequest() {
        return MiscPeripherals.instance.fuelMJ * this.getSides().length;
    }

    public static interface ChargeStationPlugin {
        public boolean isBattery(TileChargeStation var1, ur var2);

        public void update(TileChargeStation var1);

        public void unload(TileChargeStation var1);

        public boolean onBlockActivated(TileChargeStation var1, qx var2, int var3, float var4, float var5, float var6);

        public void readFromNBT(TileChargeStation var1, bq var2);

        public void writeToNBT(TileChargeStation var1, bq var2);

        public void initialize(TileChargeStation var1);
    }
}

