/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.Tile;
import miscperipherals.util.Util;
import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.signals.AbstractPair;
import railcraft.common.api.signals.IControllerTile;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SignalReceiver;
import railcraft.common.api.signals.SignalTools;

public class TileSignalController
extends Tile
implements IControllerTile,
IReceiverTile,
IPeripheral {
    private static final String NAME = "Electronic Signal Controller";
    private static final SignalAspect[] ASPECTS = SignalAspect.values();
    private MultiSignalReceiver receiver = new MultiSignalReceiver("Electronic Signal Controller", this, 256);
    private MultiSignalController controller = new MultiSignalController("Electronic Signal Controller", this, 256);
    private final Map computers = new WeakHashMap();

    public yc getWorld() {
        return this.k;
    }

    public SignalReceiver getReceiver() {
        return this.receiver;
    }

    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        for (IComputerAccess computer : this.computers.keySet()) {
            WorldCoordinate coords = con.getCoords();
            computer.queueEvent("signal", new Object[]{coords.dimension, coords.x, coords.y, coords.z, this.aspectToString(aspect)});
        }
    }

    public SignalController getController() {
        return this.controller;
    }

    @Override
    public void a(bq compound) {
        super.a(compound);
        this.receiver.readFromNBT(compound);
        this.controller.readFromNBT(compound);
    }

    @Override
    public void b(bq compound) {
        super.b(compound);
        this.receiver.writeToNBT(compound);
        this.controller.writeToNBT(compound);
    }

    public String getType() {
        return "signalController";
    }

    public String[] getMethodNames() {
        return new String[]{"get", "set"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, final Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length > 0 && arguments.length < 3) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
                    throw new Exception("bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof Double)) {
                    throw new Exception("bad argument #4 (expected number)");
                }
                Future callback = TickHandler.addTickCallback(this.k, new Callable(){

                    public SignalAspect call() {
                        if (arguments.length > 1) {
                            int x = (int)Math.floor((Double)arguments[0]);
                            int y = (int)Math.floor((Double)arguments[1]);
                            int z = (int)Math.floor((Double)arguments[2]);
                            int dim = arguments.length > 3 ? (int)Math.floor((Double)arguments[3]) : TileSignalController.this.k.u.h;
                            return TileSignalController.this.receiver.getAspectFor(new WorldCoordinate(dim, x, y, z));
                        }
                        return TileSignalController.this.receiver.getDefaultAspect();
                    }
                });
                SignalAspect aspect = (SignalAspect)callback.get();
                return new Object[]{aspect == null ? null : this.aspectToString(aspect)};
            }
            case 1: {
                if (arguments.length < 1 || arguments.length > 1 && arguments.length < 4) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
                    throw new Exception("bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof Double)) {
                    throw new Exception("bad argument #4 (expected number)");
                }
                if (arguments.length > 4 && !(arguments[4] instanceof Double)) {
                    throw new Exception("bad argument #5 (expected number)");
                }
                Future callback = TickHandler.addTickCallback(this.k, new Callable(){

                    public String call() {
                        String aspectName = (String)arguments[0];
                        SignalAspect aspect = TileSignalController.this.getAspect(aspectName);
                        if (arguments.length > 1) {
                            int dim;
                            int x = (int)Math.floor((Double)arguments[1]);
                            int y = (int)Math.floor((Double)arguments[2]);
                            int z = (int)Math.floor((Double)arguments[3]);
                            int n = dim = arguments.length > 4 ? (int)Math.floor((Double)arguments[4]) : TileSignalController.this.k.u.h;
                            if (!TileSignalController.this.controller.setAspectFor(new WorldCoordinate(dim, x, y, z), aspect)) {
                                return null;
                            }
                        } else {
                            TileSignalController.this.controller.setDefaultAspect(aspect);
                        }
                        return TileSignalController.this.aspectToString(aspect);
                    }
                });
                return new Object[]{callback.get()};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        this.computers.put(computer, true);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean canUpdate() {
        return true;
    }

    public void g() {
        super.g();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isServer()) {
            this.receiver.tickServer();
            this.controller.tickServer();
        } else if (side.isClient()) {
            this.receiver.tickClient();
            this.controller.tickClient();
        }
    }

    private SignalAspect getAspect(String name) {
        for (SignalAspect aspect : ASPECTS) {
            if (!name.equalsIgnoreCase(this.aspectToString(aspect))) continue;
            return aspect;
        }
        return SignalAspect.BLINK_RED;
    }

    private String aspectToString(SignalAspect aspect) {
        return Util.camelCase(aspect.name().replaceAll("_", " "));
    }

    private WorldCoordinate getWorldCoordinate() {
        return new WorldCoordinate(this.k.u.h, this.l, this.m, this.n);
    }

    private class MultiSignalReceiver
    extends SignalReceiver {
        private Map aspects;

        public MultiSignalReceiver(String name, any tile, int maxPairings) {
            super(name, tile, maxPairings);
            this.aspects = new HashMap();
        }

        public void loadNBT(bq compound) {
            super.loadNBT(compound);
            by aspects = compound.m("aspects");
            for (int i = 0; i < aspects.c(); ++i) {
                bq aspect = (bq)aspects.b(i);
                int[] coords = aspect.k("coords");
                this.aspects.put(new WorldCoordinate(coords[0], coords[1], coords[2], coords[3]), SignalAspect.values()[aspect.c("aspect")]);
            }
        }

        public void saveNBT(bq compound) {
            super.saveNBT(compound);
            by aspects = new by();
            for (Map.Entry entry : this.aspects.entrySet()) {
                bq aspect = new bq();
                WorldCoordinate coords = (WorldCoordinate)entry.getKey();
                aspect.a("coords", new int[]{coords.dimension, coords.x, coords.y, coords.z});
                aspect.a("aspect", (byte)((SignalAspect)entry.getValue()).ordinal());
                aspects.a((cd)aspect);
            }
            compound.a("aspects", (cd)aspects);
        }

        public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
            super.onControllerAspectChange(con, aspect);
            this.aspects.put(con.getCoords(), aspect);
        }

        public SignalAspect getAspectFor(WorldCoordinate coord) {
            SignalController controller = this.getControllerAt(coord);
            if (controller == null) {
                return SignalAspect.BLINK_RED;
            }
            return controller.getAspectFor(this.getCoords());
        }

        public SignalAspect getDefaultAspect() {
            SignalAspect ret = null;
            for (WorldCoordinate coord : this.getPairs()) {
                ret = SignalAspect.mostRestrictive(ret, (SignalAspect)this.getAspectFor(coord));
            }
            return ret;
        }
    }

    private class MultiSignalController
    extends SignalController {
        private Map aspects;

        public MultiSignalController(String name, any tile, int maxPairings) {
            super(name, tile, maxPairings);
            this.aspects = new HashMap();
        }

        public void loadNBT(bq compound) {
            by aspects = compound.m("aspects");
            for (int i = 0; i < aspects.c(); ++i) {
                bq aspect = (bq)aspects.b(i);
                int[] coords = aspect.k("coords");
                this.aspects.put(new WorldCoordinate(coords[0], coords[1], coords[2], coords[3]), SignalAspect.values()[aspect.c("aspect")]);
            }
        }

        public void saveNBT(bq compound) {
            by aspects = new by();
            for (Map.Entry entry : this.aspects.entrySet()) {
                bq aspect = new bq();
                WorldCoordinate coords = (WorldCoordinate)entry.getKey();
                aspect.a("coords", new int[]{coords.dimension, coords.x, coords.y, coords.z});
                aspect.a("aspect", (byte)((SignalAspect)entry.getValue()).ordinal());
                aspects.a((cd)aspect);
            }
            compound.a("aspects", (cd)aspects);
        }

        public SignalAspect getAspectFor(WorldCoordinate receiver) {
            return (SignalAspect)this.aspects.get(receiver);
        }

        public void clearPairing(WorldCoordinate other) {
            super.clearPairing(other);
            this.aspects.remove(other);
            for (IComputerAccess computer : TileSignalController.this.computers.keySet()) {
                computer.queueEvent("signal_receiver_remove", new Object[]{other.dimension, other.x, other.y, other.z});
            }
        }

        public void addPairing(WorldCoordinate other) {
            this.pairings.add(other);
            while (this.pairings.size() > this.getMaxPairings()) {
                WorldCoordinate coord = (WorldCoordinate)this.pairings.remove();
                for (IComputerAccess computer : TileSignalController.this.computers.keySet()) {
                    computer.queueEvent("signal_receiver_remove", new Object[]{coord.dimension, coord.x, coord.y, coord.z});
                }
            }
            SignalTools.packetBuilder.sendPairPacketUpdate((AbstractPair)this);
            this.aspects.put(other, SignalAspect.BLINK_RED);
            for (IComputerAccess computer : TileSignalController.this.computers.keySet()) {
                computer.queueEvent("signal_receiver_add", new Object[]{other.dimension, other.x, other.y, other.z});
            }
        }

        public boolean setAspectFor(WorldCoordinate receiver, SignalAspect aspect) {
            if (!this.pairings.contains(receiver)) {
                return false;
            }
            if (this.sendAspectTo(receiver, aspect)) {
                this.aspects.put(receiver, aspect);
                return true;
            }
            return false;
        }

        public void setDefaultAspect(SignalAspect aspect) {
            for (WorldCoordinate coord : this.getPairs()) {
                this.setAspectFor(coord, aspect);
            }
        }
    }
}

