/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.Tile;
import miscperipherals.util.Util;
import net.minecraft.server.MinecraftServer;

public class TileTeleporter
extends Tile
implements IPeripheral {
    public final Stack links = new Stack();
    public final int maxLinks;
    private String error;

    public TileTeleporter() {
        this.maxLinks = 1;
    }

    public TileTeleporter(int maxLinks) {
        this.maxLinks = maxLinks;
    }

    public String getType() {
        return "teleporter";
    }

    public String[] getMethodNames() {
        return new String[]{"teleport", "tp", "getError"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 1: {
                int index;
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int n = index = arguments.length > 0 ? (int)Math.floor((Double)arguments[0]) - 1 : 0;
                if (index < 0 || index >= this.maxLinks) {
                    throw new Exception("bad link " + (index + 1) + " (expected 1-" + this.maxLinks + ")");
                }
                Future callback = TickHandler.addTickCallback(this.k, new Callable(){

                    public Boolean call() {
                        int zdif;
                        int ydif;
                        int linkToZ;
                        int linkToY;
                        if (index >= TileTeleporter.this.links.size()) {
                            TileTeleporter.this.error = "No such link";
                            return false;
                        }
                        LinkData link = (LinkData)TileTeleporter.this.links.get(index);
                        if (link == null) {
                            TileTeleporter.this.error = "No such link";
                            return false;
                        }
                        any te = TileTeleporter.this.k.q(TileTeleporter.this.l + r.b[TileTeleporter.this.getFacing()], TileTeleporter.this.m + r.c[TileTeleporter.this.getFacing()], TileTeleporter.this.n + r.d[TileTeleporter.this.getFacing()]);
                        if (!(te instanceof ITurtleAccess)) {
                            TileTeleporter.this.error = "No turtle in front";
                            return false;
                        }
                        in destWorld = MinecraftServer.D().a(link.linkDim);
                        if (destWorld == null) {
                            TileTeleporter.this.error = "Destination world missing";
                            return false;
                        }
                        any dest = destWorld.q(link.link.a, link.link.b, link.link.c);
                        if (!(dest instanceof TileTeleporter)) {
                            TileTeleporter.this.error = "Destination is not a teleporter";
                            return false;
                        }
                        TileTeleporter teleporter = (TileTeleporter)dest;
                        int linkToX = link.link.a + r.b[teleporter.getFacing()];
                        if (!Util.isPassthroughBlock((yc)destWorld, linkToX, linkToY = link.link.b + r.c[teleporter.getFacing()], linkToZ = link.link.c + r.d[teleporter.getFacing()])) {
                            TileTeleporter.this.error = "Destination obstructed";
                            return false;
                        }
                        ITurtleAccess turtle = (ITurtleAccess)te;
                        int xdif = Math.abs(TileTeleporter.this.l - link.link.a);
                        if (!turtle.consumeFuel(Math.abs((int)Math.ceil((double)((xdif + (ydif = Math.abs(TileTeleporter.this.m - link.link.b)) + (zdif = Math.abs(TileTeleporter.this.n - link.link.c))) * (Math.abs(TileTeleporter.this.k.u.h - destWorld.u.h) + 1)) * MiscPeripherals.instance.teleporterPenalty)))) {
                            TileTeleporter.this.error = "Not enough fuel";
                            return false;
                        }
                        boolean result = Util.teleportTurtleTo(turtle, (yc)destWorld, linkToX, linkToY, linkToZ);
                        if (result) {
                            int flag = TileTeleporter.this.k.u.h != destWorld.u.h ? 1 : 0;
                            ByteArrayDataOutput os = ByteStreams.newDataOutput();
                            os.writeInt(TileTeleporter.this.l);
                            os.writeInt(TileTeleporter.this.m);
                            os.writeInt(TileTeleporter.this.n);
                            os.writeByte(flag);
                            PacketDispatcher.sendPacketToAllAround((double)((double)TileTeleporter.this.l + 0.5), (double)((double)TileTeleporter.this.m + 0.5), (double)((double)TileTeleporter.this.n + 0.5), (double)64.0, (int)TileTeleporter.this.k.u.h, (ef)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)4, (byte[])os.toByteArray()));
                            TileTeleporter.this.onTeleport((byte)flag);
                            os = ByteStreams.newDataOutput();
                            os.writeInt(teleporter.l);
                            os.writeInt(teleporter.m);
                            os.writeInt(teleporter.n);
                            os.writeByte(flag);
                            PacketDispatcher.sendPacketToAllAround((double)((double)teleporter.l + 0.5), (double)((double)teleporter.m + 0.5), (double)((double)teleporter.n + 0.5), (double)64.0, (int)destWorld.u.h, (ef)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)4, (byte[])os.toByteArray()));
                            teleporter.onTeleport((byte)flag);
                        }
                        return result;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 2: {
                return new Object[]{this.error};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    @Override
    public void a(bq compound) {
        super.a(compound);
        by links = compound.m("links");
        for (int i = 0; i < links.c(); ++i) {
            bq link = (bq)links.b(i);
            if (!link.b("linkX") || !link.b("linkY") || !link.b("linkZ") || !link.b("linkDim")) continue;
            this.links.add(new LinkData(compound.e("linkDim"), new s(compound.e("linkX"), compound.e("linkY"), compound.e("linkZ"))));
        }
    }

    @Override
    public void b(bq compound) {
        super.b(compound);
        by list = new by();
        for (int i = 0; i < this.links.size(); ++i) {
            LinkData link = (LinkData)this.links.get(i);
            if (link == null) continue;
            bq lcompound = new bq();
            lcompound.a("linkX", link.link.a);
            lcompound.a("linkY", link.link.b);
            lcompound.a("linkZ", link.link.c);
            lcompound.a("linkDim", link.linkDim);
            list.a((cd)lcompound);
        }
        compound.a("links", (cd)list);
    }

    @Override
    public boolean onBlockActivated(qx player, int side, float hitX, float hitY, float hitZ) {
        ur held = player.bS();
        if (held != null && held.c == up.bb.cj) {
            if (held.d != null && held.d.b("miscperipheralsLinkX") && held.d.b("miscperipheralsLinkY") && held.d.b("miscperipheralsLinkZ") && held.d.b("miscperipheralsLinkDim")) {
                s link = new s(held.d.e("miscperipheralsLinkX"), held.d.e("miscperipheralsLinkY"), held.d.e("miscperipheralsLinkZ"));
                int linkDim = held.d.e("miscperipheralsLinkDim");
                in srcWorld = MinecraftServer.D().a(linkDim);
                if (srcWorld == null) {
                    player.a("Link failed: World is missing");
                } else {
                    any te = srcWorld.q(link.a, link.b, link.c);
                    if (!(te instanceof TileTeleporter)) {
                        player.a("Link failed: Teleporter no longer exists");
                    } else {
                        TileTeleporter src = (TileTeleporter)te;
                        if (link.a == this.l && link.b == this.m && link.c == this.n) {
                            player.a("Link canceled");
                        } else {
                            boolean unlinked = false;
                            for (int i = 0; i < src.links.size(); ++i) {
                                LinkData rlink = (LinkData)src.links.get(i);
                                System.out.println("comparing: " + rlink.link.a + " " + this.l + " " + rlink.link.b + " " + this.m + " " + rlink.link.c + " " + this.n);
                                if (rlink.link.a != this.l || rlink.link.b != this.m || rlink.link.c != this.n || rlink.linkDim != this.k.u.h) continue;
                                player.a("Unlinked teleporter at " + rlink.linkDim + ":(" + rlink.link.a + "," + rlink.link.b + "," + rlink.link.c + ") (link " + (i + 1) + ") from this teleporter");
                                src.links.remove(i);
                                unlinked = true;
                                break;
                            }
                            if (!unlinked) {
                                src.addLink(this.k.u.h, new s(this.l, this.m, this.n));
                                player.a("Linked teleporter at " + linkDim + ":(" + link.a + "," + link.b + "," + link.c + ") (link " + src.links.size() + ") to this teleporter");
                            }
                        }
                    }
                }
                held.d.o("miscperipheralsLinkX");
                held.d.o("miscperipheralsLinkY");
                held.d.o("miscperipheralsLinkZ");
                held.d.o("miscperipheralsLinkDim");
                if (held.d.b("display")) {
                    bq display = held.d.l("display");
                    display.o("Lore");
                    if (display.c().isEmpty()) {
                        held.d.o("display");
                    } else {
                        held.d.a("display", (cd)display);
                    }
                }
                return true;
            }
            if (held.d == null) {
                held.d = new bq();
            }
            held.d.a("miscperipheralsLinkX", this.l);
            held.d.a("miscperipheralsLinkY", this.m);
            held.d.a("miscperipheralsLinkZ", this.n);
            held.d.a("miscperipheralsLinkDim", this.k.u.h);
            bq display = new bq();
            by lore = new by();
            lore.a((cd)new cc("", "Turtle Teleporter Link"));
            lore.a((cd)new cc("", this.k.u.h + ":(" + this.l + "," + this.m + "," + this.n + ")"));
            display.a("Lore", (cd)lore);
            held.d.a("display", (cd)display);
            player.a("Link started");
            return true;
        }
        return false;
    }

    public void onTeleport(byte flag) {
        if (!MiscPeripherals.proxy.isServer()) {
            short facing = this.getFacing();
            for (int j = 0; j < 32; ++j) {
                this.k.a("portal", (double)this.l + 0.5 + 1.0 * (double)r.b[facing], (double)this.m + 1.0 * (double)r.c[facing] + this.k.t.nextDouble() * 2.0, (double)this.n + 0.5 + 1.0 * (double)r.d[this.getFacing()], this.k.t.nextGaussian(), 0.0, this.k.t.nextGaussian());
            }
        } else {
            String sound = "mob.endermen.portal";
            if (Loader.isModLoaded((String)"Mystcraft")) {
                sound = flag == 1 ? "myst.sound.link-portal" : "myst.sound.link-intra";
            }
            this.k.a((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5, sound, 1.0f, 1.0f);
        }
    }

    public int addLink(int linkDim, s link) {
        this.links.add(new LinkData(linkDim, link));
        while (this.links.size() > this.maxLinks) {
            this.links.pop();
        }
        return this.links.size();
    }

    protected static class LinkData {
        public final int linkDim;
        public final s link;

        public LinkData(int linkDim, s link) {
            this.linkDim = linkDim;
            this.link = link;
        }
    }
}

