/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import miscperipherals.peripheral.PeripheralShield;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.FakeWorld;

public class UpgradeShield
implements ITurtleUpgrade {
    private final int id;
    private final amq block;
    private final int meta;

    public UpgradeShield(int id, amq block, int meta) {
        this.id = id;
        this.block = block;
        this.meta = meta;
    }

    public int getUpgradeID() {
        return this.id;
    }

    public String getAdjective() {
        return "Shielded";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ur getCraftingItem() {
        return new ur(this.block, 1, this.meta);
    }

    public boolean isSecret() {
        return false;
    }

    public String getIconTexture(ITurtleAccess turtle, TurtleSide side) {
        try {
            return this.block.getTextureFile();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "/terrain.png";
        }
    }

    public int getIconIndex(ITurtleAccess turtle, TurtleSide side) {
        try {
            return this.block.a(2, this.meta);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        FakePlayer player = new FakePlayer(FakeWorld.instance);
        FakeWorld.instance.d(0, 64, 0, this.block.cm, this.meta);
        float resistance = this.block.getExplosionResistance((lq)player, (yc)FakeWorld.instance, 0, 0, 0, 0.5, 0.5, 0.5);
        FakeWorld.instance.d(0, 64, 0, 0, 0);
        return new PeripheralShield(turtle, resistance);
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return false;
    }
}

