/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.bdew.neiaddons.api.NEIAddon;
import net.minecraftforge.common.Configuration;

@Mod(modid="NEIAddons", name="NEI Addons", version="1.6.1.r8", dependencies="after:NotEnoughItems")
public class NEIAddons {
    public static Logger log;
    public static final String modid = "NEIAddons";
    public static List addons;
    public static Configuration config;

    public static void register(NEIAddon addon) {
        addons.add(addon);
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.addCustomCategoryComment("Addons", "Controls loading of different addons, set to false to disable");
        addons = new ArrayList();
        if (event.getSide() == Side.CLIENT && !Loader.isModLoaded((String)"NotEnoughItems")) {
            log.severe("NEI doesn't seem to be installed... NEI Addons require it to do anything useful client-side");
        }
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        log.info("Loading NEI Addons");
        for (NEIAddon addon : addons) {
            if (config.get("Addons", addon.getName(), true).getBoolean(false)) {
                log.info("Loading " + addon.getName() + " Addon...");
                try {
                    addon.init(event.getSide());
                    if (!addon.isActive().booleanValue()) continue;
                    log.info(addon.getName() + " Addon successfully loadded");
                }
                catch (Exception e) {
                    log.severe("Loading " + addon.getName() + " Addon - Failed:");
                    e.printStackTrace();
                }
                continue;
            }
            log.info(addon.getName() + " Addon disabled - skipping");
        }
        config.save();
        if (addons.size() > 0) {
            String addonslist = "Loaded Addons:";
            for (NEIAddon addon : addons) {
                addonslist = addonslist + "\n- " + addon.getName() + ": " + (addon.isActive() != false ? "Active" : "Inactive");
            }
            Loader.instance().activeModContainer().getMetadata().description = addonslist;
        } else {
            Loader.instance().activeModContainer().getMetadata().description = "No Addons loaded :(";
        }
    }
}

