/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.crafting;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.bdew.neiaddons.BaseAddon;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.crafting.AddonCraftingTablesClient;

@Mod(modid="NEIAddons|CraftingTables", name="NEI Addons: Crafting Tables", version="1.6.1.r8", dependencies="after:NEIAddons")
public class AddonCraftingTables
extends BaseAddon {
    public static Collection craftingTables;

    @Override
    public String getName() {
        return "Crafting Tables";
    }

    @Override
    public boolean checkSide(Side side) {
        return side.isClient();
    }

    @Override
    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent ev) {
        this.doPreInit(ev);
    }

    public void tryLoadTableClass(String modId, String className, String humanName) {
        try {
            if (this.verifyModVersion(modId).booleanValue()) {
                craftingTables.add(Utils.getAndCheckClass(className, avf.class));
                this.logInfo("Registered %s", humanName);
            } else {
                this.logInfo("Not registering %s", humanName);
            }
        }
        catch (Throwable e) {
            this.logWarning("Registering %s failed: %s", humanName, e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void init(Side side) throws Exception {
        craftingTables = new ArrayList();
        this.tryLoadTableClass("EE3", "com.pahimar.ee3.client.gui.inventory.GuiPortableCrafting", "EE3 Minium Stone");
        this.tryLoadTableClass("BuildCraft|Factory", "buildcraft.factory.gui.GuiAutoCrafting", "BC Autorcrafting Table");
        this.tryLoadTableClass("PowersuitAddons", "andrew.powersuits.client.PortableCraftingGui", "MPSA In-Place Assembler");
        if (craftingTables.size() > 0) {
            this.logInfo("%d crafting tables registered", craftingTables.size());
            this.active = true;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void loadClient() {
        AddonCraftingTablesClient.load();
    }
}

