/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry.bees;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.bees.BeeBreedingHandler;
import net.bdew.neiaddons.forestry.bees.BeeProduceHandler;
import net.bdew.neiaddons.forestry.fake.FakeBeeRoot;

public class BeeHelper {
    private static BeeBreedingHandler breedingRecipeHandler;
    private static BeeProduceHandler productsRecipeHandler;
    public static Collection allSpecies;
    public static Map productsCache;
    public static FakeBeeRoot root;

    private static void addProductToCache(int id, IAlleleBeeSpecies species) {
        if (!productsCache.containsKey(id)) {
            productsCache.put(id, new ArrayList());
        }
        ((Collection)productsCache.get(id)).add(species);
    }

    public static void setup() {
        root = new FakeBeeRoot();
        allSpecies = GeneticsUtils.getAllBeeSpecies(AddonForestry.loadBlacklisted);
        breedingRecipeHandler = new BeeBreedingHandler();
        API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
        API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
        AddonForestry.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        productsRecipeHandler = new BeeProduceHandler();
        API.registerRecipeHandler((ICraftingHandler)productsRecipeHandler);
        API.registerUsageHandler((IUsageHandler)productsRecipeHandler);
        AddonForestry.instance.registerWithNEIPlugins(productsRecipeHandler.getRecipeName(), productsRecipeHandler.getRecipeIdent());
        up comb = ItemInterface.getItem((String)"beeComb").b();
        HashSet<Integer> seencombs = new HashSet<Integer>();
        productsCache = new HashMap();
        for (IAlleleBeeSpecies species : allSpecies) {
            if (AddonForestry.addBees) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.QUEEN.ordinal()));
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.DRONE.ordinal()));
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.PRINCESS.ordinal()));
            }
            for (ur prod : GeneticsUtils.getProduceFromSpecies((IAlleleSpecies)species).keySet()) {
                BeeHelper.addProductToCache(prod.c, species);
                if (!AddonForestry.addCombs || prod.c != comb.cj) continue;
                seencombs.add(prod.j());
            }
            for (ur prod : GeneticsUtils.getSpecialtyFromSpecies((IAlleleSpecies)species).keySet()) {
                BeeHelper.addProductToCache(prod.c, species);
                if (!AddonForestry.addCombs || prod.c != comb.cj) continue;
                seencombs.add(prod.j());
            }
        }
        if (AddonForestry.addCombs) {
            ArrayList combs = new ArrayList();
            comb.a(comb.cj, null, combs);
            for (ur item : combs) {
                seencombs.add(item.j());
            }
            API.setItemDamageVariants((int)comb.cj, seencombs);
        }
    }
}

