/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry.trees;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.fake.FakeTreeRoot;
import net.bdew.neiaddons.forestry.trees.TreeBreedingHandler;
import net.bdew.neiaddons.forestry.trees.TreeProduceHandler;

public class TreeHelper {
    private static TreeBreedingHandler breedingRecipeHandler;
    private static TreeProduceHandler produceRecipeHandler;
    public static Collection allSpecies;
    public static Map productsCache;
    public static FakeTreeRoot root;

    private static void addProductToCache(int id, IAlleleTreeSpecies species) {
        if (!productsCache.containsKey(id)) {
            productsCache.put(id, new ArrayList());
        }
        ((Collection)productsCache.get(id)).add(species);
    }

    public static void setup() {
        root = new FakeTreeRoot();
        allSpecies = GeneticsUtils.getAllTreeSpecies(AddonForestry.loadBlacklisted);
        breedingRecipeHandler = new TreeBreedingHandler();
        API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
        API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
        AddonForestry.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        produceRecipeHandler = new TreeProduceHandler();
        API.registerRecipeHandler((ICraftingHandler)produceRecipeHandler);
        API.registerUsageHandler((IUsageHandler)produceRecipeHandler);
        AddonForestry.instance.registerWithNEIPlugins(produceRecipeHandler.getRecipeName(), produceRecipeHandler.getRecipeIdent());
        productsCache = new HashMap();
        for (IAlleleTreeSpecies species : allSpecies) {
            if (AddonForestry.addSaplings) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumGermlingType.SAPLING.ordinal()));
            }
            for (ur prod : GeneticsUtils.getProduceFromSpecies((IAlleleSpecies)species).keySet()) {
                TreeHelper.addProductToCache(prod.c, species);
            }
            for (ur prod : GeneticsUtils.getSpecialtyFromSpecies((IAlleleSpecies)species).keySet()) {
                TreeHelper.addProductToCache(prod.c, species);
            }
        }
    }
}

