/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.ClientUtils;
import codechicken.core.colour.Colour;
import codechicken.core.colour.ColourARGB;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.core.RedstoneEther;
import cpw.mods.fml.common.FMLCommonHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class TriangTexManager {
    private static int[] texRing = new int[256];
    private static int[] texGrad = new int[256];
    private static byte[] imageData = new byte[1024];
    private static final int pr = -65536;
    private static final int pb = -16776961;
    private static final int pg = -8355712;
    private static final int pd = -12566464;
    private static HashMap texfreqmap;
    private static ArrayList requiredtextures;
    private static final int[] pointercolours;
    private static final int[] pointersidecolours;

    static {
        pointercolours = new int[]{-16776961, -65536, -65536, -65536, -65536, -65536, -65536, -65536, -16776961, -65536, -65536, -65536, -16776961, -16776961};
        pointersidecolours = new int[]{-8355712, -8355712, -8355712, -8355712, -8355712, -8355712, -12566464, -8355712, -12566464, -12566464, -12566464, -12566464, -8355712, -8355712};
        TriangTexManager.init();
    }

    private static void init() {
        texfreqmap = new HashMap(256);
        requiredtextures = new ArrayList(256);
        try {
            BufferedImage bufferedimage = ImageIO.read(Minecraft.class.getResource("/codechicken/wirelessredstone/addons/addons1.png"));
            bufferedimage.getRGB(64, 0, 16, 16, texGrad, 0, 16);
            bufferedimage.getRGB(80, 0, 16, 16, texRing, 0, 16);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone", true);
        }
    }

    public static void reset() {
        texfreqmap = new HashMap(256);
        requiredtextures = new ArrayList(256);
    }

    public static void processDefaultTexture() {
        GL11.glBindTexture((int)3553, (int)Minecraft.x().o.b("/codechicken/wirelessredstone/addons/triang.png"));
        TriangTexManager.processTexture(-1, 0);
    }

    public static int getIconIndexFromDamage(int damage) {
        Integer iconindex;
        if (damage == 0) {
            return 0;
        }
        if (!requiredtextures.contains(damage)) {
            requiredtextures.add(damage);
            RedstoneEtherAddons.client().setTriangRequired((qx)ClientUtils.mc().g, damage, true);
        }
        if ((iconindex = (Integer)texfreqmap.get(damage)) == null) {
            texfreqmap.put(damage, -1);
            return 0;
        }
        if (iconindex == -1) {
            return 0;
        }
        return iconindex;
    }

    private static void processTexture(int freq, int iconindex) {
        int colour = freq == -1 ? -1 : RedstoneEther.get((boolean)true).getFreqColour(freq);
        TriangTexManager.mergeTexturesWithColour(new ColourARGB(colour));
        if (freq != -1) {
            TriangTexManager.writePointer(freq);
        }
        ByteBuffer imagebuffer = arx.c((int)1024);
        imagebuffer.put(imageData);
        imagebuffer.position(0).limit(1024);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)(16 * (iconindex % 16)), (int)(16 * (iconindex / 16)), (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)imagebuffer);
    }

    private static void mergeTexturesWithColour(ColourARGB texcolour) {
        int i = 0;
        while (i < 256) {
            Object colour = (texGrad[i] & 0xFF000000) == 0 ? new ColourARGB(texRing[i]) : new ColourARGB(texGrad[i]).multiply((Colour)texcolour);
            TriangTexManager.imageData[i * 4 + 0] = colour.r;
            TriangTexManager.imageData[i * 4 + 1] = colour.g;
            TriangTexManager.imageData[i * 4 + 2] = colour.b;
            TriangTexManager.imageData[i * 4 + 3] = colour.a;
            ++i;
        }
    }

    private static void writePointer(int freq) {
        byte a;
        byte b;
        byte g;
        byte r;
        int colour;
        int pixelindex;
        int row;
        int col;
        int scolour;
        int pcolour;
        if (RedstoneEther.get((boolean)true).isPlayerJammed((qx)ClientUtils.mc().g) || !RedstoneEtherAddons.client().isTriangOn(freq)) {
            return;
        }
        int id = RedstoneEther.get((boolean)true).getFreqColourId(freq);
        if (id == -1) {
            pcolour = -65536;
            scolour = -8355712;
        } else {
            pcolour = pointercolours[id];
            scolour = pointersidecolours[id];
        }
        float angle = RedstoneEtherAddons.client().getTriangAngle(freq);
        float[] dxdy = new float[]{(float)Math.cos(angle), (float)Math.sin(angle)};
        int i = -4;
        while (i <= 4) {
            col = (int)(8.5 + (double)dxdy[1] * (double)i * 0.3);
            row = (int)(7.5 - (double)dxdy[0] * (double)i * 0.3 * 0.5);
            pixelindex = row * 16 + col;
            colour = scolour;
            r = (byte)((colour & 0xFF0000) >> 16);
            g = (byte)((colour & 0xFF00) >> 8);
            b = (byte)(colour & 0xFF);
            a = (byte)((colour & 0xFF000000) >> 24);
            TriangTexManager.imageData[pixelindex * 4 + 0] = r;
            TriangTexManager.imageData[pixelindex * 4 + 1] = g;
            TriangTexManager.imageData[pixelindex * 4 + 2] = b;
            TriangTexManager.imageData[pixelindex * 4 + 3] = a;
            ++i;
        }
        i = -8;
        while (i <= 16) {
            col = (int)(8.5 + (double)dxdy[1] * (double)i * 0.3);
            row = (int)(7.5 + (double)dxdy[0] * (double)i * 0.3 * 0.5);
            pixelindex = row * 16 + col;
            colour = i < 0 ? scolour : pcolour;
            r = (byte)((colour & 0xFF0000) >> 16);
            g = (byte)((colour & 0xFF00) >> 8);
            b = (byte)(colour & 0xFF);
            a = (byte)((colour & 0xFF000000) >> 24);
            TriangTexManager.imageData[pixelindex * 4 + 0] = r;
            TriangTexManager.imageData[pixelindex * 4 + 1] = g;
            TriangTexManager.imageData[pixelindex * 4 + 2] = b;
            TriangTexManager.imageData[pixelindex * 4 + 3] = a;
            ++i;
        }
    }

    public static void processAllTextures() {
        int iconindex = 1;
        GL11.glBindTexture((int)3553, (int)Minecraft.x().o.b("/codechicken/wirelessredstone/addons/triang.png"));
        Iterator iterator = texfreqmap.keySet().iterator();
        while (iterator.hasNext()) {
            if (iconindex == 256) {
                FMLCommonHandler.instance().raiseException((Throwable)new Exception("More than 256 different triangulators!"), "Wireless Redstone", false);
                return;
            }
            int freq = (Integer)iterator.next();
            if (!requiredtextures.contains(freq)) {
                iterator.remove();
                RedstoneEtherAddons.client().setTriangRequired((qx)ClientUtils.mc().g, freq, false);
                continue;
            }
            if (!RedstoneEtherAddons.client().isTriangOn(freq) && RedstoneEther.get((boolean)true).getFreqColourId(freq) == -1) {
                texfreqmap.put(freq, 0);
                continue;
            }
            texfreqmap.put(freq, iconindex);
            TriangTexManager.processTexture(freq, iconindex);
            ++iconindex;
        }
        requiredtextures.clear();
    }
}

