/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.bptblocks.BptBlockBed;
import buildcraft.api.bptblocks.BptBlockCustomStack;
import buildcraft.api.bptblocks.BptBlockDelegate;
import buildcraft.api.bptblocks.BptBlockDirt;
import buildcraft.api.bptblocks.BptBlockDoor;
import buildcraft.api.bptblocks.BptBlockIgnore;
import buildcraft.api.bptblocks.BptBlockIgnoreMeta;
import buildcraft.api.bptblocks.BptBlockInventory;
import buildcraft.api.bptblocks.BptBlockLever;
import buildcraft.api.bptblocks.BptBlockLiquid;
import buildcraft.api.bptblocks.BptBlockPiston;
import buildcraft.api.bptblocks.BptBlockPumpkin;
import buildcraft.api.bptblocks.BptBlockRedstoneRepeater;
import buildcraft.api.bptblocks.BptBlockRotateInventory;
import buildcraft.api.bptblocks.BptBlockRotateMeta;
import buildcraft.api.bptblocks.BptBlockSign;
import buildcraft.api.bptblocks.BptBlockStairs;
import buildcraft.api.bptblocks.BptBlockWallSide;
import buildcraft.api.filler.FillerManager;
import buildcraft.builders.BlockArchitect;
import buildcraft.builders.BlockBlueprintLibrary;
import buildcraft.builders.BlockBuilder;
import buildcraft.builders.BlockFiller;
import buildcraft.builders.BlockMarker;
import buildcraft.builders.BlockPathMarker;
import buildcraft.builders.BptBlockFiller;
import buildcraft.builders.EventHandlerBuilders;
import buildcraft.builders.FillerFillAll;
import buildcraft.builders.FillerFillPyramid;
import buildcraft.builders.FillerFillStairs;
import buildcraft.builders.FillerFillWalls;
import buildcraft.builders.FillerFlattener;
import buildcraft.builders.FillerRegistry;
import buildcraft.builders.FillerRemover;
import buildcraft.builders.GuiHandler;
import buildcraft.builders.IBuilderHook;
import buildcraft.builders.ItemBptBluePrint;
import buildcraft.builders.ItemBptTemplate;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.TileFiller;
import buildcraft.builders.TileMarker;
import buildcraft.builders.TilePathMarker;
import buildcraft.builders.network.PacketHandlerBuilders;
import buildcraft.core.DefaultProps;
import buildcraft.core.blueprints.BptPlayerIndex;
import buildcraft.core.blueprints.BptRootIndex;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.IOException;
import java.util.LinkedList;
import java.util.TreeMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;

@Mod(name="BuildCraft Builders", version="3.4.3", useMetadata=false, modid="BuildCraft|Builders", dependencies="required-after:BuildCraft|Core@3.4.3")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerBuilders.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftBuilders {
    public static final int LIBRARY_PAGE_SIZE = 12;
    public static final int MAX_BLUEPRINTS_NAME_SIZE = 14;
    public static BlockMarker markerBlock;
    public static BlockPathMarker pathMarkerBlock;
    public static BlockFiller fillerBlock;
    public static BlockBuilder builderBlock;
    public static BlockArchitect architectBlock;
    public static BlockBlueprintLibrary libraryBlock;
    public static ItemBptTemplate templateItem;
    public static ItemBptBluePrint blueprintItem;
    public static boolean fillerDestroy;
    private static BptRootIndex rootBptIndex;
    public static TreeMap playerLibrary;
    private static LinkedList hooks;
    @Mod.Instance(value="BuildCraft|Builders")
    public static BuildCraftBuilders instance;

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        FillerManager.registry = new FillerRegistry();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerBuilders());
        new BptBlock(0);
        new BptBlockIgnore(amq.aV.cm);
        new BptBlockIgnore(amq.aa.cm);
        new BptBlockIgnore(amq.aW.cm);
        new BptBlockIgnore(amq.ad.cm);
        new BptBlockDirt(amq.y.cm);
        new BptBlockDirt(amq.x.cm);
        new BptBlockDirt(amq.aD.cm);
        new BptBlockDelegate(amq.aS.cm, amq.aT.cm);
        new BptBlockDelegate(amq.aF.cm, amq.aE.cm);
        new BptBlockDelegate(amq.af.cm, amq.ac.cm);
        new BptBlockWallSide(amq.at.cm);
        new BptBlockWallSide(amq.aT.cm);
        new BptBlockRotateMeta(amq.aI.cm, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateMeta(amq.by.cm, new int[]{0, 1, 2, 3}, true);
        new BptBlockRotateInventory(amq.aE.cm, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(amq.ax.cm, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(amq.bm.cm, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(amq.S.cm, new int[]{2, 5, 3, 4}, true);
        new BptBlockInventory(amq.bI.cm);
        new BptBlockRotateMeta(amq.bx.cm, new int[]{1, 4, 8, 2}, false);
        new BptBlockRotateMeta(amq.bn.cm, new int[]{0, 1, 2, 3}, false);
        new BptBlockLever(amq.ci.cm);
        new BptBlockLever(amq.aU.cm);
        new BptBlockLever(amq.aM.cm);
        new BptBlockCustomStack(amq.w.cm, new ur(amq.w));
        new BptBlockCustomStack(amq.ay.cm, new ur(up.aC));
        new BptBlockCustomStack(amq.bj.cm, new ur(up.aZ));
        new BptBlockCustomStack(amq.aC.cm, new ur(up.S));
        new BptBlockCustomStack(amq.bv.cm, new ur(up.bg));
        new BptBlockCustomStack(amq.bw.cm, new ur(up.bh));
        new BptBlockCustomStack(amq.bg.cm, new ur(amq.bg));
        new BptBlockRedstoneRepeater(amq.bl.cm);
        new BptBlockRedstoneRepeater(amq.bk.cm);
        new BptBlockLiquid(amq.E.cm, new ur(up.ax));
        new BptBlockLiquid(amq.D.cm, new ur(up.ax));
        new BptBlockLiquid(amq.G.cm, new ur(up.ay));
        new BptBlockLiquid(amq.F.cm, new ur(up.ay));
        new BptBlockIgnoreMeta(amq.aJ.cm);
        new BptBlockIgnoreMeta(amq.W.cm);
        new BptBlockIgnoreMeta(amq.X.cm);
        new BptBlockIgnoreMeta(amq.bt.cm);
        new BptBlockPiston(amq.ac.cm);
        new BptBlockPiston(amq.Y.cm);
        new BptBlockPumpkin(amq.bi.cm);
        new BptBlockStairs(amq.aK.cm);
        new BptBlockStairs(amq.aw.cm);
        new BptBlockStairs(amq.bF.cm);
        new BptBlockStairs(amq.bz.cm);
        new BptBlockStairs(amq.bA.cm);
        new BptBlockDoor(amq.aH.cm, new ur(up.av));
        new BptBlockDoor(amq.aO.cm, new ur(up.aB));
        new BptBlockBed(amq.V.cm);
        new BptBlockSign(amq.aL.cm, true);
        new BptBlockSign(amq.aG.cm, false);
        new BptBlockRotateInventory(BuildCraftBuilders.architectBlock.cm, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(BuildCraftBuilders.builderBlock.cm, new int[]{2, 5, 3, 4}, true);
        new BptBlockInventory(BuildCraftBuilders.libraryBlock.cm);
        new BptBlockWallSide(BuildCraftBuilders.markerBlock.cm);
        new BptBlockWallSide(BuildCraftBuilders.pathMarkerBlock.cm);
        new BptBlockFiller(BuildCraftBuilders.fillerBlock.cm);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftBuilders.loadRecipes();
        }
    }

    @Mod.PreInit
    public void initialize(FMLPreInitializationEvent evt) {
        Property templateItemId = BuildCraftCore.mainConfiguration.getItem("templateItem.id", DefaultProps.TEMPLATE_ITEM_ID);
        Property blueprintItemId = BuildCraftCore.mainConfiguration.getItem("blueprintItem.id", DefaultProps.BLUEPRINT_ITEM_ID);
        Property markerId = BuildCraftCore.mainConfiguration.getBlock("marker.id", DefaultProps.MARKER_ID);
        Property pathMarkerId = BuildCraftCore.mainConfiguration.getBlock("pathMarker.id", DefaultProps.PATH_MARKER_ID);
        Property fillerId = BuildCraftCore.mainConfiguration.getBlock("filler.id", DefaultProps.FILLER_ID);
        Property builderId = BuildCraftCore.mainConfiguration.getBlock("builder.id", DefaultProps.BUILDER_ID);
        Property architectId = BuildCraftCore.mainConfiguration.getBlock("architect.id", DefaultProps.ARCHITECT_ID);
        Property libraryId = BuildCraftCore.mainConfiguration.getBlock("blueprintLibrary.id", DefaultProps.BLUEPRINT_LIBRARY_ID);
        Property fillerDestroyProp = BuildCraftCore.mainConfiguration.get("general", "filler.destroy", DefaultProps.FILLER_DESTROY);
        fillerDestroyProp.comment = "If true, Filler will destroy blocks instead of breaking them.";
        fillerDestroy = fillerDestroyProp.getBoolean(DefaultProps.FILLER_DESTROY);
        templateItem = new ItemBptTemplate(Integer.parseInt(templateItemId.value));
        templateItem.b("templateItem");
        LanguageRegistry.addName((Object)((Object)templateItem), (String)"Template");
        blueprintItem = new ItemBptBluePrint(Integer.parseInt(blueprintItemId.value));
        blueprintItem.b("blueprintItem");
        LanguageRegistry.addName((Object)((Object)blueprintItem), (String)"Blueprint");
        markerBlock = new BlockMarker(Integer.parseInt(markerId.value));
        CoreProxy.proxy.registerBlock(markerBlock.b("markerBlock"));
        CoreProxy.proxy.addName((Object)markerBlock, "Land Mark");
        pathMarkerBlock = new BlockPathMarker(Integer.parseInt(pathMarkerId.value));
        CoreProxy.proxy.registerBlock(pathMarkerBlock.b("pathMarkerBlock"));
        CoreProxy.proxy.addName((Object)pathMarkerBlock, "Path Mark");
        fillerBlock = new BlockFiller(Integer.parseInt(fillerId.value));
        CoreProxy.proxy.registerBlock(fillerBlock.b("fillerBlock"));
        CoreProxy.proxy.addName((Object)fillerBlock, "Filler");
        builderBlock = new BlockBuilder(Integer.parseInt(builderId.value));
        CoreProxy.proxy.registerBlock(builderBlock.b("builderBlock"));
        CoreProxy.proxy.addName((Object)builderBlock, "Builder");
        architectBlock = new BlockArchitect(Integer.parseInt(architectId.value));
        CoreProxy.proxy.registerBlock(architectBlock.b("architectBlock"));
        CoreProxy.proxy.addName((Object)architectBlock, "Architect Table");
        libraryBlock = new BlockBlueprintLibrary(Integer.parseInt(libraryId.value));
        CoreProxy.proxy.registerBlock(libraryBlock.b("libraryBlock"));
        CoreProxy.proxy.addName((Object)libraryBlock, "Blueprint Library");
        GameRegistry.registerTileEntity(TileMarker.class, (String)"Marker");
        GameRegistry.registerTileEntity(TileFiller.class, (String)"Filler");
        GameRegistry.registerTileEntity(TileBuilder.class, (String)"net.minecraft.src.builders.TileBuilder");
        GameRegistry.registerTileEntity(TileArchitect.class, (String)"net.minecraft.src.builders.TileTemplate");
        GameRegistry.registerTileEntity(TilePathMarker.class, (String)"net.minecraft.src.builders.TilePathMarker");
        GameRegistry.registerTileEntity(TileBlueprintLibrary.class, (String)"net.minecraft.src.builders.TileBlueprintLibrary");
        BuildCraftCore.mainConfiguration.save();
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ur((up)templateItem, 1), new Object[]{"ppp", "pip", "ppp", Character.valueOf('i'), new ur(up.aW, 1, 0), Character.valueOf('p'), up.aK});
        CoreProxy.proxy.addCraftingRecipe(new ur((up)blueprintItem, 1), new Object[]{"ppp", "pip", "ppp", Character.valueOf('i'), new ur(up.aW, 1, 4), Character.valueOf('p'), up.aK});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)markerBlock, 1), new Object[]{"l ", "r ", Character.valueOf('l'), new ur(up.aW, 1, 4), Character.valueOf('r'), amq.aT});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)pathMarkerBlock, 1), new Object[]{"l ", "r ", Character.valueOf('l'), new ur(up.aW, 1, 2), Character.valueOf('r'), amq.aT});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)fillerBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ur(up.aW, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ur(up.aW, 1, 11), Character.valueOf('c'), amq.aB, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('C'), amq.ax});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)builderBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ur(up.aW, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ur(up.aW, 1, 11), Character.valueOf('c'), amq.aB, Character.valueOf('g'), BuildCraftCore.diamondGearItem, Character.valueOf('C'), amq.ax});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)architectBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ur(up.aW, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ur(up.aW, 1, 11), Character.valueOf('c'), amq.aB, Character.valueOf('g'), BuildCraftCore.diamondGearItem, Character.valueOf('C'), new ur((up)templateItem, 1)});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)libraryBlock, 1), new Object[]{"bbb", "bBb", "bbb", Character.valueOf('b'), new ur((up)blueprintItem), Character.valueOf('B'), amq.aq});
        FillerManager.registry.addRecipe(new FillerFillAll(), new Object[]{"bbb", "bbb", "bbb", Character.valueOf('b'), new ur(amq.ao, 1)});
        FillerManager.registry.addRecipe(new FillerFlattener(), new Object[]{"   ", "ggg", "bbb", Character.valueOf('g'), amq.P, Character.valueOf('b'), amq.ao});
        FillerManager.registry.addRecipe(new FillerRemover(), new Object[]{"ggg", "ggg", "ggg", Character.valueOf('g'), amq.P});
        FillerManager.registry.addRecipe(new FillerFillWalls(), new Object[]{"bbb", "b b", "bbb", Character.valueOf('b'), amq.ao});
        FillerManager.registry.addRecipe(new FillerFillPyramid(), new Object[]{"   ", " b ", "bbb", Character.valueOf('b'), amq.ao});
        FillerManager.registry.addRecipe(new FillerFillStairs(), new Object[]{"  b", " bb", "bbb", Character.valueOf('b'), amq.ao});
    }

    public static BptPlayerIndex getPlayerIndex(String name) {
        BptRootIndex rootIndex = BuildCraftBuilders.getBptRootIndex();
        if (!playerLibrary.containsKey(name)) {
            try {
                playerLibrary.put(name, new BptPlayerIndex(name + ".list", rootIndex));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (BptPlayerIndex)playerLibrary.get(name);
    }

    public static BptRootIndex getBptRootIndex() {
        if (rootBptIndex == null) {
            try {
                rootBptIndex = new BptRootIndex("index.txt");
                rootBptIndex.loadIndex();
                for (IBuilderHook hook : hooks) {
                    hook.rootIndexInitialized(rootBptIndex);
                }
                rootBptIndex.importNewFiles();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rootBptIndex;
    }

    public static ur getBptItemStack(int id, int damage, String name) {
        ur stack = new ur(id, 1, damage);
        bq nbt = new bq();
        if (name != null && !"".equals(name)) {
            nbt.a("BptName", name);
            stack.d(nbt);
        }
        return stack;
    }

    public static void addHook(IBuilderHook hook) {
        if (!hooks.contains(hook)) {
            hooks.add(hook);
        }
    }

    @Mod.ServerStopping
    public void ServerStop(FMLServerStoppingEvent event) {
        TilePathMarker.clearAvailableMarkersList();
    }

    static {
        playerLibrary = new TreeMap();
        hooks = new LinkedList();
    }
}

