/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.bptblocks.BptBlockInventory;
import buildcraft.api.bptblocks.BptBlockRotateMeta;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemRedstoneChipset;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.silicon.BlockAssemblyTable;
import buildcraft.silicon.BlockLaser;
import buildcraft.silicon.GuiHandler;
import buildcraft.silicon.ItemAssemblyTable;
import buildcraft.silicon.SiliconProxy;
import buildcraft.silicon.TileAssemblyAdvancedWorkbench;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.TileLaser;
import buildcraft.silicon.network.PacketHandlerSilicon;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraftforge.common.Property;

@Mod(name="BuildCraft Silicon", version="3.4.3", useMetadata=false, modid="BuildCraft|Silicon", dependencies="required-after:BuildCraft|Transport@3.4.3")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerSilicon.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftSilicon {
    public static up redstoneChipset;
    public static BlockLaser laserBlock;
    public static BlockAssemblyTable assemblyTableBlock;
    @Mod.Instance(value="BuildCraft|Silicon")
    public static BuildCraftSilicon instance;

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CoreProxy.proxy.registerTileEntity(TileLaser.class, "net.minecraft.src.buildcraft.factory.TileLaser");
        CoreProxy.proxy.registerTileEntity(TileAssemblyTable.class, "net.minecraft.src.buildcraft.factory.TileAssemblyTable");
        CoreProxy.proxy.registerTileEntity(TileAssemblyAdvancedWorkbench.class, "net.minecraft.src.buildcraft.factory.TileAssemblyAdvancedWorkbench");
        new BptBlockRotateMeta(BuildCraftSilicon.laserBlock.cm, new int[]{2, 5, 3, 4}, true);
        new BptBlockInventory(BuildCraftSilicon.assemblyTableBlock.cm);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftSilicon.loadRecipes();
        }
        SiliconProxy.proxy.registerRenderers();
    }

    @Mod.PreInit
    public void initialize(FMLPreInitializationEvent evt) {
        Property laserId = BuildCraftCore.mainConfiguration.getBlock("laser.id", DefaultProps.LASER_ID);
        Property assemblyTableId = BuildCraftCore.mainConfiguration.getBlock("assemblyTable.id", DefaultProps.ASSEMBLY_TABLE_ID);
        Property redstoneChipsetId = BuildCraftCore.mainConfiguration.getItem("redstoneChipset.id", DefaultProps.REDSTONE_CHIPSET);
        BuildCraftCore.mainConfiguration.save();
        laserBlock = new BlockLaser(Integer.parseInt(laserId.value));
        CoreProxy.proxy.addName(laserBlock.b("laserBlock"), "Laser");
        CoreProxy.proxy.registerBlock((amq)laserBlock);
        assemblyTableBlock = new BlockAssemblyTable(Integer.parseInt(assemblyTableId.value));
        GameRegistry.registerBlock((amq)assemblyTableBlock, ItemAssemblyTable.class);
        LanguageRegistry.addName((Object)new ur((amq)assemblyTableBlock, 0, 0), (String)"Assembly Table");
        LanguageRegistry.addName((Object)new ur((amq)assemblyTableBlock, 0, 1), (String)"Advanced Crafting Table");
        redstoneChipset = new ItemRedstoneChipset(Integer.parseInt(redstoneChipsetId.value));
        redstoneChipset.b("redstoneChipset");
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)laserBlock), new Object[]{"ORR", "DDR", "ORR", Character.valueOf('O'), amq.as, Character.valueOf('R'), up.aC, Character.valueOf('D'), up.n});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)assemblyTableBlock, 1, 0), new Object[]{"ORO", "ODO", "OGO", Character.valueOf('O'), amq.as, Character.valueOf('R'), up.aC, Character.valueOf('D'), up.n, Character.valueOf('G'), BuildCraftCore.diamondGearItem});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)assemblyTableBlock, 1, 1), new Object[]{"OWO", "OCO", "ORO", Character.valueOf('O'), amq.as, Character.valueOf('W'), amq.aB, Character.valueOf('C'), amq.ax, Character.valueOf('R'), new ur(redstoneChipset, 1, 0)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGate, 1, 2), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGate, 1, 1)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGate, 1, 1), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGate, 1, 2)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGate, 1, 4), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGate, 1, 3)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGate, 1, 3), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGate, 1, 4)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGate, 1, 6), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGate, 1, 5)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGate, 1, 5), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGate, 1, 6)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 2), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGateAutarchic, 1, 1)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 1), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGateAutarchic, 1, 2)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 4), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGateAutarchic, 1, 3)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 3), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGateAutarchic, 1, 4)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 6), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGateAutarchic, 1, 5)});
        CoreProxy.proxy.addShapelessRecipe(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 5), new Object[]{new ur(redstoneChipset, 1, 0), new ur(BuildCraftTransport.pipeGateAutarchic, 1, 6)});
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aC)}, 10000, new ur(redstoneChipset, 1, 0)));
        CoreProxy.proxy.addName(new ur(redstoneChipset, 1, 0), "Redstone Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aC), new ur(up.o)}, 20000, new ur(redstoneChipset, 1, 1)));
        CoreProxy.proxy.addName(new ur(redstoneChipset, 1, 1), "Redstone Iron Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aC), new ur(up.p)}, 40000, new ur(redstoneChipset, 1, 2)));
        CoreProxy.proxy.addName(new ur(redstoneChipset, 1, 2), "Redstone Golden Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aC), new ur(up.n)}, 80000, new ur(redstoneChipset, 1, 3)));
        CoreProxy.proxy.addName(new ur(redstoneChipset, 1, 3), "Redstone Diamond Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(up.aC), new ur(up.bn)}, 40000, new ur(redstoneChipset, 2, 4)));
        CoreProxy.proxy.addName(new ur(redstoneChipset, 1, 4), "Pulsating Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(redstoneChipset, 1, 0)}, 20000, new ur(BuildCraftTransport.pipeGate, 1, 0)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGate, 1, 0), "Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(BuildCraftTransport.pipeGate, 1, 0), new ur(redstoneChipset, 1, 4), new ur(redstoneChipset, 1, 1)}, 10000, new ur(BuildCraftTransport.pipeGateAutarchic, 1, 0)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 0), "Autarchic Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(redstoneChipset, 1, 1), new ur(BuildCraftTransport.redPipeWire)}, 40000, new ur(BuildCraftTransport.pipeGate, 1, 1)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGate, 1, 1), "Iron AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(BuildCraftTransport.pipeGate, 1, 1), new ur(redstoneChipset, 1, 4), new ur(redstoneChipset, 1, 1)}, 20000, new ur(BuildCraftTransport.pipeGateAutarchic, 1, 1)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 1), "Autarchic Iron AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(redstoneChipset, 1, 1), new ur(BuildCraftTransport.redPipeWire)}, 40000, new ur(BuildCraftTransport.pipeGate, 1, 2)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGate, 1, 2), "Iron OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(BuildCraftTransport.pipeGate, 1, 2), new ur(redstoneChipset, 1, 4), new ur(redstoneChipset, 1, 1)}, 20000, new ur(BuildCraftTransport.pipeGateAutarchic, 1, 2)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 2), "Autarchic Iron OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(redstoneChipset, 1, 2), new ur(BuildCraftTransport.redPipeWire), new ur(BuildCraftTransport.bluePipeWire)}, 80000, new ur(BuildCraftTransport.pipeGate, 1, 3)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGate, 1, 3), "Gold AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(BuildCraftTransport.pipeGate, 1, 3), new ur(redstoneChipset, 1, 4), new ur(redstoneChipset, 1, 1)}, 40000, new ur(BuildCraftTransport.pipeGateAutarchic, 1, 3)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 3), "Autarchic Gold AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(redstoneChipset, 1, 2), new ur(BuildCraftTransport.redPipeWire), new ur(BuildCraftTransport.bluePipeWire)}, 80000, new ur(BuildCraftTransport.pipeGate, 1, 4)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGate, 1, 4), "Gold OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(BuildCraftTransport.pipeGate, 1, 4), new ur(redstoneChipset, 1, 4), new ur(redstoneChipset, 1, 1)}, 40000, new ur(BuildCraftTransport.pipeGateAutarchic, 1, 4)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 4), "Autarchic Gold OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(redstoneChipset, 1, 3), new ur(BuildCraftTransport.redPipeWire), new ur(BuildCraftTransport.bluePipeWire), new ur(BuildCraftTransport.greenPipeWire), new ur(BuildCraftTransport.yellowPipeWire)}, 160000, new ur(BuildCraftTransport.pipeGate, 1, 5)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGate, 1, 5), "Diamond AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(BuildCraftTransport.pipeGate, 1, 5), new ur(redstoneChipset, 1, 4), new ur(redstoneChipset, 1, 1)}, 80000, new ur(BuildCraftTransport.pipeGateAutarchic, 1, 5)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 5), "Autarchic Diamond AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(redstoneChipset, 1, 3), new ur(BuildCraftTransport.redPipeWire), new ur(BuildCraftTransport.bluePipeWire), new ur(BuildCraftTransport.greenPipeWire), new ur(BuildCraftTransport.yellowPipeWire)}, 160000, new ur(BuildCraftTransport.pipeGate, 1, 6)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGate, 1, 6), "Diamond OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(BuildCraftTransport.pipeGate, 1, 6), new ur(redstoneChipset, 1, 4), new ur(redstoneChipset, 1, 1)}, 80000, new ur(BuildCraftTransport.pipeGateAutarchic, 1, 6)));
        CoreProxy.proxy.addName(new ur(BuildCraftTransport.pipeGateAutarchic, 1, 6), "Autarchic Diamond OR Gate");
    }
}

