/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.core.BlockIndex;
import buildcraft.core.EntityBlock;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.IFramePipeConnection;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.energy.TileEngine;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquid;
import net.minecraftforge.liquids.LiquidStack;

public class Utils {
    public static final float pipeMinPos = 0.25f;
    public static final float pipeMaxPos = 0.75f;
    public static float pipeNormalSpeed = 0.01f;

    public static ur addToRandomInventory(ur stack, yc world, int x, int y2, int z, ForgeDirection from) {
        LinkedList<ITransactor> possibleInventories = new LinkedList<ITransactor>();
        for (ForgeDirection orientation : ForgeDirection.values()) {
            if (from.getOpposite() == orientation) continue;
            Position pos = new Position(x, y2, z, orientation);
            pos.moveForwards(1.0);
            any tileInventory = world.q((int)pos.x, (int)pos.y, (int)pos.z);
            ITransactor transactor = Transactor.getTransactorFor(tileInventory);
            if (transactor == null || tileInventory instanceof TileEngine || transactor.add((ur)stack, (ForgeDirection)from, (boolean)false).a <= 0) continue;
            possibleInventories.add(transactor);
        }
        if (possibleInventories.size() > 0) {
            int choice = world.t.nextInt(possibleInventories.size());
            return ((ITransactor)possibleInventories.get(choice)).add(stack, from, true);
        }
        ur added = stack.l();
        added.a = 0;
        return added;
    }

    public static float getPipeFloorOf(ur item) {
        return 0.25f;
    }

    public static ForgeDirection get2dOrientation(Position pos1, Position pos2) {
        double Dz = pos1.z - pos2.z;
        double Dx = pos1.x - pos2.x;
        double angle = Math.atan2(Dz, Dx) / Math.PI * 180.0 + 180.0;
        if (angle < 45.0 || angle > 315.0) {
            return ForgeDirection.EAST;
        }
        if (angle < 135.0) {
            return ForgeDirection.SOUTH;
        }
        if (angle < 225.0) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection get3dOrientation(Position pos1, Position pos2) {
        double Dy = pos1.y - pos2.y;
        double Dx = pos1.x - pos2.x;
        double angle = Math.atan2(Dy, Dx) / Math.PI * 180.0 + 180.0;
        if (angle > 45.0 && angle < 135.0) {
            return ForgeDirection.UP;
        }
        if (angle > 225.0 && angle < 315.0) {
            return ForgeDirection.DOWN;
        }
        return Utils.get2dOrientation(pos1, pos2);
    }

    public static boolean addToRandomPipeEntry(any tile, ForgeDirection from, ur items) {
        Object pipeEntry;
        yc w2 = tile.k;
        LinkedList<ForgeDirection> possiblePipes = new LinkedList<ForgeDirection>();
        for (int j = 0; j < 6; ++j) {
            if (from.getOpposite().ordinal() == j) continue;
            ForgeDirection o = ForgeDirection.values()[j];
            Position pos = new Position(tile.l, tile.m, tile.n, o);
            pos.moveForwards(1.0);
            pipeEntry = w2.q((int)pos.x, (int)pos.y, (int)pos.z);
            if (!(pipeEntry instanceof IPipeEntry) || !((IPipeEntry)pipeEntry).acceptItems() || pipeEntry instanceof IPipeConnection && !((IPipeConnection)pipeEntry).isPipeConnected(o.getOpposite())) continue;
            possiblePipes.add(o);
        }
        if (possiblePipes.size() > 0) {
            int choice = w2.t.nextInt(possiblePipes.size());
            Position entityPos = new Position(tile.l, tile.m, tile.n, (ForgeDirection)possiblePipes.get(choice));
            Position pipePos = new Position(tile.l, tile.m, tile.n, (ForgeDirection)possiblePipes.get(choice));
            entityPos.x += 0.5;
            entityPos.y += (double)Utils.getPipeFloorOf(items);
            entityPos.z += 0.5;
            entityPos.moveForwards(0.5);
            pipePos.moveForwards(1.0);
            pipeEntry = (IPipeEntry)w2.q((int)pipePos.x, (int)pipePos.y, (int)pipePos.z);
            EntityPassiveItem entity = new EntityPassiveItem(w2, entityPos.x, entityPos.y, entityPos.z, items);
            pipeEntry.entityEntering(entity, entityPos.orientation);
            items.a = 0;
            return true;
        }
        return false;
    }

    public static void dropItems(yc world, ur stack, int i, int j, int k) {
        if (stack.a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        px entityitem = new px(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.b = 10;
        world.d((lq)entityitem);
    }

    public static void dropItems(yc world, la inventory, int i, int j, int k) {
        for (int l = 0; l < inventory.k_(); ++l) {
            ur items = inventory.a(l);
            if (items == null || items.a <= 0) continue;
            Utils.dropItems(world, inventory.a(l).l(), i, j, k);
        }
    }

    public static any getTile(yc world, Position pos, ForgeDirection step) {
        Position tmp = new Position(pos);
        tmp.orientation = step;
        tmp.moveForwards(1.0);
        return world.q((int)tmp.x, (int)tmp.y, (int)tmp.z);
    }

    public static la getInventory(la inv) {
        if (inv instanceof anm) {
            anm chest = (anm)inv;
            Position pos = new Position(chest.l, chest.m, chest.n);
            la chest2 = null;
            any tile = Utils.getTile(chest.k, pos, ForgeDirection.WEST);
            if (tile instanceof anm) {
                chest2 = (la)tile;
            }
            if ((tile = Utils.getTile(chest.k, pos, ForgeDirection.EAST)) instanceof anm) {
                chest2 = (la)tile;
            }
            if ((tile = Utils.getTile(chest.k, pos, ForgeDirection.NORTH)) instanceof anm) {
                chest2 = (la)tile;
            }
            if ((tile = Utils.getTile(chest.k, pos, ForgeDirection.SOUTH)) instanceof anm) {
                chest2 = (la)tile;
            }
            if (chest2 != null) {
                return new kz("", inv, chest2);
            }
        }
        return inv;
    }

    public static IAreaProvider getNearbyAreaProvider(yc world, int i, int j, int k) {
        any a1 = world.q(i + 1, j, k);
        any a2 = world.q(i - 1, j, k);
        any a3 = world.q(i, j, k + 1);
        any a4 = world.q(i, j, k - 1);
        any a5 = world.q(i, j + 1, k);
        any a6 = world.q(i, j - 1, k);
        if (a1 instanceof IAreaProvider) {
            return (IAreaProvider)a1;
        }
        if (a2 instanceof IAreaProvider) {
            return (IAreaProvider)a2;
        }
        if (a3 instanceof IAreaProvider) {
            return (IAreaProvider)a3;
        }
        if (a4 instanceof IAreaProvider) {
            return (IAreaProvider)a4;
        }
        if (a5 instanceof IAreaProvider) {
            return (IAreaProvider)a5;
        }
        if (a6 instanceof IAreaProvider) {
            return (IAreaProvider)a6;
        }
        return null;
    }

    public static EntityBlock createLaser(yc world, Position p1, Position p2, LaserKind kind) {
        if (p1.equals(p2)) {
            return null;
        }
        double iSize = p2.x - p1.x;
        double jSize = p2.y - p1.y;
        double kSize = p2.z - p1.z;
        double i = p1.x;
        double j = p1.y;
        double k = p1.z;
        if (iSize != 0.0) {
            i += 0.5;
            j += 0.45;
            k += 0.45;
            jSize = 0.1;
            kSize = 0.1;
        } else if (jSize != 0.0) {
            i += 0.45;
            j += 0.5;
            k += 0.45;
            iSize = 0.1;
            kSize = 0.1;
        } else if (kSize != 0.0) {
            i += 0.45;
            j += 0.45;
            k += 0.5;
            iSize = 0.1;
            jSize = 0.1;
        }
        int texture = BuildCraftCore.redLaserTexture;
        switch (kind) {
            case Blue: {
                texture = BuildCraftCore.blueLaserTexture;
                break;
            }
            case Red: {
                texture = BuildCraftCore.redLaserTexture;
                break;
            }
            case Stripes: {
                texture = BuildCraftCore.stripesLaserTexture;
            }
        }
        EntityBlock block = new EntityBlock(world, i, j, k, iSize, jSize, kSize, texture);
        world.d((lq)block);
        return block;
    }

    public static EntityBlock[] createLaserBox(yc world, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, LaserKind kind) {
        EntityBlock[] lasers = new EntityBlock[12];
        Position[] p = new Position[]{new Position(xMin, yMin, zMin), new Position(xMax, yMin, zMin), new Position(xMin, yMax, zMin), new Position(xMax, yMax, zMin), new Position(xMin, yMin, zMax), new Position(xMax, yMin, zMax), new Position(xMin, yMax, zMax), new Position(xMax, yMax, zMax)};
        lasers[0] = Utils.createLaser(world, p[0], p[1], kind);
        lasers[1] = Utils.createLaser(world, p[0], p[2], kind);
        lasers[2] = Utils.createLaser(world, p[2], p[3], kind);
        lasers[3] = Utils.createLaser(world, p[1], p[3], kind);
        lasers[4] = Utils.createLaser(world, p[4], p[5], kind);
        lasers[5] = Utils.createLaser(world, p[4], p[6], kind);
        lasers[6] = Utils.createLaser(world, p[5], p[7], kind);
        lasers[7] = Utils.createLaser(world, p[6], p[7], kind);
        lasers[8] = Utils.createLaser(world, p[0], p[4], kind);
        lasers[9] = Utils.createLaser(world, p[1], p[5], kind);
        lasers[10] = Utils.createLaser(world, p[2], p[6], kind);
        lasers[11] = Utils.createLaser(world, p[3], p[7], kind);
        return lasers;
    }

    public static void handleBufferedDescription(ISynchronizedTile tileSynch) {
        any tile = (any)tileSynch;
        BlockIndex index = new BlockIndex(tile.l, tile.m, tile.n);
        if (BuildCraftCore.bufferedDescriptions.containsKey(index)) {
            PacketUpdate payload = (PacketUpdate)BuildCraftCore.bufferedDescriptions.get(index);
            BuildCraftCore.bufferedDescriptions.remove(index);
            tileSynch.handleDescriptionPacket(payload);
            tileSynch.postPacketHandling(payload);
        }
    }

    public static int liquidId(int blockId) {
        if (blockId == amq.E.cm || blockId == amq.D.cm) {
            return amq.E.cm;
        }
        if (blockId == amq.G.cm || blockId == amq.F.cm) {
            return amq.G.cm;
        }
        if (amq.p[blockId] instanceof ILiquid) {
            return ((ILiquid)amq.p[blockId]).stillLiquidId();
        }
        return 0;
    }

    public static LiquidStack liquidFromBlockId(int blockId) {
        if (blockId == amq.E.cm || blockId == amq.D.cm) {
            return new LiquidStack(amq.E.cm, 1000, 0);
        }
        if (blockId == amq.G.cm || blockId == amq.F.cm) {
            return new LiquidStack(amq.G.cm, 1000, 0);
        }
        if (amq.p[blockId] instanceof ILiquid) {
            ILiquid liquid = (ILiquid)amq.p[blockId];
            if (liquid.isMetaSensitive()) {
                return new LiquidStack(liquid.stillLiquidId(), 1000, liquid.stillLiquidMeta());
            }
            return new LiquidStack(liquid.stillLiquidId(), 1000, 0);
        }
        return null;
    }

    public static void preDestroyBlock(yc world, int i, int j, int k) {
        any tile = world.q(i, j, k);
        if (tile instanceof la && !CoreProxy.proxy.isRenderWorld(world) && (!(tile instanceof IDropControlInventory) || ((IDropControlInventory)tile).doDrop())) {
            Utils.dropItems(world, (la)tile, i, j, k);
        }
        if (tile instanceof TileBuildCraft) {
            ((TileBuildCraft)tile).destroy();
        }
    }

    public static boolean checkPipesConnections(any tile1, any tile2) {
        if (tile1 == null || tile2 == null) {
            return false;
        }
        if (!(tile1 instanceof IPipeConnection) && !(tile2 instanceof IPipeConnection)) {
            return false;
        }
        ForgeDirection o = ForgeDirection.UNKNOWN;
        if (tile1.l - 1 == tile2.l) {
            o = ForgeDirection.WEST;
        } else if (tile1.l + 1 == tile2.l) {
            o = ForgeDirection.EAST;
        } else if (tile1.m - 1 == tile2.m) {
            o = ForgeDirection.DOWN;
        } else if (tile1.m + 1 == tile2.m) {
            o = ForgeDirection.UP;
        } else if (tile1.n - 1 == tile2.n) {
            o = ForgeDirection.NORTH;
        } else if (tile1.n + 1 == tile2.n) {
            o = ForgeDirection.SOUTH;
        }
        if (tile1 instanceof IPipeConnection && !((IPipeConnection)tile1).isPipeConnected(o)) {
            return false;
        }
        return !(tile2 instanceof IPipeConnection) || ((IPipeConnection)tile2).isPipeConnected(o.getOpposite());
    }

    public static boolean checkPipesConnections(ym blockAccess, any tile1, int x2, int y2, int z2) {
        any tile2 = blockAccess.q(x2, y2, z2);
        return Utils.checkPipesConnections(tile1, tile2);
    }

    public static boolean checkLegacyPipesConnections(ym blockAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        amq b1 = amq.p[blockAccess.a(x1, y1, z1)];
        amq b2 = amq.p[blockAccess.a(x2, y2, z2)];
        if (!(b1 instanceof IFramePipeConnection) && !(b2 instanceof IFramePipeConnection)) {
            return false;
        }
        if (b1 instanceof IFramePipeConnection && !((IFramePipeConnection)b1).isPipeConnected(blockAccess, x1, y1, z1, x2, y2, z2)) {
            return false;
        }
        return !(b2 instanceof IFramePipeConnection) || ((IFramePipeConnection)b2).isPipeConnected(blockAccess, x2, y2, z2, x1, y1, z1);
    }

    public static void readStacksFromNBT(bq nbt, String name, ur[] stacks) {
        by nbttaglist = nbt.m(name);
        for (int i = 0; i < stacks.length; ++i) {
            if (i < nbttaglist.c()) {
                bq nbttagcompound2 = (bq)nbttaglist.b(i);
                stacks[i] = ur.a((bq)nbttagcompound2);
                continue;
            }
            stacks[i] = null;
        }
    }

    public static void writeStacksToNBT(bq nbt, String name, ur[] stacks) {
        by nbttaglist = new by();
        for (int i = 0; i < stacks.length; ++i) {
            bq cpt = new bq();
            nbttaglist.a((cd)cpt);
            if (stacks[i] == null) continue;
            stacks[i].b(cpt);
        }
        nbt.a(name, (cd)nbttaglist);
    }

    public static ur consumeItem(ur stack) {
        if (stack.a == 1) {
            if (stack.b().s()) {
                return stack.b().getContainerItemStack(stack);
            }
            return null;
        }
        stack.a(1);
        return stack;
    }

    public static Object[] concat(Object[] first, Object[] second) {
        Object[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] concat(int[] first, int[] second) {
        int[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static float[] concat(float[] first, float[] second) {
        float[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

