/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtil;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;

public abstract class GuiEngine
extends GuiBuildCraft {
    public GuiEngine(BuildCraftContainer container, la inventory) {
        super(container, inventory);
    }

    @Override
    protected void initLedgers(la inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add(new EngineLedger(((TileEngine)this.tile).engine));
    }

    protected class EngineLedger
    extends GuiBuildCraft.Ledger {
        Engine engine;
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public EngineLedger(Engine engine) {
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y2) {
            this.drawBackground(x, y2);
            this.drawIcon(DefaultProps.TEXTURE_ICONS, 0, x + 3, y2 + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.l.a(StringUtil.localize("gui.energy"), x + 22, y2 + 8, this.headerColour);
            GuiEngine.this.l.a(StringUtil.localize("gui.currentOutput") + ":", x + 22, y2 + 20, this.subheaderColour);
            GuiEngine.this.l.b(this.engine.getCurrentOutput() + " MJ/t", x + 22, y2 + 32, this.textColour);
            GuiEngine.this.l.a(StringUtil.localize("gui.stored") + ":", x + 22, y2 + 44, this.subheaderColour);
            GuiEngine.this.l.b(this.engine.getEnergyStored() + " MJ", x + 22, y2 + 56, this.textColour);
            GuiEngine.this.l.a(StringUtil.localize("gui.heat") + ":", x + 22, y2 + 68, this.subheaderColour);
            GuiEngine.this.l.b((double)this.engine.getHeat() / 10.0 + " \u00b0C", x + 22, y2 + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return this.engine.getCurrentOutput() + " MJ/t";
        }
    }
}

