/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.utils.ClassUtils;
import de.matthiasmann.twl.utils.HashEntry;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionMap {
    public static final int FLAG_ON_PRESSED = 1;
    public static final int FLAG_ON_RELEASE = 2;
    public static final int FLAG_ON_REPEAT = 4;
    private Mapping[] mappings = new Mapping[16];
    private int numMappings;

    public boolean invoke(String action, Event event) {
        Mapping mapping = (Mapping)HashEntry.get((HashEntry[])this.mappings, (Object)action);
        if (mapping != null) {
            mapping.call(event);
            return true;
        }
        return false;
    }

    public void addMapping(String action, Object target, String methodName, Object[] params, int flags) throws IllegalArgumentException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        for (Method m : target.getClass().getMethods()) {
            if (!m.getName().equals(methodName) || Modifier.isStatic(m.getModifiers()) || !ClassUtils.isParamsCompatible(m.getParameterTypes(), params)) continue;
            this.addMappingImpl(action, target, m, params, flags);
            return;
        }
        throw new IllegalArgumentException("Can't find matching method: " + methodName);
    }

    public void addMapping(String action, Class<?> targetClass, String methodName, Object[] params, int flags) throws IllegalArgumentException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        for (Method m : targetClass.getMethods()) {
            if (!m.getName().equals(methodName) || !Modifier.isStatic(m.getModifiers()) || !ClassUtils.isParamsCompatible(m.getParameterTypes(), params)) continue;
            this.addMappingImpl(action, null, m, params, flags);
            return;
        }
        throw new IllegalArgumentException("Can't find matching method: " + methodName);
    }

    public void addMapping(String action, Object target, Method method, Object[] params, int flags) {
        if (action == null) {
            throw new NullPointerException("action");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Method is not public");
        }
        if (target == null && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method is not static but target is null");
        }
        if (target != null && method.getDeclaringClass().isInstance(target)) {
            throw new IllegalArgumentException("method does not belong to target");
        }
        if (!ClassUtils.isParamsCompatible(method.getParameterTypes(), params)) {
            throw new IllegalArgumentException("Paramters don't match method");
        }
        this.addMappingImpl(action, target, method, params, flags);
    }

    public void addMapping(Object target) {
        for (Method m : target.getClass().getMethods()) {
            Action action = m.getAnnotation(Action.class);
            if (action == null) continue;
            if (m.getParameterTypes().length > 0) {
                throw new UnsupportedOperationException("automatic binding of actions not supported for methods with parameters");
            }
            String name = m.getName();
            if (action.name().length() > 0) {
                name = action.name();
            }
            int flags = (action.onPressed() ? 1 : 0) | (action.onRelease() ? 2 : 0) | (action.onRepeat() ? 4 : 0);
            this.addMappingImpl(name, target, m, null, flags);
        }
    }

    protected void addMappingImpl(String action, Object target, Method method, Object[] params, int flags) {
        this.mappings = (Mapping[])HashEntry.maybeResizeTable((HashEntry[])this.mappings, (int)this.numMappings++);
        HashEntry.insertEntry((HashEntry[])this.mappings, (HashEntry)new Mapping(action, target, method, params, flags));
    }

    static class Mapping
    extends HashEntry<String, Mapping> {
        final Object target;
        final Method method;
        final Object[] params;
        final int flags;

        Mapping(String key, Object target, Method method, Object[] params, int flags) {
            super(key);
            this.target = target;
            this.method = method;
            this.params = params;
            this.flags = flags;
        }

        void call(Event e) {
            Event.Type type = e.getType();
            if (type == Event.Type.KEY_RELEASED && (this.flags & 2) != 0 || type == Event.Type.KEY_PRESSED && (this.flags & 1) != 0 && (!e.isKeyRepeated() || (this.flags & 4) != 0)) {
                try {
                    this.method.invoke(this.target, this.params);
                }
                catch (Exception ex) {
                    Logger.getLogger(ActionMap.class.getName()).log(Level.SEVERE, "Exception while invoking action handler", ex);
                }
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Action {
        public String name() default "";

        public boolean onPressed() default true;

        public boolean onRelease() default false;

        public boolean onRepeat() default true;
    }
}

