/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.DebugHook;
import de.matthiasmann.twl.ParameterList;
import de.matthiasmann.twl.ParameterMap;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.theme.ImageManager;
import de.matthiasmann.twl.theme.ThemeChildImpl;
import de.matthiasmann.twl.theme.ThemeInfoImpl;
import de.matthiasmann.twl.theme.ThemeManager;
import java.util.ArrayList;

public class ParameterListImpl
extends ThemeChildImpl
implements ParameterList {
    final ArrayList<Object> params = new ArrayList();

    ParameterListImpl(ThemeManager manager, ThemeInfoImpl parent) {
        super(manager, parent);
    }

    @Override
    public int getSize() {
        return this.params.size();
    }

    @Override
    public Font getFont(int idx) {
        Font value = this.getParameterValue(idx, Font.class);
        if (value != null) {
            return value;
        }
        return this.manager.getDefaultFont();
    }

    @Override
    public Image getImage(int idx) {
        Image img = this.getParameterValue(idx, Image.class);
        if (img == ImageManager.NONE) {
            return null;
        }
        return img;
    }

    @Override
    public MouseCursor getMouseCursor(int idx) {
        MouseCursor value = this.getParameterValue(idx, MouseCursor.class);
        return value;
    }

    @Override
    public ParameterMap getParameterMap(int idx) {
        ParameterMap value = this.getParameterValue(idx, ParameterMap.class);
        if (value == null) {
            return this.manager.emptyMap;
        }
        return value;
    }

    @Override
    public ParameterList getParameterList(int idx) {
        ParameterList value = this.getParameterValue(idx, ParameterList.class);
        if (value == null) {
            return this.manager.emptyList;
        }
        return value;
    }

    @Override
    public boolean getParameter(int idx, boolean defaultValue) {
        Boolean value = this.getParameterValue(idx, Boolean.class);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public int getParameter(int idx, int defaultValue) {
        Integer value = this.getParameterValue(idx, Integer.class);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public float getParameter(int idx, float defaultValue) {
        Float value = this.getParameterValue(idx, Float.class);
        if (value != null) {
            return value.floatValue();
        }
        return defaultValue;
    }

    @Override
    public String getParameter(int idx, String defaultValue) {
        String value = this.getParameterValue(idx, String.class);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Color getParameter(int idx, Color defaultValue) {
        Color value = this.getParameterValue(idx, Color.class);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public <E extends Enum<E>> E getParameter(int idx, E defaultValue) {
        Class<E> enumType = defaultValue.getDeclaringClass();
        Enum value = (Enum)this.getParameterValue(idx, enumType);
        if (value != null) {
            return (E)value;
        }
        return defaultValue;
    }

    @Override
    public Object getParameterValue(int idx) {
        return this.params.get(idx);
    }

    @Override
    public <T> T getParameterValue(int idx, Class<T> clazz) {
        Object value = this.getParameterValue(idx);
        if (value != null && !clazz.isInstance(value)) {
            this.wrongParameterType(idx, clazz, value.getClass());
            return null;
        }
        return clazz.cast(value);
    }

    protected void wrongParameterType(int idx, Class<?> expectedType, Class<?> foundType) {
        DebugHook.getDebugHook().wrongParameterType(this, idx, expectedType, foundType, this.getParentDescription());
    }
}

