/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.core.network.TileNetworkData;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.DelayQueue;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.logistics.LogisticsManagerV2;
import logisticspipes.network.packets.GuiArgumentPacket;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketInventoryChange;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.request.RequestManager;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.DelayedGeneric;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;

public class BaseLogicCrafting
extends BaseRoutingLogic
implements IRequireReliableTransport {
    protected SimpleInventory _dummyInventory = new SimpleInventory(10, "Requested items", 127);
    @TileNetworkData
    public int signEntityX = 0;
    @TileNetworkData
    public int signEntityY = 0;
    @TileNetworkData
    public int signEntityZ = 0;
    protected final DelayQueue _lostItems = new DelayQueue();
    @TileNetworkData
    public int satelliteId = 0;
    @TileNetworkData(staticSize=9)
    public int[] advancedSatelliteIdArray = new int[9];
    @TileNetworkData
    public int priority = 0;
    private PipeItemsCraftingLogistics _pipe = null;

    public BaseLogicCrafting() {
        this.throttleTime = 40;
    }

    protected int getNextConnectSatelliteId(boolean prev, int x, int y2) {
        List routes = this.getRoutedPipe().getRouter().getIRoutersByCost();
        int closestIdFound = prev ? 0 : Integer.MAX_VALUE;
        for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
            CoreRoutedPipe satPipe = satellite.getRoutedPipe();
            if (satPipe == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
            IRouter satRouter = satPipe.getRouter();
            for (ExitRoute route : routes) {
                if (route.destination != satRouter) continue;
                if (x == -1 && y2 == -1) {
                    if (!prev && satellite.satelliteId > this.satelliteId && satellite.satelliteId < closestIdFound) {
                        closestIdFound = satellite.satelliteId;
                        continue;
                    }
                    if (!prev || satellite.satelliteId >= this.satelliteId || satellite.satelliteId <= closestIdFound) continue;
                    closestIdFound = satellite.satelliteId;
                    continue;
                }
                if (y2 != -1) continue;
                if (!prev && satellite.satelliteId > this.advancedSatelliteIdArray[x] && satellite.satelliteId < closestIdFound) {
                    closestIdFound = satellite.satelliteId;
                    continue;
                }
                if (!prev || satellite.satelliteId >= this.advancedSatelliteIdArray[x] || satellite.satelliteId <= closestIdFound) continue;
                closestIdFound = satellite.satelliteId;
            }
        }
        if (closestIdFound == Integer.MAX_VALUE) {
            if (x == -1 && y2 == -1) {
                return this.satelliteId;
            }
            if (y2 == -1) {
                return this.advancedSatelliteIdArray[x];
            }
        }
        return closestIdFound;
    }

    public void setNextSatellite(qx player) {
        if (MainProxy.isClient(player.p)) {
            PacketCoordinates packet = new PacketCoordinates(1, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            this.satelliteId = this.getNextConnectSatelliteId(false, -1, -1);
            PacketPipeInteger packet = new PacketPipeInteger(3, this.xCoord, this.yCoord, this.zCoord, this.satelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setSatelliteId(int satelliteId, int x, int y2) {
        if (x == -1 && y2 == -1) {
            this.satelliteId = satelliteId;
        } else if (y2 == -1) {
            this.advancedSatelliteIdArray[x] = satelliteId;
        }
    }

    public void setPrevSatellite(qx player) {
        if (MainProxy.isClient(player.p)) {
            PacketCoordinates packet = new PacketCoordinates(2, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            this.satelliteId = this.getNextConnectSatelliteId(true, -1, -1);
            PacketPipeInteger packet = new PacketPipeInteger(3, this.xCoord, this.yCoord, this.zCoord, this.satelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public boolean isSatelliteConnected() {
        List routes = this.getRoutedPipe().getRouter().getIRoutersByCost();
        if (!((CoreRoutedPipe)this.container.pipe).getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (this.satelliteId == 0) {
                return true;
            }
            for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.satelliteId || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                IRouter satRouter = satPipe.getRouter();
                for (ExitRoute route : routes) {
                    if (route.destination != satRouter) continue;
                    return true;
                }
            }
        } else {
            boolean foundAll = true;
            for (int i = 0; i < 9; ++i) {
                boolean foundOne = false;
                if (this.advancedSatelliteIdArray[i] == 0) continue;
                block3: for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                    CoreRoutedPipe satPipe;
                    if (satellite.satelliteId != this.advancedSatelliteIdArray[i] || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                    IRouter satRouter = satPipe.getRouter();
                    for (ExitRoute route : routes) {
                        if (route.destination != satRouter) continue;
                        foundOne = true;
                        continue block3;
                    }
                }
                foundAll &= foundOne;
            }
            return foundAll;
        }
        return false;
    }

    public IRouter getSatelliteRouter(int x, int y2) {
        block3: {
            block2: {
                if (x != -1 || y2 != -1) break block2;
                for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                    CoreRoutedPipe satPipe;
                    if (satellite.satelliteId != this.satelliteId || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                    return satPipe.getRouter();
                }
                break block3;
            }
            if (y2 != -1) break block3;
            for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.advancedSatelliteIdArray[x] || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        }
        return null;
    }

    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this._dummyInventory.readFromNBT(nbttagcompound, "");
        this.satelliteId = nbttagcompound.e("satelliteid");
        this.signEntityX = nbttagcompound.e("CraftingSignEntityX");
        this.signEntityY = nbttagcompound.e("CraftingSignEntityY");
        this.signEntityZ = nbttagcompound.e("CraftingSignEntityZ");
        this.priority = nbttagcompound.e("priority");
        for (int i = 0; i < 9; ++i) {
            this.advancedSatelliteIdArray[i] = nbttagcompound.e("advancedSatelliteId" + i);
        }
    }

    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this._dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("satelliteid", this.satelliteId);
        nbttagcompound.a("CraftingSignEntityX", this.signEntityX);
        nbttagcompound.a("CraftingSignEntityY", this.signEntityY);
        nbttagcompound.a("CraftingSignEntityZ", this.signEntityZ);
        nbttagcompound.a("priority", this.priority);
        for (int i = 0; i < 9; ++i) {
            nbttagcompound.a("advancedSatelliteId" + i, this.advancedSatelliteIdArray[i]);
        }
    }

    @Override
    public void destroy() {
        if (this.signEntityX != 0 && this.signEntityY != 0 && this.signEntityZ != 0) {
            this.worldObj.e(this.signEntityX, this.signEntityY, this.signEntityZ, 0);
            this.signEntityX = 0;
            this.signEntityY = 0;
            this.signEntityZ = 0;
        }
    }

    @Override
    public void onWrenchClicked(qx entityplayer) {
        if (MainProxy.isServer(entityplayer.p)) {
            MainProxy.sendPacketToPlayer(new GuiArgumentPacket(10, ((CoreRoutedPipe)this.container.pipe).getUpgradeManager().isAdvancedSatelliteCrafter()).getPacket(), (Player)entityplayer);
            entityplayer.openGui((Object)LogisticsPipes.instance, 10, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        DelayedGeneric lostItem = (DelayedGeneric)this._lostItems.poll();
        while (lostItem != null) {
            SinkReply reply;
            ItemIdentifierStack stack = (ItemIdentifierStack)lostItem.get();
            if (!(this._pipe == null || this._pipe.hasOrder() || (reply = LogisticsManagerV2.canSink(this._pipe.getRouter(), null, true, stack.getItem(), null, true)) != null && reply.maxNumberOfItems >= 1)) {
                lostItem = (DelayedGeneric)this._lostItems.poll();
                continue;
            }
            int received = RequestManager.requestPartial(stack, (CoreRoutedPipe)this.container.pipe);
            if (received < stack.stackSize) {
                stack.stackSize -= received;
                this._lostItems.add(new DelayedGeneric(stack, 5000L));
            }
            lostItem = (DelayedGeneric)this._lostItems.poll();
        }
    }

    @Override
    public void itemArrived(ItemIdentifierStack item) {
    }

    @Override
    public void itemLost(ItemIdentifierStack item) {
        this._lostItems.add(new DelayedGeneric(item, 5000L));
    }

    public void openAttachedGui(qx player) {
        int i;
        if (MainProxy.isClient(player.p)) {
            if (player instanceof iq) {
                ((iq)player).i();
            } else if (player instanceof bag) {
                ((bag)player).i();
            }
            PacketCoordinates packet = new PacketCoordinates(35, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
            return;
        }
        int savedEquipped = player.bJ.c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (player.bJ.a(i) != null) continue;
            foundSlot = true;
            player.bJ.c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ur is = player.bJ.a(i);
                if (!(is.b() instanceof vq)) continue;
                foundSlot = true;
                player.bJ.c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.bJ.c = (player.bJ.c + 1) % 9;
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        boolean found = false;
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            amq block;
            for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                if (!provider.canOpenGui(tile.tile)) continue;
                found = true;
                break;
            }
            if (!found) {
                boolean bl = found = tile.tile instanceof la && !(tile.tile instanceof TileGenericPipe);
            }
            if (!found || (block = this.worldObj.a(tile.tile.l, tile.tile.m, tile.tile.n) < amq.p.length ? amq.p[this.worldObj.a(tile.tile.l, tile.tile.m, tile.tile.n)] : null) == null || !block.a(this.worldObj, tile.tile.l, tile.tile.m, tile.tile.n, player, 0, 0.0f, 0.0f, 0.0f)) continue;
            break;
        }
        player.bJ.c = savedEquipped;
    }

    public void importFromCraftingTable(qx player) {
        PacketCoordinates packet;
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            ICraftingRecipeProvider provider;
            Iterator i$ = SimpleServiceLocator.craftingRecipeProviders.iterator();
            while (i$.hasNext() && !(provider = (ICraftingRecipeProvider)i$.next()).importRecipe(tile.tile, this._dummyInventory)) {
            }
        }
        if (player == null) {
            return;
        }
        if (MainProxy.isClient(player.p)) {
            packet = new PacketCoordinates(4, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            packet = new PacketInventoryChange(5, this.xCoord, this.yCoord, this.zCoord, this._dummyInventory);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void handleStackMove(int number) {
        ur stack;
        if (MainProxy.isClient(this.worldObj)) {
            MainProxy.sendPacketToServer(new PacketPipeInteger(58, this.xCoord, this.yCoord, this.zCoord, number).getPacket());
        }
        if ((stack = this._dummyInventory.a(number)) == null) {
            return;
        }
        for (int i = 6; i < 9; ++i) {
            ur stackb = this._dummyInventory.a(i);
            if (stackb != null) continue;
            this._dummyInventory.a(i, stack);
            this._dummyInventory.a(number, null);
            break;
        }
    }

    public void priorityUp(qx player) {
        ++this.priority;
        if (MainProxy.isClient(player.p)) {
            MainProxy.sendPacketToServer(new PacketCoordinates(69, this.xCoord, this.yCoord, this.zCoord).getPacket());
        } else if (player != null && MainProxy.isServer(player.p)) {
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(68, this.xCoord, this.yCoord, this.zCoord, this.priority).getPacket(), (Player)player);
        }
    }

    public void priorityDown(qx player) {
        --this.priority;
        if (MainProxy.isClient(player.p)) {
            MainProxy.sendPacketToServer(new PacketCoordinates(70, this.xCoord, this.yCoord, this.zCoord).getPacket());
        } else if (player != null && MainProxy.isServer(player.p)) {
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(68, this.xCoord, this.yCoord, this.zCoord, this.priority).getPacket(), (Player)player);
        }
    }

    public void setPriority(int amount) {
        this.priority = amount;
    }

    public ur getCraftedItem() {
        return this._dummyInventory.a(9);
    }

    public ur getMaterials(int slotnr) {
        return this._dummyInventory.a(slotnr);
    }

    public SimpleInventory getDummyInventory() {
        return this._dummyInventory;
    }

    public void setDummyInventorySlot(int slot, ur itemstack) {
        this._dummyInventory.a(slot, itemstack);
    }

    public void setNextSatellite(qx player, int i) {
        if (MainProxy.isClient(player.p)) {
            PacketPipeInteger packet = new PacketPipeInteger(98, this.xCoord, this.yCoord, this.zCoord, i);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            this.advancedSatelliteIdArray[i] = this.getNextConnectSatelliteId(false, i, -1);
            PacketModuleInteger packet = new PacketModuleInteger(100, this.xCoord, this.yCoord, this.zCoord, i, this.advancedSatelliteIdArray[i]);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setPrevSatellite(qx player, int i) {
        if (MainProxy.isClient(player.p)) {
            PacketPipeInteger packet = new PacketPipeInteger(99, this.xCoord, this.yCoord, this.zCoord, i);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            this.advancedSatelliteIdArray[i] = this.getNextConnectSatelliteId(true, i, -1);
            PacketModuleInteger packet = new PacketModuleInteger(100, this.xCoord, this.yCoord, this.zCoord, i, this.advancedSatelliteIdArray[i]);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setParentPipe(PipeItemsCraftingLogistics pipeItemsCraftingLogistics) {
        this._pipe = pipeItemsCraftingLogistics;
    }
}

