/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.core.network.TileNetworkData;
import cpw.mods.fml.common.network.Player;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.PipeItemsSatelliteLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestManager;
import logisticspipes.utils.ItemIdentifierStack;

public class BaseLogicSatellite
extends BaseRoutingLogic
implements IRequireReliableTransport {
    public static HashSet AllSatellites = new HashSet();
    protected final LinkedList _lostItems = new LinkedList();
    @TileNetworkData
    public int satelliteId;

    public static void cleanup() {
        AllSatellites.clear();
    }

    public BaseLogicSatellite() {
        this.throttleTime = 40;
    }

    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.satelliteId = nbttagcompound.e("satelliteid");
        this.ensureAllSatelliteStatus();
    }

    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("satelliteid", this.satelliteId);
        super.writeToNBT(nbttagcompound);
    }

    protected int findId(int increment) {
        if (MainProxy.isClient(this.worldObj)) {
            return this.satelliteId;
        }
        int potentialId = this.satelliteId;
        boolean conflict = true;
        block0: while (conflict) {
            if ((potentialId += increment) < 0) {
                return 0;
            }
            conflict = false;
            for (BaseLogicSatellite sat : AllSatellites) {
                if (sat.satelliteId != potentialId) continue;
                conflict = true;
                continue block0;
            }
        }
        return potentialId;
    }

    protected void ensureAllSatelliteStatus() {
        if (MainProxy.isClient()) {
            return;
        }
        if (this.satelliteId == 0 && AllSatellites.contains(this)) {
            AllSatellites.remove(this);
        }
        if (this.satelliteId != 0 && !AllSatellites.contains(this)) {
            AllSatellites.add(this);
        }
    }

    public void setNextId(qx player) {
        this.satelliteId = this.findId(1);
        this.ensureAllSatelliteStatus();
        if (MainProxy.isClient(player.p)) {
            PacketCoordinates packet = new PacketCoordinates(6, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            PacketPipeInteger packet = new PacketPipeInteger(8, this.xCoord, this.yCoord, this.zCoord, this.satelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
        this.updateWatchers();
    }

    public void setPrevId(qx player) {
        this.satelliteId = this.findId(-1);
        this.ensureAllSatelliteStatus();
        if (MainProxy.isClient(player.p)) {
            PacketCoordinates packet = new PacketCoordinates(7, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            PacketPipeInteger packet = new PacketPipeInteger(8, this.xCoord, this.yCoord, this.zCoord, this.satelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
        this.updateWatchers();
    }

    private void updateWatchers() {
        for (qx player : ((PipeItemsSatelliteLogistics)this.container.pipe).localModeWatchers) {
            PacketPipeInteger packet = new PacketPipeInteger(8, this.xCoord, this.yCoord, this.zCoord, this.satelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    @Override
    public void destroy() {
        if (MainProxy.isClient(this.worldObj)) {
            return;
        }
        if (AllSatellites.contains(this)) {
            AllSatellites.remove(this);
        }
    }

    @Override
    public void onWrenchClicked(qx entityplayer) {
        if (MainProxy.isServer(entityplayer.p)) {
            PacketPipeInteger packet = new PacketPipeInteger(8, this.xCoord, this.yCoord, this.zCoord, this.satelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)entityplayer);
            entityplayer.openGui((Object)LogisticsPipes.instance, 13, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        Iterator iterator = this._lostItems.iterator();
        while (iterator.hasNext()) {
            ItemIdentifierStack stack = (ItemIdentifierStack)iterator.next();
            int received = RequestManager.requestPartial(stack, (CoreRoutedPipe)this.container.pipe);
            if (received <= 0) continue;
            if (received == stack.stackSize) {
                iterator.remove();
                continue;
            }
            stack.stackSize -= received;
        }
    }

    @Override
    public void itemLost(ItemIdentifierStack item) {
        this._lostItems.add(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item) {
    }

    public void setSatelliteId(int integer) {
        this.satelliteId = integer;
    }
}

