/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logistics;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IFilteringRouter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.logistics.ILogisticsManagerV2;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.PipeItemsProviderLogistics;
import logisticspipes.pipes.PipeItemsRequestLogistics;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;

public class LogisticsManagerV2
implements ILogisticsManagerV2 {
    @Override
    public Pair3 hasDestination(ItemIdentifier stack, boolean allowDefault, int sourceID, List routerIDsToExclude) {
        IRouter sourceRouter = SimpleServiceLocator.routerManager.getRouter(sourceID);
        if (sourceRouter == null) {
            return null;
        }
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(stack);
        ArrayList<ExitRoute> validDestinations = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            ExitRoute e = sourceRouter.getDistanceTo(r);
            if (e != null && e.containsFlag(PipeRoutingConnectionType.canRouteTo)) {
                validDestinations.add(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validDestinations);
        Pair3 search = this.getBestReply(stack, sourceRouter, validDestinations, true, routerIDsToExclude, new BitSet(ServerRouter.getBiggestSimpleID()), new LinkedList(), null);
        if (search.getValue2() == null) {
            return null;
        }
        if (!allowDefault && ((SinkReply)search.getValue2()).isDefault) {
            return null;
        }
        return search;
    }

    @Override
    public Pair3 hasDestinationWithMinPriority(ItemIdentifier stack, int sourceRouter, boolean excludeSource, SinkReply.FixedPriority priority) {
        if (!SimpleServiceLocator.routerManager.isRouter(sourceRouter)) {
            return null;
        }
        Pair3 search = this.getBestReply(stack, SimpleServiceLocator.routerManager.getRouter(sourceRouter), SimpleServiceLocator.routerManager.getRouter(sourceRouter).getIRoutersByCost(), excludeSource, new ArrayList(), new BitSet(ServerRouter.getBiggestSimpleID()), new LinkedList(), null);
        if (search.getValue2() == null) {
            return null;
        }
        if (((SinkReply)search.getValue2()).fixedPriority.ordinal() < priority.ordinal()) {
            return null;
        }
        return search;
    }

    private Pair3 getBestReply(ItemIdentifier stack, IRouter sourceRouter, List validDestinations, boolean excludeSource, List jamList, BitSet layer, List filters, Pair3 result) {
        LinkedList<ExitRoute> firewall = new LinkedList<ExitRoute>();
        BitSet used = (BitSet)layer.clone();
        if (result == null) {
            result = new Pair3(null, null, null);
        }
        for (IFilter filter : filters) {
            if (filter.isBlocked() != filter.isFilteredItem(stack.getUndamaged()) && !filter.blockRouting()) continue;
            return result;
        }
        for (ExitRoute candidateRouter : validDestinations) {
            LinkedList list;
            SinkReply reply;
            if (excludeSource && candidateRouter.destination.getId().equals(sourceRouter.getId()) || jamList.contains(candidateRouter.destination.getSimpleID()) || !candidateRouter.containsFlag(PipeRoutingConnectionType.canRouteTo) || used.get(candidateRouter.destination.getSimpleID())) continue;
            used.set(candidateRouter.destination.getSimpleID());
            if (candidateRouter.destination instanceof IFilteringRouter) {
                firewall.add(candidateRouter);
            }
            if ((reply = LogisticsManagerV2.canSink(candidateRouter.destination, sourceRouter, excludeSource, stack, (SinkReply)result.getValue2(), false)) == null) continue;
            if (result.getValue1() == null) {
                result.setValue1(candidateRouter.destination.getSimpleID());
                result.setValue2(reply);
                list = new LinkedList();
                list.addAll(filters);
                result.setValue3(list);
                continue;
            }
            if (reply.fixedPriority.ordinal() > ((SinkReply)result.getValue2()).fixedPriority.ordinal()) {
                result.setValue1(candidateRouter.destination.getSimpleID());
                result.setValue2(reply);
                list = new LinkedList();
                list.addAll(filters);
                result.setValue3(list);
                continue;
            }
            if (reply.fixedPriority != ((SinkReply)result.getValue2()).fixedPriority || reply.customPriority <= ((SinkReply)result.getValue2()).customPriority) continue;
            result.setValue1(candidateRouter.destination.getSimpleID());
            result.setValue2(reply);
            list = new LinkedList();
            list.addAll(filters);
            result.setValue3(list);
        }
        for (ExitRoute n : firewall) {
            IFilter filter = ((IFilteringRouter)((Object)n.destination)).getFilter();
            filters.add(filter);
            result = this.getBestReply(stack, sourceRouter, ((IFilteringRouter)((Object)n.destination)).getRouters(), excludeSource, jamList, used, filters, result);
            filters.remove(filter);
        }
        if (filters.isEmpty() && result.getValue1() != null) {
            CoreRoutedPipe pipe = SimpleServiceLocator.routerManager.getRouterUnsafe((Integer)result.getValue1(), false).getPipe();
            pipe.useEnergy(((SinkReply)result.getValue2()).energyUse);
            MainProxy.sendSpawnParticlePacket(3, pipe.xCoord, pipe.yCoord, pipe.zCoord, pipe.worldObj, 10);
        }
        return result;
    }

    public static SinkReply canSink(IRouter destination, IRouter sourceRouter, boolean excludeSource, ItemIdentifier stack, SinkReply result, boolean activeRequest) {
        SinkReply reply = null;
        ILogisticsModule module = destination.getLogisticsModule();
        CoreRoutedPipe crp = destination.getPipe();
        if (module == null) {
            return null;
        }
        if (!module.recievePassive() && !activeRequest) {
            return null;
        }
        if (crp == null || !crp.isEnabled()) {
            return null;
        }
        if (excludeSource && sourceRouter != null && destination.getPipe().sharesInventoryWith(sourceRouter.getPipe())) {
            return null;
        }
        reply = result == null ? module.sinksItem(stack, -1, 0) : module.sinksItem(stack, result.fixedPriority.ordinal(), result.customPriority);
        return reply;
    }

    @Override
    public IRoutedItem assignDestinationFor(IRoutedItem item, int sourceRouterID, boolean excludeSource) {
        IRouter sourceRouter = SimpleServiceLocator.routerManager.getRouterUnsafe(sourceRouterID, false);
        if (sourceRouter == null) {
            return item;
        }
        item.clearDestination();
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(item.getIDStack().getItem());
        ArrayList<ExitRoute> validDestinations = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            ExitRoute e = sourceRouter.getDistanceTo(r);
            if (e != null && e.containsFlag(PipeRoutingConnectionType.canRouteTo)) {
                validDestinations.add(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validDestinations);
        Pair3 bestReply = this.getBestReply(item.getIDStack().getItem(), sourceRouter, validDestinations, excludeSource, item.getJamList(), new BitSet(ServerRouter.getBiggestSimpleID()), new LinkedList(), null);
        if (bestReply.getValue1() != null) {
            item.setBufferCounter(0);
            item.setDestination((Integer)bestReply.getValue1());
            if (((SinkReply)bestReply.getValue2()).isPassive) {
                if (((SinkReply)bestReply.getValue2()).isDefault) {
                    item.setTransportMode(IRoutedItem.TransportMode.Default);
                } else {
                    item.setTransportMode(IRoutedItem.TransportMode.Passive);
                }
            } else {
                item.setTransportMode(IRoutedItem.TransportMode.Active);
            }
            LinkedList<IFilter> list = new LinkedList<IFilter>();
            if (bestReply.getValue3() != null) {
                for (IFilter filter : (List)bestReply.getValue3()) {
                    list.add(filter);
                }
            }
            item.addRelayPoints(list);
        }
        return item;
    }

    @Override
    public String getBetterRouterName(IRouter r) {
        PipeItemsCraftingLogistics pipe;
        if (r.getPipe() instanceof PipeItemsCraftingLogistics && (pipe = (PipeItemsCraftingLogistics)r.getPipe()).getCraftedItem() != null) {
            return "Crafter<" + pipe.getCraftedItem().getFriendlyName() + ">";
        }
        if (r.getPipe() instanceof PipeItemsProviderLogistics) {
            return "Provider";
        }
        if (r.getPipe() instanceof PipeLogisticsChassi) {
            return "Chassis";
        }
        if (r.getPipe() instanceof PipeItemsRequestLogistics) {
            return "Request";
        }
        return r.getId().toString();
    }

    @Override
    public HashMap getAvailableItems(List validDestinations) {
        ArrayList items = new ArrayList(ServerRouter.getBiggestSimpleID());
        for (int i = 0; i < ServerRouter.getBiggestSimpleID(); ++i) {
            items.add(new HashMap());
        }
        ArrayList<ExitRoute> filterpipes = new ArrayList<ExitRoute>();
        BitSet used = new BitSet(ServerRouter.getBiggestSimpleID());
        for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom)) continue;
            if (!(r.destination.getPipe() instanceof IProvideItems)) {
                if (!(r.destination instanceof IFilteringRouter)) continue;
                used.set(r.destination.getSimpleID(), true);
                filterpipes.add(r);
                continue;
            }
            IProvideItems iProvideItems = (IProvideItems)((Object)r.destination.getPipe());
            iProvideItems.getAllItems((Map)items.get(r.destination.getSimpleID()), new ArrayList(0));
            used.set(r.destination.getSimpleID(), true);
        }
        for (ExitRoute n : filterpipes) {
            LinkedList<IFilter> linkedList = new LinkedList<IFilter>();
            linkedList.add(((IFilteringRouter)((Object)n.destination)).getFilter());
            this.handleAvailableSubFiltering(n, items, linkedList, used);
        }
        HashMap allAvailableItems = new HashMap();
        for (Map map : items) {
            for (Map.Entry item : map.entrySet()) {
                Integer currentItem = (Integer)allAvailableItems.get(item.getKey());
                if (currentItem == null) {
                    allAvailableItems.put(item.getKey(), item.getValue());
                    continue;
                }
                allAvailableItems.put(item.getKey(), currentItem + (Integer)item.getValue());
            }
        }
        return allAvailableItems;
    }

    private void handleAvailableSubFiltering(ExitRoute route, List items, List filters, BitSet layer) {
        ArrayList<ExitRoute> filterpipes = new ArrayList<ExitRoute>();
        BitSet used = (BitSet)layer.clone();
        for (ExitRoute n : ((IFilteringRouter)((Object)route.destination)).getRouters()) {
            if (n == null || !n.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(n.destination.getSimpleID())) continue;
            if (!(n.destination.getPipe() instanceof IProvideItems)) {
                if (!(n.destination instanceof IFilteringRouter)) continue;
                used.set(n.destination.getSimpleID(), true);
                filterpipes.add(n);
                continue;
            }
            IProvideItems provider = (IProvideItems)((Object)n.destination.getPipe());
            provider.getAllItems((Map)items.get(route.destination.getSimpleID()), filters);
            used.set(n.destination.getSimpleID(), true);
        }
        for (ExitRoute n : filterpipes) {
            IFilter filter = ((IFilteringRouter)((Object)n.destination)).getFilter();
            filters.add(filter);
            this.handleAvailableSubFiltering(n, items, filters, used);
            filters.remove(filter);
        }
    }

    @Override
    public LinkedList getCraftableItems(List validDestinations) {
        LinkedList<ItemIdentifier> craftableItems = new LinkedList<ItemIdentifier>();
        ArrayList<ExitRoute> filterpipes = new ArrayList<ExitRoute>();
        BitSet used = new BitSet(ServerRouter.getBiggestSimpleID());
        for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(r.destination.getSimpleID())) continue;
            if (!(r.destination.getPipe() instanceof ICraftItems)) {
                if (!(r.destination instanceof IFilteringRouter)) continue;
                used.set(r.destination.getSimpleID(), true);
                filterpipes.add(r);
                continue;
            }
            ICraftItems crafter = (ICraftItems)((Object)r.destination.getPipe());
            ItemIdentifier craftedItem = crafter.getCraftedItem();
            if (craftedItem != null && !craftableItems.contains(craftedItem)) {
                craftableItems.add(craftedItem);
            }
            used.set(r.destination.getSimpleID(), true);
        }
        for (ExitRoute n : filterpipes) {
            LinkedList<IFilter> list = new LinkedList<IFilter>();
            list.add(((IFilteringRouter)((Object)n.destination)).getFilter());
            this.handleCraftableItemsSubFiltering(n, craftableItems, list, used);
        }
        return craftableItems;
    }

    private void handleCraftableItemsSubFiltering(ExitRoute route, LinkedList craftableItems, List filters, BitSet layer) {
        if (!route.containsFlag(PipeRoutingConnectionType.canRequestFrom)) {
            return;
        }
        ArrayList<ExitRoute> filterpipes = new ArrayList<ExitRoute>();
        BitSet used = (BitSet)layer.clone();
        block0: for (ExitRoute n : ((IFilteringRouter)((Object)route.destination)).getRouters()) {
            if (n == null || !n.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(n.destination.getSimpleID())) continue;
            if (!(n.destination.getPipe() instanceof ICraftItems)) {
                if (!(n.destination instanceof IFilteringRouter)) continue;
                used.set(n.destination.getSimpleID(), true);
                filterpipes.add(n);
                continue;
            }
            ICraftItems crafter = (ICraftItems)((Object)n.destination.getPipe());
            ItemIdentifier craftedItem = crafter.getCraftedItem();
            if (craftedItem != null) {
                for (IFilter filter : filters) {
                    if (filter.isBlocked() != filter.isFilteredItem(craftedItem.getUndamaged()) && !filter.blockCrafting()) continue;
                    continue block0;
                }
                if (!craftableItems.contains(craftedItem)) {
                    craftableItems.add(craftedItem);
                }
            }
            used.set(n.destination.getSimpleID(), true);
        }
        for (ExitRoute n : filterpipes) {
            IFilter filter = ((IFilteringRouter)((Object)n.destination)).getFilter();
            filters.add(filter);
            this.handleCraftableItemsSubFiltering(n, craftableItems, filters, used);
            filters.remove(filter);
        }
    }
}

