/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SinkReply;

public class ChassiModule
implements ILogisticsGuiModule {
    private final ILogisticsModule[] _modules;
    private final PipeLogisticsChassi _parentPipe;

    public ChassiModule(int moduleCount, PipeLogisticsChassi parentPipe) {
        this._modules = new ILogisticsModule[moduleCount];
        this._parentPipe = parentPipe;
    }

    public void installModule(int slot, ILogisticsModule module) {
        this._modules[slot] = module;
    }

    public void removeModule(int slot) {
        this._modules[slot] = null;
    }

    public ILogisticsModule getModule(int slot) {
        return this._modules[slot];
    }

    public boolean hasModule(int slot) {
        return this._modules[slot] != null;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority) {
        SinkReply bestresult = null;
        for (ILogisticsModule module : this._modules) {
            SinkReply result;
            if (module == null || (result = module.sinksItem(item, bestPriority, bestCustomPriority)) == null) continue;
            bestresult = result;
            bestPriority = result.fixedPriority.ordinal();
            bestCustomPriority = result.customPriority;
        }
        if (bestresult == null) {
            return null;
        }
        la inv = this._parentPipe.getSneakyInventory();
        if (inv == null) {
            return null;
        }
        IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv);
        int roomForItem = invUtil.roomForItem(item);
        if (roomForItem < 1) {
            return null;
        }
        if (bestresult.maxNumberOfItems == 0) {
            return new SinkReply(bestresult, roomForItem);
        }
        return new SinkReply(bestresult, Math.min(bestresult.maxNumberOfItems, roomForItem));
    }

    @Override
    public int getGuiHandlerID() {
        return 26;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        if (slot < 0 || slot >= this._modules.length) {
            return null;
        }
        return this._modules[slot];
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        for (int i = 0; i < this._modules.length; ++i) {
            bq slot;
            if (this._modules[i] == null || (slot = nbttagcompound.l("slot" + i)) == null) continue;
            this._modules[i].readFromNBT(slot);
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        for (int i = 0; i < this._modules.length; ++i) {
            if (this._modules[i] == null) continue;
            bq slot = new bq();
            this._modules[i].writeToNBT(slot);
            nbttagcompound.a("slot" + i, (cd)slot);
        }
    }

    @Override
    public void tick() {
        for (ILogisticsModule module : this._modules) {
            if (module == null) continue;
            module.tick();
        }
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        for (ILogisticsModule module : this._modules) {
            if (module == null || !module.recievePassive()) continue;
            return true;
        }
        return false;
    }
}

